/*
 * Decompiled with CFR 0.152.
 */
package jpt.sun.tools.javap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import jpt.sun.tools.classfile.Code_attribute;
import jpt.sun.tools.classfile.ConstantPool;
import jpt.sun.tools.classfile.ConstantPoolException;
import jpt.sun.tools.classfile.Descriptor;
import jpt.sun.tools.classfile.Instruction;
import jpt.sun.tools.classfile.LocalVariableTable_attribute;
import jpt.sun.tools.javap.ClassWriter;
import jpt.sun.tools.javap.Context;
import jpt.sun.tools.javap.InstructionDetailWriter;

public class LocalVariableTableWriter
extends InstructionDetailWriter {
    private ClassWriter classWriter;
    private Code_attribute codeAttr;
    private Map<Integer, List<LocalVariableTable_attribute.Entry>> pcMap;

    static LocalVariableTableWriter instance(Context context) {
        LocalVariableTableWriter instance = context.get(LocalVariableTableWriter.class);
        if (instance == null) {
            instance = new LocalVariableTableWriter(context);
        }
        return instance;
    }

    protected LocalVariableTableWriter(Context context) {
        super(context);
        context.put(LocalVariableTableWriter.class, this);
        this.classWriter = ClassWriter.instance(context);
    }

    public void reset(Code_attribute attr) {
        this.codeAttr = attr;
        this.pcMap = new HashMap<Integer, List<LocalVariableTable_attribute.Entry>>();
        LocalVariableTable_attribute lvt = (LocalVariableTable_attribute)attr.attributes.get("LocalVariableTable");
        if (lvt == null) {
            return;
        }
        for (int i = 0; i < lvt.local_variable_table.length; ++i) {
            LocalVariableTable_attribute.Entry entry = lvt.local_variable_table[i];
            this.put(entry.start_pc, entry);
            this.put(entry.start_pc + entry.length, entry);
        }
    }

    @Override
    public void writeDetails(Instruction instr) {
        int pc = instr.getPC();
        this.writeLocalVariables(pc, NoteKind.END);
        this.writeLocalVariables(pc, NoteKind.START);
    }

    @Override
    public void flush() {
        int pc = this.codeAttr.code_length;
        this.writeLocalVariables(pc, NoteKind.END);
    }

    public void writeLocalVariables(int pc, NoteKind kind) {
        ConstantPool constant_pool = this.classWriter.getClassFile().constant_pool;
        String indent = this.space(2);
        List<LocalVariableTable_attribute.Entry> entries = this.pcMap.get(pc);
        if (entries != null) {
            ListIterator<LocalVariableTable_attribute.Entry> iter = entries.listIterator(kind == NoteKind.END ? entries.size() : 0);
            while (kind == NoteKind.END ? iter.hasPrevious() : iter.hasNext()) {
                LocalVariableTable_attribute.Entry entry = kind == NoteKind.END ? iter.previous() : iter.next();
                if (!kind.match(entry, pc)) continue;
                this.print(indent);
                this.print(kind.text);
                this.print(" local ");
                this.print(entry.index);
                this.print(" // ");
                Descriptor d = new Descriptor(entry.descriptor_index);
                try {
                    this.print(d.getFieldType(constant_pool));
                }
                catch (Descriptor.InvalidDescriptor e) {
                    this.print(this.report(e));
                }
                catch (ConstantPoolException e) {
                    this.print(this.report(e));
                }
                this.print(" ");
                try {
                    this.print(constant_pool.getUTF8Value(entry.name_index));
                }
                catch (ConstantPoolException e) {
                    this.print(this.report(e));
                }
                this.println();
            }
        }
    }

    private void put(int pc, LocalVariableTable_attribute.Entry entry) {
        List<LocalVariableTable_attribute.Entry> list = this.pcMap.get(pc);
        if (list == null) {
            list = new ArrayList<LocalVariableTable_attribute.Entry>();
            this.pcMap.put(pc, list);
        }
        if (!list.contains(entry)) {
            list.add(entry);
        }
    }

    public static enum NoteKind {
        START("start"){

            @Override
            public boolean match(LocalVariableTable_attribute.Entry entry, int pc) {
                return pc == entry.start_pc;
            }
        }
        ,
        END("end"){

            @Override
            public boolean match(LocalVariableTable_attribute.Entry entry, int pc) {
                return pc == entry.start_pc + entry.length;
            }
        };

        public final String text;

        private NoteKind(String text) {
            this.text = text;
        }

        public abstract boolean match(LocalVariableTable_attribute.Entry var1, int var2);
    }
}

