/*
 * Decompiled with CFR 0.152.
 */
package org.apache.myfaces.portlet.faces.application;

import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.faces.application.StateManager;
import javax.faces.application.StateManagerWrapper;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.portlet.faces.BridgeUtil;

public class PortletStateManagerImpl
extends StateManagerWrapper {
    private StateManager mDelegatee = null;

    public PortletStateManagerImpl(StateManager sm) {
        this.mDelegatee = sm;
    }

    public void writeState(FacesContext context, Object state) throws IOException {
        if (!BridgeUtil.isPortletRequest()) {
            super.writeState(context, state);
            return;
        }
        ResponseWriter oldRW = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter(128);
        ResponseWriter newRW = oldRW.cloneWithWriter((Writer)stringWriter);
        context.setResponseWriter(newRW);
        super.writeState(context, state);
        context.setResponseWriter(oldRW);
        newRW.flush();
        String stateValue = new String(stringWriter.getBuffer());
        oldRW.write(stateValue);
        stateValue = this.extractViewStateParamValue(stateValue);
        if (stateValue != null) {
            Map m = context.getExternalContext().getRequestMap();
            m.put("org.apache.myfaces.portlet.faces.updatedViewStateParam", stateValue);
        }
    }

    public void writeState(FacesContext context, StateManager.SerializedView state) throws IOException {
        if (!BridgeUtil.isPortletRequest()) {
            super.writeState(context, state);
            return;
        }
        ResponseWriter oldRW = context.getResponseWriter();
        StringWriter stringWriter = new StringWriter(128);
        ResponseWriter newRW = oldRW.cloneWithWriter((Writer)stringWriter);
        context.setResponseWriter(newRW);
        super.writeState(context, state);
        context.setResponseWriter(oldRW);
        newRW.flush();
        String stateValue = new String(stringWriter.getBuffer());
        oldRW.write(stateValue);
        stateValue = this.extractViewStateParamValue(stateValue);
        if (stateValue != null) {
            Map m = context.getExternalContext().getRequestMap();
            m.put("org.apache.myfaces.portlet.faces.updatedViewStateParam", stateValue);
        }
    }

    public StateManager getWrapped() {
        return this.mDelegatee;
    }

    private String extractViewStateParamValue(String buf) {
        int i = buf.indexOf("javax.faces.ViewState");
        if (i < 0) {
            return null;
        }
        int end = buf.indexOf("/>", i);
        if (end < 0) {
            end = buf.indexOf(">", i);
        }
        if (end < 0) {
            return null;
        }
        int valStart = buf.indexOf("value", i);
        if (valStart < 0 || valStart > end) {
            buf = buf.substring(0, end);
            end = buf.length() - 1;
            i = buf.lastIndexOf("<");
            if (i < 0) {
                return null;
            }
            valStart = buf.indexOf("value", i);
            if (valStart < 0) {
                return null;
            }
        }
        if ((valStart = buf.indexOf(34, valStart)) < 0) {
            return null;
        }
        int valEnd = buf.indexOf(34, valStart + 1);
        if (valEnd < 0 || valEnd > end) {
            return null;
        }
        return buf.substring(valStart + 1, valEnd);
    }
}

