/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ftpserver.ftplet;

import org.apache.ftpserver.ftplet.FtpReply;

public class DefaultFtpReply
implements FtpReply {
    private int code;
    private String message;
    private long sentTime = 0L;
    private static final String CRLF = "\r\n";

    public DefaultFtpReply(int code, String message) {
        this.code = code;
        this.message = message;
        this.sentTime = System.currentTimeMillis();
    }

    public DefaultFtpReply(int code, String[] message) {
        this.code = code;
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < message.length; ++i) {
            sb.append(message[i]);
            sb.append('\n');
        }
        this.message = sb.toString();
        this.sentTime = System.currentTimeMillis();
    }

    @Override
    public int getCode() {
        return this.code;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public long getSentTime() {
        return this.sentTime;
    }

    @Override
    public boolean isPositive() {
        return this.code < 400;
    }

    private boolean isDigit(char c) {
        return c >= '0' && c <= '9';
    }

    @Override
    public String toString() {
        String[] lines;
        int code = this.getCode();
        String notNullMessage = this.getMessage();
        if (notNullMessage == null) {
            notNullMessage = "";
        }
        StringBuilder sb = new StringBuilder();
        if ((notNullMessage = notNullMessage.replace("\r", "")).endsWith("\n")) {
            notNullMessage = notNullMessage.substring(0, notNullMessage.length() - 1);
        }
        if ((lines = notNullMessage.split("\n")).length == 1) {
            sb.append(code);
            sb.append(" ");
            sb.append(notNullMessage);
            sb.append(CRLF);
        } else {
            sb.append(code);
            sb.append("-");
            for (int i = 0; i < lines.length; ++i) {
                String line = lines[i];
                if (i + 1 == lines.length) {
                    sb.append(code);
                    sb.append(" ");
                }
                if (i > 0 && i + 1 < lines.length && line.length() > 2 && this.isDigit(line.charAt(0)) && this.isDigit(line.charAt(1)) && this.isDigit(line.charAt(2))) {
                    sb.append("  ");
                }
                sb.append(line);
                sb.append(CRLF);
            }
        }
        return sb.toString();
    }
}

