/*
 * Decompiled with CFR 0.152.
 */
package com.github.sommeri.less4j.core.ast;

import com.github.sommeri.less4j.core.ast.ASTCssNode;
import com.github.sommeri.less4j.core.ast.ASTCssNodeType;
import com.github.sommeri.less4j.core.ast.ElementSubsequent;
import com.github.sommeri.less4j.core.ast.Extend;
import com.github.sommeri.less4j.core.ast.NestedSelectorAppender;
import com.github.sommeri.less4j.core.ast.ReusableStructureName;
import com.github.sommeri.less4j.core.ast.SelectorPart;
import com.github.sommeri.less4j.core.ast.SimpleSelector;
import com.github.sommeri.less4j.core.ast.annotations.NotAstProperty;
import com.github.sommeri.less4j.core.parser.HiddenTokenAwareTree;
import com.github.sommeri.less4j.utils.ArraysUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;

public class Selector
extends ASTCssNode
implements Cloneable {
    private List<SelectorPart> combinedParts = new ArrayList<SelectorPart>();
    private List<Extend> extend = new ArrayList<Extend>();

    public Selector(HiddenTokenAwareTree token) {
        super(token);
    }

    public Selector(HiddenTokenAwareTree token, SelectorPart head) {
        this(token, ArraysUtils.asModifiableList(head));
    }

    public Selector(HiddenTokenAwareTree token, List<SelectorPart> combinedParts) {
        super(token);
        this.combinedParts = combinedParts;
    }

    public List<SelectorPart> getParts() {
        return this.combinedParts;
    }

    public void addPart(SelectorPart part) {
        this.combinedParts.add(part);
    }

    public void addParts(List<SelectorPart> parts) {
        this.combinedParts.addAll(parts);
    }

    public void removeHead() {
        this.combinedParts.remove(0);
    }

    public boolean isExtending() {
        return !this.extend.isEmpty();
    }

    public List<Extend> getExtend() {
        return this.extend;
    }

    public void setExtend(List<Extend> extend) {
        this.extend = extend;
    }

    @NotAstProperty
    public SelectorPart getHead() {
        List<SelectorPart> parts = this.getParts();
        if (parts.isEmpty()) {
            return null;
        }
        return parts.get(0);
    }

    @Override
    @NotAstProperty
    public List<? extends ASTCssNode> getChilds() {
        ArrayList<ASTCssNode> result = new ArrayList<ASTCssNode>(this.combinedParts.size() + this.extend.size());
        result.addAll(this.combinedParts);
        result.addAll(this.extend);
        return result;
    }

    @Override
    public ASTCssNodeType getType() {
        return ASTCssNodeType.SELECTOR;
    }

    @Override
    public Selector clone() {
        Selector clone = (Selector)super.clone();
        clone.combinedParts = ArraysUtils.deeplyClonedList(this.combinedParts);
        clone.extend = ArraysUtils.deeplyClonedList(this.extend);
        clone.configureParentToAllChilds();
        return clone;
    }

    @NotAstProperty
    public SelectorPart getLastPart() {
        return ArraysUtils.last(this.getParts());
    }

    public boolean isCombined() {
        return this.combinedParts.size() > 1;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Selector [");
        builder.append(this.combinedParts);
        builder.append("]");
        return builder.toString();
    }

    public NestedSelectorAppender findFirstAppender() {
        for (SelectorPart part : this.getParts()) {
            if (!part.isAppender()) continue;
            return (NestedSelectorAppender)part;
        }
        return null;
    }

    public boolean containsAppender() {
        return this.findFirstAppender() != null;
    }

    public boolean isReusableSelector() {
        Iterator<SelectorPart> parts = this.getParts().iterator();
        if (!parts.hasNext()) {
            return false;
        }
        SelectorPart current = parts.next();
        while (current.isAppender() && parts.hasNext()) {
            current = parts.next();
        }
        while (current.isClassesAndIdsOnlySelector() && parts.hasNext()) {
            current = parts.next();
        }
        return current.isClassesAndIdsOnlySelector();
    }

    public ReusableStructureName toReusableStructureName() {
        List<ElementSubsequent> nameParts = this.extractReusableNameParts();
        ReusableStructureName result = new ReusableStructureName(nameParts.get(0).getUnderlyingStructure(), nameParts);
        return result;
    }

    private List<ElementSubsequent> extractReusableNameParts() {
        ArrayList<ElementSubsequent> result = new ArrayList<ElementSubsequent>();
        for (SelectorPart part : this.getParts()) {
            if (part.isAppender()) continue;
            result.addAll(((SimpleSelector)part).getSubsequent());
        }
        return result;
    }

    public boolean hasLeadingCombinator() {
        if (this.getHead() == null) {
            return false;
        }
        return this.getHead().hasLeadingCombinator();
    }

    public boolean isEmpty() {
        return this.getParts().isEmpty();
    }

    public void addExtend(Extend extend) {
        this.extend.add(extend);
    }

    public void addExtends(Collection<Extend> newExtends) {
        this.extend.addAll(newExtends);
    }

    public void setParts(List<SelectorPart> newParts) {
        this.combinedParts = newParts;
    }
}

