/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.lockmanager;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.ManifoldCF;
import org.apache.zookeeper.CreateMode;
import org.apache.zookeeper.KeeperException;
import org.apache.zookeeper.WatchedEvent;
import org.apache.zookeeper.Watcher;
import org.apache.zookeeper.ZooDefs;
import org.apache.zookeeper.ZooKeeper;
import org.apache.zookeeper.data.Stat;

public class ZooKeeperConnection {
    public static final String _rcsid = "@(#)$Id: ZooKeeperConnection.java 1642871 2014-12-02 14:00:08Z kwright $";
    private static final String READ_PREFIX = "read-";
    private static final String NONEXWRITE_PREFIX = "nonexwrite-";
    private static final String WRITE_PREFIX = "write-";
    private static final String CHILD_PREFIX = "child-";
    protected final String connectString;
    protected final int sessionTimeout;
    protected ZooKeeper zookeeper = null;
    protected ZooKeeperWatcher zookeeperWatcher = null;
    protected String lockNode = null;
    protected String nodePath = null;
    protected byte[] nodeData = null;

    public ZooKeeperConnection(String connectString, int sessionTimeout) throws ManifoldCFException, InterruptedException {
        this.connectString = connectString;
        this.sessionTimeout = sessionTimeout;
        this.zookeeperWatcher = new ZooKeeperWatcher();
        this.createSession();
    }

    protected void createSession() throws ManifoldCFException, InterruptedException {
        try {
            this.zookeeper = new ZooKeeper(this.connectString, this.sessionTimeout, (Watcher)this.zookeeperWatcher);
        }
        catch (InterruptedIOException e) {
            throw new InterruptedException(e.getMessage());
        }
        catch (IOException e) {
            throw new ManifoldCFException("Zookeeper initialization error: " + e.getMessage(), e);
        }
    }

    public void createNode(String nodePath, byte[] nodeData) throws ManifoldCFException, InterruptedException {
        if (this.nodePath != null) {
            throw new IllegalStateException("Ephemeral node '" + this.nodePath + "' already open; can't open '" + nodePath + "'.");
        }
        while (true) {
            try {
                if (this.nodePath != null) break;
                this.zookeeper.create(nodePath, nodeData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                this.nodePath = nodePath;
                this.nodeData = nodeData;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, false);
                continue;
            }
            break;
        }
    }

    public boolean checkNodeExists(String nodePath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.exists(nodePath, false) != null;
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public byte[] getNodeData(String nodePath) throws ManifoldCFException, InterruptedException {
        return this.readData(nodePath);
    }

    public void setNodeData(byte[] data) throws ManifoldCFException, InterruptedException {
        if (this.nodePath == null) {
            throw new IllegalStateException("Can't set data for a node path we did not create: '" + this.nodePath + "'");
        }
        this.writeData(this.nodePath, data);
        this.nodeData = data;
    }

    public void deleteNode() throws ManifoldCFException, InterruptedException {
        if (this.nodePath == null) {
            throw new IllegalStateException("Can't delete ephemeral node that isn't registered: '" + this.nodePath + "'");
        }
        while (true) {
            try {
                if (this.nodePath != null) {
                    this.zookeeper.delete(this.nodePath, -1);
                    this.nodePath = null;
                    this.nodeData = null;
                }
                return;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, false);
                continue;
            }
            break;
        }
    }

    public void deleteNodeChildren(String nodePath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                List children = this.zookeeper.getChildren(nodePath, false);
                for (String child : children) {
                    this.zookeeper.delete(nodePath + "/" + child, -1);
                }
            }
            catch (KeeperException.NoNodeException e) {
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public List<String> getChildren(String nodePath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                List children = this.zookeeper.getChildren(nodePath, false);
                ArrayList<String> rval = new ArrayList<String>();
                for (String child : children) {
                    if (!child.startsWith(CHILD_PREFIX)) continue;
                    rval.add(child.substring(CHILD_PREFIX.length()));
                }
                return rval;
            }
            catch (KeeperException.NoNodeException e) {
                return new ArrayList<String>();
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void createChild(String nodePath, String childName) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                this.createPersistentPath(nodePath + "/child-" + childName, null);
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    protected void createPersistentPath(String path, byte[] data) throws KeeperException, InterruptedException {
        while (true) {
            try {
                this.zookeeper.create(path, data, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
            }
            catch (KeeperException.NoNodeException e) {
                int lastIndex = path.lastIndexOf("/");
                if (lastIndex == -1 || lastIndex == 0) {
                    throw e;
                }
                this.createPersistentPath(path.substring(0, lastIndex), null);
                continue;
            }
            catch (KeeperException.NodeExistsException e) {
                if (data == null) break;
                try {
                    this.zookeeper.setData(path, data, -1);
                }
                catch (KeeperException.NoNodeException e2) {
                    continue;
                }
            }
            break;
        }
    }

    public void deleteChild(String nodePath, String childName) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                this.zookeeper.delete(nodePath + "/child-" + childName, -1);
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public boolean obtainWriteLockNoWait(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also write lock '" + lockPath + "'");
        }
        while (true) {
            try {
                if (this.lockNode == null) {
                    this.lockNode = this.createSequentialChild(lockPath, WRITE_PREFIX);
                }
                String lockSequenceNumber = this.lockNode.substring(lockPath.length() + 1 + WRITE_PREFIX.length());
                List children = this.zookeeper.getChildren(lockPath, false);
                for (String x : children) {
                    String otherLock;
                    if (x.startsWith(WRITE_PREFIX)) {
                        otherLock = x.substring(WRITE_PREFIX.length());
                    } else if (x.startsWith(NONEXWRITE_PREFIX)) {
                        otherLock = x.substring(NONEXWRITE_PREFIX.length());
                    } else {
                        if (!x.startsWith(READ_PREFIX)) continue;
                        otherLock = x.substring(READ_PREFIX.length());
                    }
                    if (otherLock.compareTo(lockSequenceNumber) >= 0) continue;
                    this.releaseLock();
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void obtainWriteLock(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also write lock '" + lockPath + "'");
        }
        while (true) {
            try {
                if (this.lockNode == null) {
                    this.lockNode = this.createSequentialChild(lockPath, WRITE_PREFIX);
                }
                long lockSequenceNumber = new Long(this.lockNode.substring(lockPath.length() + 1 + WRITE_PREFIX.length()));
                while (true) {
                    List children = this.zookeeper.getChildren(lockPath, false);
                    String previousLock = null;
                    boolean gotLock = true;
                    long highestPreviousLockIndex = -1L;
                    for (String x : children) {
                        long otherLockSequenceNumber;
                        String otherLock;
                        if (x.startsWith(WRITE_PREFIX)) {
                            otherLock = x.substring(WRITE_PREFIX.length());
                        } else if (x.startsWith(NONEXWRITE_PREFIX)) {
                            otherLock = x.substring(NONEXWRITE_PREFIX.length());
                        } else {
                            if (!x.startsWith(READ_PREFIX)) continue;
                            otherLock = x.substring(READ_PREFIX.length());
                        }
                        if ((otherLockSequenceNumber = new Long(otherLock).longValue()) >= lockSequenceNumber) continue;
                        gotLock = false;
                        if (otherLockSequenceNumber <= highestPreviousLockIndex) continue;
                        previousLock = x;
                        highestPreviousLockIndex = otherLockSequenceNumber;
                    }
                    if (gotLock) {
                        return;
                    }
                    if (previousLock == null) continue;
                    ExistsWatcher w = new ExistsWatcher();
                    Stat s = this.zookeeper.exists(lockPath + "/" + previousLock, (Watcher)w);
                    if (s == null) continue;
                    w.waitForEvent();
                }
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public boolean obtainNonExWriteLockNoWait(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also non-ex write lock '" + lockPath + "'");
        }
        while (true) {
            try {
                String lockSequenceNumber;
                List children;
                block7: do {
                    if (this.lockNode == null) {
                        this.lockNode = this.createSequentialChild(lockPath, NONEXWRITE_PREFIX);
                    }
                    lockSequenceNumber = this.lockNode.substring(lockPath.length() + 1 + NONEXWRITE_PREFIX.length());
                    children = null;
                    while (true) {
                        try {
                            children = this.zookeeper.getChildren(lockPath, false);
                            continue block7;
                        }
                        catch (KeeperException.NoNodeException e) {
                            continue block7;
                        }
                        catch (KeeperException e) {
                            this.handleKeeperException(e, true);
                            continue;
                        }
                        break;
                    }
                } while (children == null);
                for (String x : children) {
                    String otherLock;
                    if (x.startsWith(WRITE_PREFIX)) {
                        otherLock = x.substring(WRITE_PREFIX.length());
                    } else {
                        if (!x.startsWith(READ_PREFIX)) continue;
                        otherLock = x.substring(READ_PREFIX.length());
                    }
                    if (otherLock.compareTo(lockSequenceNumber) >= 0) continue;
                    this.releaseLock();
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void obtainNonExWriteLock(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also non-ex write lock '" + lockPath + "'");
        }
        while (true) {
            try {
                block7: while (true) {
                    if (this.lockNode == null) {
                        this.lockNode = this.createSequentialChild(lockPath, NONEXWRITE_PREFIX);
                    }
                    long lockSequenceNumber = new Long(this.lockNode.substring(lockPath.length() + 1 + NONEXWRITE_PREFIX.length()));
                    while (true) {
                        List children = null;
                        while (true) {
                            try {
                                children = this.zookeeper.getChildren(lockPath, false);
                            }
                            catch (KeeperException.NoNodeException e) {
                            }
                            catch (KeeperException e) {
                                this.handleKeeperException(e, true);
                                continue;
                            }
                            break;
                        }
                        if (children == null) continue block7;
                        String previousLock = null;
                        boolean gotLock = true;
                        long highestPreviousLockIndex = -1L;
                        for (String x : children) {
                            long otherLockSequenceNumber;
                            String otherLock;
                            if (x.startsWith(WRITE_PREFIX)) {
                                otherLock = x.substring(WRITE_PREFIX.length());
                            } else {
                                if (!x.startsWith(READ_PREFIX)) continue;
                                otherLock = x.substring(READ_PREFIX.length());
                            }
                            if ((otherLockSequenceNumber = new Long(otherLock).longValue()) >= lockSequenceNumber) continue;
                            gotLock = false;
                            if (otherLockSequenceNumber <= highestPreviousLockIndex) continue;
                            previousLock = x;
                            highestPreviousLockIndex = otherLockSequenceNumber;
                        }
                        if (gotLock) {
                            return;
                        }
                        if (previousLock == null) continue;
                        ExistsWatcher w = new ExistsWatcher();
                        Stat s = this.zookeeper.exists(lockPath + "/" + previousLock, (Watcher)w);
                        if (s == null) continue;
                        w.waitForEvent();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public boolean obtainReadLockNoWait(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also read lock '" + lockPath + "'");
        }
        while (true) {
            try {
                String lockSequenceNumber;
                List children;
                block7: do {
                    if (this.lockNode == null) {
                        this.lockNode = this.createSequentialChild(lockPath, READ_PREFIX);
                    }
                    lockSequenceNumber = this.lockNode.substring(lockPath.length() + 1 + READ_PREFIX.length());
                    children = null;
                    while (true) {
                        try {
                            children = this.zookeeper.getChildren(lockPath, false);
                            continue block7;
                        }
                        catch (KeeperException.NoNodeException e) {
                            continue block7;
                        }
                        catch (KeeperException e) {
                            this.handleKeeperException(e, true);
                            continue;
                        }
                        break;
                    }
                } while (children == null);
                for (String x : children) {
                    String otherLock;
                    if (x.startsWith(WRITE_PREFIX)) {
                        otherLock = x.substring(WRITE_PREFIX.length());
                    } else {
                        if (!x.startsWith(NONEXWRITE_PREFIX)) continue;
                        otherLock = x.substring(NONEXWRITE_PREFIX.length());
                    }
                    if (otherLock.compareTo(lockSequenceNumber) >= 0) continue;
                    this.releaseLock();
                    return false;
                }
                return true;
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void obtainReadLock(String lockPath) throws ManifoldCFException, InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Already have a lock in place: '" + this.lockNode + "'; can't also read lock '" + lockPath + "'");
        }
        while (true) {
            try {
                block7: while (true) {
                    if (this.lockNode == null) {
                        this.lockNode = this.createSequentialChild(lockPath, READ_PREFIX);
                    }
                    long lockSequenceNumber = new Long(this.lockNode.substring(lockPath.length() + 1 + READ_PREFIX.length()));
                    while (true) {
                        List children = null;
                        while (true) {
                            try {
                                children = this.zookeeper.getChildren(lockPath, false);
                            }
                            catch (KeeperException.NoNodeException e) {
                            }
                            catch (KeeperException e) {
                                this.handleKeeperException(e, true);
                                continue;
                            }
                            break;
                        }
                        if (children == null) continue block7;
                        String previousLock = null;
                        boolean gotLock = true;
                        long highestPreviousLockIndex = -1L;
                        for (String x : children) {
                            long otherLockSequenceNumber;
                            String otherLock;
                            if (x.startsWith(WRITE_PREFIX)) {
                                otherLock = x.substring(WRITE_PREFIX.length());
                            } else {
                                if (!x.startsWith(NONEXWRITE_PREFIX)) continue;
                                otherLock = x.substring(NONEXWRITE_PREFIX.length());
                            }
                            if ((otherLockSequenceNumber = new Long(otherLock).longValue()) >= lockSequenceNumber) continue;
                            gotLock = false;
                            if (otherLockSequenceNumber <= highestPreviousLockIndex) continue;
                            previousLock = x;
                            highestPreviousLockIndex = otherLockSequenceNumber;
                        }
                        if (gotLock) {
                            return;
                        }
                        if (previousLock == null) continue;
                        ExistsWatcher w = new ExistsWatcher();
                        Stat s = this.zookeeper.exists(lockPath + "/" + previousLock, (Watcher)w);
                        if (s == null) continue;
                        w.waitForEvent();
                    }
                    break;
                }
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void releaseLock() throws ManifoldCFException, InterruptedException {
        if (this.lockNode == null) {
            throw new IllegalStateException("Can't release lock we don't hold");
        }
        while (this.lockNode != null) {
            try {
                this.zookeeper.delete(this.lockNode, -1);
                this.lockNode = null;
                break;
            }
            catch (InterruptedException e) {
                this.lockNode = null;
                throw e;
            }
            catch (KeeperException e) {
                this.handleEphemeralNodeKeeperException(e, true);
            }
        }
    }

    public byte[] readData(String resourcePath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.getData(resourcePath, false, null);
            }
            catch (KeeperException.NoNodeException e) {
                return null;
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void writeData(String resourcePath, byte[] data) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                if (data == null) {
                    try {
                        this.zookeeper.delete(resourcePath, -1);
                    }
                    catch (KeeperException.NoNodeException noNodeException) {}
                    break;
                }
                try {
                    this.zookeeper.setData(resourcePath, data, -1);
                }
                catch (KeeperException.NoNodeException e) {
                    this.createPersistentPath(resourcePath, data);
                }
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void setGlobalFlag(String flagPath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                this.createPersistentPath(flagPath, null);
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void clearGlobalFlag(String flagPath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                try {
                    this.zookeeper.delete(flagPath, -1);
                }
                catch (KeeperException.NoNodeException noNodeException) {}
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public boolean checkGlobalFlag(String flagPath) throws ManifoldCFException, InterruptedException {
        while (true) {
            try {
                Stat s = this.zookeeper.exists(flagPath, false);
                return s != null;
            }
            catch (KeeperException e) {
                this.handleKeeperException(e, true);
                continue;
            }
            break;
        }
    }

    public void close() throws InterruptedException {
        if (this.lockNode != null) {
            throw new IllegalStateException("Should not be closing handles that have open locks!  Locknode: '" + this.lockNode + "'");
        }
        this.zookeeper.close();
        this.zookeeper = null;
        this.zookeeperWatcher = null;
    }

    protected void handleEphemeralNodeKeeperException(KeeperException e, boolean recreate) throws ManifoldCFException, InterruptedException {
        block6: {
            if (e instanceof KeeperException.ConnectionLossException || e instanceof KeeperException.SessionExpiredException) {
                while (true) {
                    try {
                        this.lockNode = null;
                        if (!recreate) {
                            this.nodePath = null;
                            this.nodeData = null;
                        }
                        this.zookeeper.close();
                        this.createSession();
                        if (this.nodePath != null) {
                            this.zookeeper.create(this.nodePath, this.nodeData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                        }
                        break block6;
                    }
                    catch (KeeperException e2) {
                        if (e2 instanceof KeeperException.ConnectionLossException || e2 instanceof KeeperException.SessionExpiredException) continue;
                        throw new ManifoldCFException(e2.getMessage(), e2);
                    }
                    break;
                }
            }
            throw new ManifoldCFException(e.getMessage(), e);
        }
    }

    protected void handleKeeperException(KeeperException e, boolean recreate) throws ManifoldCFException, InterruptedException {
        block8: {
            if (e instanceof KeeperException.ConnectionLossException) {
                ManifoldCF.sleep(100L);
            } else {
                if (e instanceof KeeperException.SessionExpiredException) {
                    while (true) {
                        try {
                            this.lockNode = null;
                            if (!recreate) {
                                this.nodePath = null;
                                this.nodeData = null;
                            }
                            this.zookeeper.close();
                            this.createSession();
                            if (this.nodePath != null) {
                                this.zookeeper.create(this.nodePath, this.nodeData, (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL);
                            }
                            break block8;
                        }
                        catch (KeeperException e2) {
                            if (e2 instanceof KeeperException.ConnectionLossException || e2 instanceof KeeperException.SessionExpiredException) continue;
                            throw new ManifoldCFException(e2.getMessage(), e2);
                        }
                        break;
                    }
                }
                throw new ManifoldCFException(e.getMessage(), e);
            }
        }
    }

    public static String zooKeeperSafeName(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char x = input.charAt(i);
            if (x == '/') {
                sb.append('\\').append('0');
                continue;
            }
            if (x == '\u007f') {
                sb.append('\\').append('1');
                continue;
            }
            if (x == '\\') {
                sb.append('\\').append('\\');
                continue;
            }
            if (x >= '\u0000' && x < ' ') {
                sb.append('\\').append(x + 64);
                continue;
            }
            if (x >= '\u0080' && x < '\u00a0') {
                sb.append('\\').append(x + 96 - 128);
                continue;
            }
            sb.append(x);
        }
        return sb.toString();
    }

    public static String zooKeeperDecodeSafeName(String input) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < input.length(); ++i) {
            char x = input.charAt(i);
            if (x == '\\') {
                if (++i == input.length()) {
                    throw new RuntimeException("Supposedly safe zookeeper name is not properly encoded!!");
                }
                x = input.charAt(i);
                if (x == '0') {
                    sb.append('/');
                    continue;
                }
                if (x == '1') {
                    sb.append('\u007f');
                    continue;
                }
                if (x == '\\') {
                    sb.append('\\');
                    continue;
                }
                if (x >= '@' && x < '`') {
                    sb.append(x - 64);
                    continue;
                }
                if (x >= '`' && x < '\u0080') {
                    sb.append(x - 96 + 128);
                    continue;
                }
                throw new RuntimeException("Supposedly safe zookeeper name is not properly encoded!!");
            }
            sb.append(x);
        }
        return sb.toString();
    }

    protected String createSequentialChild(String mainNode, String childPrefix) throws KeeperException, InterruptedException {
        while (true) {
            try {
                return this.zookeeper.create(mainNode + "/" + childPrefix, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.EPHEMERAL_SEQUENTIAL);
            }
            catch (KeeperException.NoNodeException e) {
                try {
                    this.zookeeper.create(mainNode, new byte[0], (List)ZooDefs.Ids.OPEN_ACL_UNSAFE, CreateMode.PERSISTENT);
                }
                catch (KeeperException.NodeExistsException nodeExistsException) {
                }
                continue;
            }
            break;
        }
    }

    protected static class ExistsWatcher
    implements Watcher {
        protected boolean eventTriggered = false;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void process(WatchedEvent event) {
            ExistsWatcher existsWatcher = this;
            synchronized (existsWatcher) {
                this.eventTriggered = true;
                this.notifyAll();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void waitForEvent() throws InterruptedException {
            ExistsWatcher existsWatcher = this;
            synchronized (existsWatcher) {
                if (this.eventTriggered) {
                    return;
                }
                this.wait();
            }
        }
    }

    protected static class ZooKeeperWatcher
    implements Watcher {
        public void process(WatchedEvent event) {
        }
    }
}

