/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents.system;

import org.apache.manifoldcf.agents.interfaces.IOutputConnectorPool;
import org.apache.manifoldcf.agents.interfaces.ITransformationConnectorPool;
import org.apache.manifoldcf.agents.interfaces.OutputConnectorPoolFactory;
import org.apache.manifoldcf.agents.interfaces.TransformationConnectorPoolFactory;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.ThreadContextFactory;

public class IdleCleanupThread
extends Thread {
    public static final String _rcsid = "@(#)$Id: IdleCleanupThread.java 1859195 2019-05-13 17:35:04Z kwright $";
    protected final String processID;

    public IdleCleanupThread(String processID) throws ManifoldCFException {
        this.processID = processID;
        this.setName("Agents idle cleanup thread");
        this.setDaemon(true);
    }

    @Override
    public void run() {
        Logging.agents.debug((Object)"Start up agents idle cleanup thread");
        try {
            IThreadContext threadContext = ThreadContextFactory.make();
            IOutputConnectorPool outputConnectorPool = OutputConnectorPoolFactory.make(threadContext);
            ITransformationConnectorPool transformationConnectorPool = TransformationConnectorPoolFactory.make(threadContext);
            while (true) {
                try {
                    while (true) {
                        outputConnectorPool.pollAllConnectors();
                        transformationConnectorPool.pollAllConnectors();
                        ManifoldCF.pollAll((IThreadContext)threadContext);
                        ManifoldCF.sleep((long)5000L);
                    }
                }
                catch (ManifoldCFException e) {
                    if (e.getErrorCode() == 2) break;
                    if (e.getErrorCode() == 4) {
                        Logging.agents.error((Object)("Idle cleanup thread aborting and restarting due to database connection reset: " + e.getMessage()), (Throwable)e);
                        try {
                            ManifoldCF.sleep((long)10000L);
                            continue;
                        }
                        catch (InterruptedException se) {
                            break;
                        }
                    }
                    Logging.agents.error((Object)("Exception tossed: " + e.getMessage()), (Throwable)e);
                    if (e.getErrorCode() != 3) continue;
                    ManifoldCF.systemExit((int)1);
                    continue;
                }
                catch (InterruptedException e) {
                }
                catch (OutOfMemoryError e) {
                    System.err.println("agents process ran out of memory - shutting down");
                    e.printStackTrace(System.err);
                    ManifoldCF.systemExit((int)-200);
                    continue;
                }
                catch (Throwable e) {
                    Logging.agents.fatal((Object)("Error tossed: " + e.getMessage()), e);
                    continue;
                }
                break;
            }
        }
        catch (Throwable e) {
            System.err.println("agents process could not start - shutting down");
            Logging.agents.fatal((Object)("IdleCleanupThread initialization error tossed: " + e.getMessage()), e);
            ManifoldCF.systemExit((int)-300);
        }
    }
}

