/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.agents;

import org.apache.manifoldcf.agents.BaseAgentsInitializationCommand;
import org.apache.manifoldcf.agents.system.AgentsDaemon;
import org.apache.manifoldcf.agents.system.Logging;
import org.apache.manifoldcf.agents.system.ManifoldCF;
import org.apache.manifoldcf.core.interfaces.ILockManager;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;

public class AgentStop
extends BaseAgentsInitializationCommand {
    public static final String _rcsid = "@(#)$Id: AgentStop.java 988245 2010-08-23 18:39:35Z kwright $";

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doExecute(IThreadContext tc) throws ManifoldCFException {
        ILockManager lockManager = LockManagerFactory.make((IThreadContext)tc);
        AgentsDaemon.assertAgentsShutdownSignal(tc);
        try {
            int count;
            Logging.root.info((Object)"Shutdown signal sent");
            while ((count = lockManager.countActiveServices("AGENT")) != 0) {
                try {
                    ManifoldCF.sleep((long)1000L);
                }
                catch (InterruptedException e) {
                    throw new ManifoldCFException(e.getMessage(), (Throwable)e, 2);
                }
            }
            Logging.root.info((Object)"All agents shut down");
        }
        finally {
            AgentsDaemon.clearAgentsShutdownSignal(tc);
        }
    }

    public static void main(String[] args) {
        if (args.length > 0) {
            System.err.println("Usage: AgentStop");
            System.exit(1);
        }
        try {
            AgentStop agentStop = new AgentStop();
            agentStop.execute();
            System.err.println("Shutdown signal sent");
        }
        catch (ManifoldCFException e) {
            e.printStackTrace(System.err);
            System.exit(1);
        }
    }
}

