/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.authorities.authorities.sharepoint;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import javax.naming.AuthenticationException;
import javax.naming.CommunicationException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.InitialLdapContext;
import javax.naming.ldap.LdapContext;
import org.apache.manifoldcf.authorities.authorities.BaseAuthorityConnector;
import org.apache.manifoldcf.authorities.authorities.sharepoint.Messages;
import org.apache.manifoldcf.authorities.interfaces.AuthorizationResponse;
import org.apache.manifoldcf.authorities.system.Logging;
import org.apache.manifoldcf.authorities.system.ManifoldCF;
import org.apache.manifoldcf.connectorcommon.common.LdapEscaper;
import org.apache.manifoldcf.core.cachemanager.BaseDescription;
import org.apache.manifoldcf.core.interfaces.CacheManagerFactory;
import org.apache.manifoldcf.core.interfaces.ConfigNode;
import org.apache.manifoldcf.core.interfaces.ConfigParams;
import org.apache.manifoldcf.core.interfaces.ConfigurationNode;
import org.apache.manifoldcf.core.interfaces.ICacheCreateHandle;
import org.apache.manifoldcf.core.interfaces.ICacheDescription;
import org.apache.manifoldcf.core.interfaces.ICacheHandle;
import org.apache.manifoldcf.core.interfaces.ICacheManager;
import org.apache.manifoldcf.core.interfaces.IHTTPOutput;
import org.apache.manifoldcf.core.interfaces.IPasswordMapperActivity;
import org.apache.manifoldcf.core.interfaces.IPostParameters;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.interfaces.StringSet;
import org.apache.manifoldcf.core.util.URLEncoder;

public class SharePointADAuthority
extends BaseAuthorityConnector {
    public static final String _rcsid = "@(#)$Id: SharePointADAuthority.java 1905595 2022-11-29 08:03:25Z kwright $";
    private List<DCRule> dCRules = null;
    private Map<String, DCConnectionParameters> dCConnectionParameters = null;
    private boolean hasSessionParameters = false;
    private String cacheLifetime = null;
    private String cacheLRUsize = null;
    private long responseLifetime = 60000L;
    private int LRUsize = 1000;
    private Map<String, DCSessionInfo> sessionInfo = null;
    private ICacheManager cacheManager = null;
    private static final long ADExpirationInterval = 300000L;
    protected static StringSet emptyStringSet = new StringSet();

    public void setThreadContext(IThreadContext tc) throws ManifoldCFException {
        super.setThreadContext(tc);
        this.cacheManager = CacheManagerFactory.make((IThreadContext)tc);
    }

    public void clearThreadContext() {
        super.clearThreadContext();
        this.cacheManager = null;
    }

    public void connect(ConfigParams configParams) {
        super.connect(configParams);
        this.sessionInfo = new HashMap<String, DCSessionInfo>();
        this.dCRules = new ArrayList<DCRule>();
        this.dCConnectionParameters = new HashMap<String, DCConnectionParameters>();
        for (int i = 0; i < this.params.getChildCount(); ++i) {
            ConfigNode cn = this.params.getChild(i);
            if (!cn.getType().equals("domaincontroller")) continue;
            String dcName = cn.getAttributeValue("domaincontroller");
            this.dCConnectionParameters.put(dcName, new DCConnectionParameters(cn.getAttributeValue("username"), SharePointADAuthority.deobfuscate(cn.getAttributeValue("password")), cn.getAttributeValue("authentication"), cn.getAttributeValue("useraclsusername")));
            this.dCRules.add(new DCRule(cn.getAttributeValue("suffix"), dcName));
        }
        this.cacheLifetime = this.params.getParameter("Cache lifetime");
        if (this.cacheLifetime == null) {
            this.cacheLifetime = "1";
        }
        this.cacheLRUsize = this.params.getParameter("Cache LRU size");
        if (this.cacheLRUsize == null) {
            this.cacheLRUsize = "1000";
        }
    }

    protected static String deobfuscate(String input) {
        if (input == null) {
            return null;
        }
        try {
            return ManifoldCF.deobfuscate((String)input);
        }
        catch (ManifoldCFException e) {
            return "";
        }
    }

    public String check() throws ManifoldCFException {
        this.getSessionParameters();
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeConnection();
        }
        for (String domainController : this.dCConnectionParameters.keySet()) {
            this.createDCSession(domainController);
        }
        return super.check();
    }

    protected LdapContext createDCSession(String domainController) throws ManifoldCFException {
        this.getSessionParameters();
        DCConnectionParameters parms = this.dCConnectionParameters.get(domainController);
        DCSessionInfo session = this.sessionInfo.get(domainController);
        if (session == null) {
            session = new DCSessionInfo();
            this.sessionInfo.put(domainController, session);
        }
        return session.getADSession(domainController, parms);
    }

    public void poll() throws ManifoldCFException {
        long currentTime = System.currentTimeMillis();
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeIfExpired(currentTime);
        }
        super.poll();
    }

    public boolean isConnected() {
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            if (!sessionEntry.getValue().isOpen()) continue;
            return true;
        }
        return false;
    }

    public void disconnect() throws ManifoldCFException {
        this.cacheLifetime = null;
        this.cacheLRUsize = null;
        this.hasSessionParameters = false;
        for (Map.Entry<String, DCSessionInfo> sessionEntry : this.sessionInfo.entrySet()) {
            sessionEntry.getValue().closeConnection();
        }
        this.sessionInfo = null;
        super.disconnect();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AuthorizationResponse getAuthorizationResponse(String userName) throws ManifoldCFException {
        this.getSessionParameters();
        AuthorizationResponseDescription objectDescription = new AuthorizationResponseDescription(userName, this.dCConnectionParameters, this.dCRules, this.responseLifetime, this.LRUsize);
        ICacheHandle ch = this.cacheManager.enterCache(new ICacheDescription[]{objectDescription}, null, null);
        try {
            AuthorizationResponse response;
            ICacheCreateHandle createHandle;
            block8: {
                AuthorizationResponse authorizationResponse;
                createHandle = this.cacheManager.enterCreateSection(ch);
                try {
                    response = (AuthorizationResponse)this.cacheManager.lookupObject(createHandle, (ICacheDescription)objectDescription);
                    if (response == null) break block8;
                    authorizationResponse = response;
                }
                catch (Throwable throwable) {
                    this.cacheManager.leaveCreateSection(createHandle);
                    throw throwable;
                }
                this.cacheManager.leaveCreateSection(createHandle);
                return authorizationResponse;
            }
            response = this.getAuthorizationResponseUncached(userName);
            this.cacheManager.saveObject(createHandle, (ICacheDescription)objectDescription, (Object)response);
            AuthorizationResponse authorizationResponse = response;
            this.cacheManager.leaveCreateSection(createHandle);
            return authorizationResponse;
        }
        finally {
            this.cacheManager.leaveCache(ch);
        }
    }

    protected AuthorizationResponse getAuthorizationResponseUncached(String userName) throws ManifoldCFException {
        int index = userName.indexOf("@");
        if (index == -1) {
            throw new ManifoldCFException("Username is in unexpected form (no @): '" + userName + "'");
        }
        String userPart = userName.substring(0, index);
        String domainPart = userName.substring(index + 1);
        try {
            List<String> adTokens = this.getADTokens(userPart, domainPart, userName);
            if (adTokens == null) {
                return RESPONSE_USERNOTFOUND_ADDITIVE;
            }
            return new AuthorizationResponse(adTokens.toArray(new String[0]), 0);
        }
        catch (NameNotFoundException e) {
            return RESPONSE_USERNOTFOUND_ADDITIVE;
        }
        catch (NamingException e) {
            return RESPONSE_UNREACHABLE_ADDITIVE;
        }
    }

    public AuthorizationResponse getDefaultAuthorizationResponse(String userName) {
        return RESPONSE_UNREACHABLE_ADDITIVE;
    }

    protected List<String> getADTokens(String userPart, String domainPart, String userName) throws NameNotFoundException, NamingException, ManifoldCFException {
        String domainController = null;
        for (DCRule rule : this.dCRules) {
            String suffix = rule.getSuffix();
            if (suffix.length() != 0 && (!domainPart.toLowerCase(Locale.ROOT).endsWith(suffix.toLowerCase(Locale.ROOT)) || suffix.length() != domainPart.length() && domainPart.charAt(domainPart.length() - suffix.length() - 1) != '.')) continue;
            domainController = rule.getDomainControllerName();
            break;
        }
        if (domainController == null) {
            return null;
        }
        DCConnectionParameters dcParams = this.dCConnectionParameters.get(domainController);
        if (dcParams == null) {
            return null;
        }
        String userACLsUsername = dcParams.getUserACLsUsername();
        String userBase = userACLsUsername != null && userACLsUsername.equals("userPrincipalName") ? userName : userPart;
        StringBuilder domainsb = new StringBuilder();
        int j = 0;
        while (true) {
            int k;
            if (j > 0) {
                domainsb.append(",");
            }
            if ((k = domainPart.indexOf(".", j)) == -1) break;
            domainsb.append("DC=").append(LdapEscaper.escapeDN((String)domainPart.substring(j, k)));
            j = k + 1;
        }
        domainsb.append("DC=").append(LdapEscaper.escapeDN((String)domainPart.substring(j)));
        LdapContext ctx = this.createDCSession(domainController);
        String searchBase = this.getDistinguishedName(ctx, userBase, domainsb.toString(), userACLsUsername);
        if (searchBase == null) {
            return null;
        }
        String searchFilter = "(objectClass=user)";
        SearchControls searchCtls = new SearchControls();
        searchCtls.setSearchScope(0);
        String[] returnedAtts = new String[]{"tokenGroups", "objectSid"};
        searchCtls.setReturningAttributes(returnedAtts);
        NamingEnumeration<SearchResult> answer = ctx.search(searchBase, searchFilter, searchCtls);
        ArrayList<String> theGroups = new ArrayList<String>();
        String userToken = SharePointADAuthority.userTokenFromLoginName(domainPart + "\\" + userPart);
        if (userToken != null) {
            theGroups.add(userToken);
        }
        while (answer.hasMoreElements()) {
            SearchResult sr = answer.next();
            Attributes attrs = sr.getAttributes();
            if (attrs == null) continue;
            try {
                NamingEnumeration<? extends Attribute> ae = attrs.getAll();
                while (ae.hasMore()) {
                    Attribute attr = ae.next();
                    NamingEnumeration<?> e = attr.getAll();
                    while (e.hasMore()) {
                        String sid = SharePointADAuthority.sid2String((byte[])e.next());
                        String token = attr.getID().equals("objectSid") ? SharePointADAuthority.userTokenFromSID(sid) : SharePointADAuthority.groupTokenFromSID(sid);
                        theGroups.add(token);
                    }
                }
            }
            catch (NamingException e) {
                throw new ManifoldCFException(e.getMessage(), (Throwable)e);
            }
        }
        if (theGroups.size() == 0) {
            return null;
        }
        theGroups.add(SharePointADAuthority.everyoneGroup());
        theGroups.add(SharePointADAuthority.authenticatedUserGroup());
        return theGroups;
    }

    protected static String everyoneGroup() {
        return "Uc:0!.s|windows";
    }

    protected static String authenticatedUserGroup() {
        return "Uc:0(.s|true";
    }

    protected static String groupTokenFromSID(String SID) {
        return "Uc:0+.w|" + SID.toLowerCase(Locale.ROOT);
    }

    protected static String userTokenFromSID(String SID) {
        return "Ui:0+.w|" + SID.toLowerCase(Locale.ROOT);
    }

    protected static String userTokenFromLoginName(String loginName) {
        return "Ui:0#.w|" + URLEncoder.encode((String)loginName).toLowerCase(Locale.ROOT);
    }

    public void outputConfigurationHeader(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, List<String> tabsArray) throws ManifoldCFException, IOException {
        tabsArray.add(Messages.getString(locale, "SharePointAuthority.DomainController"));
        tabsArray.add(Messages.getString(locale, "SharePointAuthority.Cache"));
        Messages.outputResourceWithVelocity(out, locale, "editADConfiguration.js", null);
    }

    public void outputConfigurationBody(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters, String tabName) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        velocityContext.put("TabName", tabName);
        SharePointADAuthority.fillInDomainControllerTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        SharePointADAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "editADConfiguration_DomainController.html", velocityContext);
        Messages.outputResourceWithVelocity(out, locale, "editADConfiguration_Cache.html", velocityContext);
    }

    protected static void fillInDomainControllerTab(Map<String, Object> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        ArrayList<Map<String, String>> domainControllers = new ArrayList<Map<String, String>>();
        for (int i = 0; i < parameters.getChildCount(); ++i) {
            ConfigNode cn = parameters.getChild(i);
            if (!cn.getType().equals("domaincontroller")) continue;
            String dcSuffix = cn.getAttributeValue("suffix");
            String dcDomainController = cn.getAttributeValue("domaincontroller");
            String dcUserName = cn.getAttributeValue("username");
            String dcPassword = SharePointADAuthority.deobfuscate(cn.getAttributeValue("password"));
            String dcAuthentication = cn.getAttributeValue("authentication");
            String dcUserACLsUsername = cn.getAttributeValue("useraclsusername");
            domainControllers.add(SharePointADAuthority.createDomainControllerMap(mapper, dcSuffix, dcDomainController, dcUserName, dcPassword, dcAuthentication, dcUserACLsUsername));
        }
        velocityContext.put("DOMAINCONTROLLERS", domainControllers);
    }

    protected static Map<String, String> createDomainControllerMap(IPasswordMapperActivity mapper, String suffix, String domainControllerName, String userName, String password, String authentication, String userACLsUsername) {
        HashMap<String, String> defaultMap = new HashMap<String, String>();
        if (suffix != null) {
            defaultMap.put("SUFFIX", suffix);
        }
        if (domainControllerName != null) {
            defaultMap.put("DOMAINCONTROLLER", domainControllerName);
        }
        if (userName != null) {
            defaultMap.put("USERNAME", userName);
        }
        if (password != null) {
            defaultMap.put("PASSWORD", mapper.mapPasswordToKey(password));
        }
        if (authentication != null) {
            defaultMap.put("AUTHENTICATION", authentication);
        }
        if (userACLsUsername != null) {
            defaultMap.put("USERACLsUSERNAME", userACLsUsername);
        }
        return defaultMap;
    }

    protected static void fillInCacheTab(Map<String, Object> velocityContext, IPasswordMapperActivity mapper, ConfigParams parameters) {
        String cacheLifetime = parameters.getParameter("Cache lifetime");
        if (cacheLifetime == null) {
            cacheLifetime = "1";
        }
        velocityContext.put("CACHELIFETIME", cacheLifetime);
        String cacheLRUsize = parameters.getParameter("Cache LRU size");
        if (cacheLRUsize == null) {
            cacheLRUsize = "1000";
        }
        velocityContext.put("CACHELRUSIZE", cacheLRUsize);
    }

    public String processConfigurationPost(IThreadContext threadContext, IPostParameters variableContext, Locale locale, ConfigParams parameters) throws ManifoldCFException {
        String cacheLRUsize;
        String cacheLifetime;
        String x = variableContext.getParameter("dcrecord_count");
        if (x != null) {
            String op;
            int i = 0;
            while (i < parameters.getChildCount()) {
                ConfigNode cn = parameters.getChild(i);
                if (cn.getType().equals("domaincontroller")) {
                    parameters.removeChild(i);
                    continue;
                }
                ++i;
            }
            int count = Integer.parseInt(x);
            HashSet<String> seenDomains = new HashSet<String>();
            for (i = 0; i < count; ++i) {
                op = variableContext.getParameter("dcrecord_op_" + i);
                if (op != null && op.equals("Insert")) {
                    SharePointADAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix"), variableContext.getParameter("dcrecord_domaincontrollername"), variableContext.getParameter("dcrecord_username"), variableContext.mapKeyToPassword(variableContext.getParameter("dcrecord_password")), variableContext.getParameter("dcrecord_authentication"), variableContext.getParameter("dcrecord_userACLsUsername"));
                }
                if (op != null && op.equals("Delete")) continue;
                SharePointADAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix_" + i), variableContext.getParameter("dcrecord_domaincontrollername_" + i), variableContext.getParameter("dcrecord_username_" + i), variableContext.mapKeyToPassword(variableContext.getParameter("dcrecord_password_" + i)), variableContext.getParameter("dcrecord_authentication_" + i), variableContext.getParameter("dcrecord_userACLsUsername_" + i));
            }
            op = variableContext.getParameter("dcrecord_op");
            if (op != null && op.equals("Add")) {
                SharePointADAuthority.addDomainController(seenDomains, parameters, variableContext.getParameter("dcrecord_suffix"), variableContext.getParameter("dcrecord_domaincontrollername"), variableContext.getParameter("dcrecord_username"), variableContext.getParameter("dcrecord_password"), variableContext.getParameter("dcrecord_authentication"), variableContext.getParameter("dcrecord_userACLsUsername"));
            }
        }
        if ((cacheLifetime = variableContext.getParameter("cachelifetime")) != null) {
            parameters.setParameter("Cache lifetime", cacheLifetime);
        }
        if ((cacheLRUsize = variableContext.getParameter("cachelrusize")) != null) {
            parameters.setParameter("Cache LRU size", cacheLRUsize);
        }
        return null;
    }

    protected static void addDomainController(Set<String> seenDomains, ConfigParams parameters, String suffix, String domainControllerName, String userName, String password, String authentication, String userACLsUsername) throws ManifoldCFException {
        if (!seenDomains.contains(domainControllerName)) {
            ConfigNode cn = new ConfigNode("domaincontroller");
            cn.setAttribute("suffix", suffix);
            cn.setAttribute("domaincontroller", domainControllerName);
            cn.setAttribute("username", userName);
            cn.setAttribute("password", ManifoldCF.obfuscate((String)password));
            cn.setAttribute("authentication", authentication);
            cn.setAttribute("useraclsusername", userACLsUsername);
            parameters.addChild(parameters.getChildCount(), (ConfigurationNode)cn);
            seenDomains.add(domainControllerName);
        }
    }

    public void viewConfiguration(IThreadContext threadContext, IHTTPOutput out, Locale locale, ConfigParams parameters) throws ManifoldCFException, IOException {
        HashMap<String, Object> velocityContext = new HashMap<String, Object>();
        SharePointADAuthority.fillInDomainControllerTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        SharePointADAuthority.fillInCacheTab(velocityContext, (IPasswordMapperActivity)out, parameters);
        Messages.outputResourceWithVelocity(out, locale, "viewADConfiguration.html", velocityContext);
    }

    protected void getSessionParameters() throws ManifoldCFException {
        if (!this.hasSessionParameters) {
            try {
                this.responseLifetime = Long.parseLong(this.cacheLifetime) * 60L * 1000L;
                this.LRUsize = Integer.parseInt(this.cacheLRUsize);
            }
            catch (NumberFormatException e) {
                throw new ManifoldCFException("Cache lifetime or Cache LRU size must be an integer: " + e.getMessage(), (Throwable)e);
            }
            this.hasSessionParameters = true;
        }
    }

    protected String getDistinguishedName(LdapContext ctx, String userName, String searchBase, String userACLsUsername) throws ManifoldCFException {
        String[] returnedAtts = new String[]{"distinguishedName"};
        String searchFilter = "(&(objectClass=user)(" + userACLsUsername + "=" + LdapEscaper.escapeFilter((String)userName) + "))";
        SearchControls searchCtls = new SearchControls();
        searchCtls.setReturningAttributes(returnedAtts);
        searchCtls.setSearchScope(2);
        searchCtls.setReturningAttributes(returnedAtts);
        try {
            NamingEnumeration<SearchResult> answer = ctx.search(searchBase, searchFilter, searchCtls);
            while (answer.hasMoreElements()) {
                SearchResult sr = answer.next();
                Attributes attrs = sr.getAttributes();
                if (attrs == null) continue;
                String dn = attrs.get("distinguishedName").get().toString();
                return dn;
            }
            return null;
        }
        catch (NamingException e) {
            throw new ManifoldCFException(e.getMessage(), (Throwable)e);
        }
    }

    protected static String sid2String(byte[] SID) {
        StringBuilder strSID = new StringBuilder("S");
        long version = SID[0];
        strSID.append("-").append(Long.toString(version));
        long authority = SID[4];
        for (int i = 0; i < 4; ++i) {
            authority <<= 8;
            authority += (long)(SID[4 + i] & 0xFF);
        }
        strSID.append("-").append(Long.toString(authority));
        long count = SID[2];
        count <<= 8;
        count += (long)(SID[1] & 0xFF);
        int j = 0;
        while ((long)j < count) {
            long rid = SID[11 + j * 4] & 0xFF;
            for (int k = 1; k < 4; ++k) {
                rid <<= 8;
                rid += (long)(SID[11 - k + j * 4] & 0xFF);
            }
            strSID.append("-").append(Long.toString(rid));
            ++j;
        }
        return strSID.toString();
    }

    protected static class AuthorizationResponseDescription
    extends BaseDescription {
        protected String userName;
        protected Map<String, DCConnectionParameters> dcConnectionParams;
        protected List<DCRule> dcRules;
        protected long responseLifetime;
        protected long expirationTime = -1L;

        public AuthorizationResponseDescription(String userName, Map<String, DCConnectionParameters> dcConnectionParams, List<DCRule> dcRules, long responseLifetime, int LRUsize) {
            super("SharePointADAuthority", LRUsize);
            this.userName = userName;
            this.dcConnectionParams = dcConnectionParams;
            this.dcRules = dcRules;
            this.responseLifetime = responseLifetime;
        }

        public StringSet getObjectKeys() {
            return emptyStringSet;
        }

        public String getCriticalSectionName() {
            StringBuilder sb = new StringBuilder(((Object)((Object)this)).getClass().getName());
            sb.append("-").append(this.userName);
            for (DCRule rule : this.dcRules) {
                sb.append("-").append(rule.getSuffix());
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                sb.append("-").append(domainController).append("-").append(params.getUserName()).append("-").append(params.getPassword());
            }
            return sb.toString();
        }

        public long getObjectExpirationTime(long currentTime) {
            if (this.expirationTime == -1L) {
                this.expirationTime = currentTime + this.responseLifetime;
            }
            return this.expirationTime;
        }

        public int hashCode() {
            int rval = this.userName.hashCode();
            for (DCRule rule : this.dcRules) {
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                rval += rule.getSuffix().hashCode() + domainController.hashCode() + params.getUserName().hashCode() + params.getPassword().hashCode();
            }
            return rval;
        }

        public boolean equals(Object o) {
            if (!(o instanceof AuthorizationResponseDescription)) {
                return false;
            }
            AuthorizationResponseDescription ard = (AuthorizationResponseDescription)((Object)o);
            if (!ard.userName.equals(this.userName)) {
                return false;
            }
            if (ard.dcRules.size() != this.dcRules.size()) {
                return false;
            }
            for (int i = 0; i < this.dcRules.size(); ++i) {
                DCRule rule = this.dcRules.get(i);
                DCRule ardRule = ard.dcRules.get(i);
                if (!rule.getSuffix().equals(ardRule.getSuffix()) || !rule.getDomainControllerName().equals(ardRule.getDomainControllerName())) {
                    return false;
                }
                String domainController = rule.getDomainControllerName();
                DCConnectionParameters params = this.dcConnectionParams.get(domainController);
                DCConnectionParameters ardParams = ard.dcConnectionParams.get(domainController);
                if (params.getUserName().equals(ardParams.getUserName()) && params.getPassword().equals(ardParams.getPassword())) continue;
                return false;
            }
            return true;
        }
    }

    protected static class DCConnectionParameters {
        private String userName;
        private String password;
        private String authentication;
        private String userACLsUsername;

        public DCConnectionParameters(String userName, String password, String authentication, String userACLsUsername) {
            this.userName = userName;
            this.password = password;
            this.authentication = authentication;
            this.userACLsUsername = userACLsUsername;
        }

        public String getUserName() {
            return this.userName;
        }

        public String getPassword() {
            return this.password;
        }

        public String getAuthentication() {
            return this.authentication;
        }

        public String getUserACLsUsername() {
            return this.userACLsUsername;
        }
    }

    protected static class DCRule {
        private String suffix;
        private String domainControllerName;

        public DCRule(String suffix, String domainControllerName) {
            this.suffix = suffix;
            this.domainControllerName = domainControllerName;
        }

        public String getSuffix() {
            return this.suffix;
        }

        public String getDomainControllerName() {
            return this.domainControllerName;
        }
    }

    protected static class DCSessionInfo {
        private LdapContext ctx = null;
        private long expiration = -1L;

        public LdapContext getADSession(String domainControllerName, DCConnectionParameters params) throws ManifoldCFException {
            String authentication = params.getAuthentication();
            String userName = params.getUserName();
            String password = params.getPassword();
            while (true) {
                if (this.ctx == null) {
                    String ldapURL = "ldap://" + domainControllerName + ":389";
                    Hashtable<String, Object> env = new Hashtable<String, Object>();
                    env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
                    env.put("java.naming.security.authentication", authentication);
                    env.put("java.naming.security.principal", userName);
                    env.put("java.naming.security.credentials", password);
                    env.put("java.naming.provider.url", ldapURL);
                    env.put("java.naming.ldap.attributes.binary", "tokenGroups objectSid");
                    try {
                        this.ctx = new InitialLdapContext(env, null);
                        break;
                    }
                    catch (AuthenticationException e) {
                        throw new ManifoldCFException("Authentication problem authenticating admin user '" + userName + "': " + e.getMessage(), (Throwable)e);
                    }
                    catch (CommunicationException e) {
                        throw new ManifoldCFException("Couldn't communicate with domain controller '" + domainControllerName + "': " + e.getMessage(), (Throwable)e);
                    }
                    catch (NamingException e) {
                        throw new ManifoldCFException(e.getMessage(), (Throwable)e);
                    }
                }
                try {
                    this.ctx.reconnect(null);
                    break;
                }
                catch (AuthenticationException e) {
                    Logging.authorityConnectors.warn((Object)("Reconnect: Authentication problem authenticating admin user '" + userName + "': " + e.getMessage()), (Throwable)e);
                }
                catch (CommunicationException e) {
                    Logging.authorityConnectors.warn((Object)("Reconnect: Couldn't communicate with domain controller '" + domainControllerName + "': " + e.getMessage()), (Throwable)e);
                }
                catch (NamingException e) {
                    Logging.authorityConnectors.warn((Object)("Reconnect: Naming exception: " + e.getMessage()), (Throwable)e);
                }
                this.closeConnection();
            }
            this.expiration = System.currentTimeMillis() + 300000L;
            return this.ctx;
        }

        protected void closeConnection() {
            if (this.ctx != null) {
                try {
                    this.ctx.close();
                }
                catch (NamingException namingException) {
                    // empty catch block
                }
                this.ctx = null;
                this.expiration = -1L;
            }
        }

        protected void closeIfExpired(long currentTime) {
            if (this.expiration != -1L && currentTime > this.expiration) {
                this.closeConnection();
            }
        }

        protected boolean isOpen() {
            return this.ctx != null;
        }
    }
}

