/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hdfs.server.balancer;

import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.hdfs.StorageType;
import org.apache.hadoop.hdfs.server.protocol.DatanodeStorageReport;
import org.apache.hadoop.hdfs.server.protocol.StorageReport;
import org.apache.hadoop.hdfs.util.EnumCounters;
import org.apache.hadoop.hdfs.util.EnumDoubles;

@InterfaceAudience.Private
abstract class BalancingPolicy {
    final EnumCounters<StorageType> totalCapacities = new EnumCounters<StorageType>(StorageType.class);
    final EnumCounters<StorageType> totalUsedSpaces = new EnumCounters<StorageType>(StorageType.class);
    final EnumDoubles<StorageType> avgUtilizations = new EnumDoubles<StorageType>(StorageType.class);

    BalancingPolicy() {
    }

    void reset() {
        this.totalCapacities.reset();
        this.totalUsedSpaces.reset();
        this.avgUtilizations.reset();
    }

    abstract String getName();

    abstract void accumulateSpaces(DatanodeStorageReport var1);

    void initAvgUtilization() {
        for (StorageType t : StorageType.asList()) {
            long capacity = this.totalCapacities.get(t);
            if (capacity <= 0L) continue;
            double avg = (double)this.totalUsedSpaces.get(t) * 100.0 / (double)capacity;
            this.avgUtilizations.set(t, avg);
        }
    }

    double getAvgUtilization(StorageType t) {
        return this.avgUtilizations.get(t);
    }

    abstract Double getUtilization(DatanodeStorageReport var1, StorageType var2);

    public String toString() {
        return BalancingPolicy.class.getSimpleName() + "." + this.getClass().getSimpleName();
    }

    static BalancingPolicy parse(String s) {
        BalancingPolicy[] all;
        for (BalancingPolicy p : all = new BalancingPolicy[]{Node.INSTANCE, Pool.INSTANCE}) {
            if (!p.getName().equalsIgnoreCase(s)) continue;
            return p;
        }
        throw new IllegalArgumentException("Cannot parse string \"" + s + "\"");
    }

    static class Pool
    extends BalancingPolicy {
        static final Pool INSTANCE = new Pool();

        private Pool() {
        }

        @Override
        String getName() {
            return "blockpool";
        }

        @Override
        void accumulateSpaces(DatanodeStorageReport r) {
            for (StorageReport s : r.getStorageReports()) {
                StorageType t = s.getStorage().getStorageType();
                this.totalCapacities.add(t, s.getCapacity());
                this.totalUsedSpaces.add(t, s.getBlockPoolUsed());
            }
        }

        @Override
        Double getUtilization(DatanodeStorageReport r, StorageType t) {
            long capacity = 0L;
            long blockPoolUsed = 0L;
            for (StorageReport s : r.getStorageReports()) {
                if (s.getStorage().getStorageType() != t) continue;
                capacity += s.getCapacity();
                blockPoolUsed += s.getBlockPoolUsed();
            }
            return capacity == 0L ? null : Double.valueOf((double)blockPoolUsed * 100.0 / (double)capacity);
        }
    }

    static class Node
    extends BalancingPolicy {
        static final Node INSTANCE = new Node();

        private Node() {
        }

        @Override
        String getName() {
            return "datanode";
        }

        @Override
        void accumulateSpaces(DatanodeStorageReport r) {
            for (StorageReport s : r.getStorageReports()) {
                StorageType t = s.getStorage().getStorageType();
                this.totalCapacities.add(t, s.getCapacity());
                this.totalUsedSpaces.add(t, s.getDfsUsed());
            }
        }

        @Override
        Double getUtilization(DatanodeStorageReport r, StorageType t) {
            long capacity = 0L;
            long dfsUsed = 0L;
            for (StorageReport s : r.getStorageReports()) {
                if (s.getStorage().getStorageType() != t) continue;
                capacity += s.getCapacity();
                dfsUsed += s.getDfsUsed();
            }
            return capacity == 0L ? null : Double.valueOf((double)dfsUsed * 100.0 / (double)capacity);
        }
    }
}

