/*
 * Decompiled with CFR 0.152.
 */
package org.apache.uima.cas.impl;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.apache.uima.UimaContext;
import org.apache.uima.cas.CAS;
import org.apache.uima.cas.Feature;
import org.apache.uima.cas.TypeSystem;
import org.apache.uima.cas.impl.ArrayElement;
import org.apache.uima.cas.impl.BooleanArrayFSImpl;
import org.apache.uima.cas.impl.ByteArrayFSImpl;
import org.apache.uima.cas.impl.CASImpl;
import org.apache.uima.cas.impl.DoubleArrayFSImpl;
import org.apache.uima.cas.impl.FSData;
import org.apache.uima.cas.impl.FSIndexRepositoryImpl;
import org.apache.uima.cas.impl.FeatureImpl;
import org.apache.uima.cas.impl.FloatArrayFSImpl;
import org.apache.uima.cas.impl.IntArrayFSImpl;
import org.apache.uima.cas.impl.LongArrayFSImpl;
import org.apache.uima.cas.impl.OutOfTypeSystemData;
import org.apache.uima.cas.impl.ShortArrayFSImpl;
import org.apache.uima.cas.impl.StringArrayFSImpl;
import org.apache.uima.cas.impl.TypeSystemImpl;
import org.apache.uima.internal.util.IntStack;
import org.apache.uima.internal.util.IntVector;
import org.apache.uima.internal.util.StringUtils;
import org.apache.uima.internal.util.rb_trees.IntRedBlackTree;
import org.apache.uima.util.XMLSerializer;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XCASSerializer {
    private int numChildren;
    public static final String casTagName = "CAS";
    public static final String VERSION_ATTR = "version";
    public static final String CURRENT_VERSION = "2";
    public static final String DEFAULT_DOC_TYPE_NAME = "uima.tcas.Document";
    public static final String DEFAULT_DOC_TEXT_FEAT = "text";
    public static final String INDEXED_ATTR_NAME = "_indexed";
    public static final String REF_PREFIX = "_ref_";
    public static final String ID_ATTR_NAME = "_id";
    public static final String CONTENT_ATTR_NAME = "_content";
    public static final String ARRAY_SIZE_ATTR = "size";
    public static final String ARRAY_ELEMENT_TAG = "i";
    public static final String TRUE_VALUE = "true";
    private TypeSystemImpl ts;
    private UimaContext uimaContext;
    private String[] featureNames;
    private String docTypeName = "uima.tcas.Document";
    private String docTextFeature = "text";

    public int getNumChildren() {
        return this.numChildren;
    }

    private String getXCasElementName(String aTagName) {
        if (aTagName.indexOf(58) == -1 && aTagName.indexOf(45) == -1) {
            return aTagName;
        }
        return StringUtils.replaceAll(StringUtils.replaceAll(aTagName, ":", "_colon_"), "-", "_dash_");
    }

    public XCASSerializer(TypeSystem ts, UimaContext uimaContext) {
        this.ts = (TypeSystemImpl)ts;
        this.uimaContext = uimaContext;
        int featArraySize = this.ts.getNumberOfFeatures() + 1;
        this.featureNames = new String[featArraySize];
        Iterator<Feature> it = this.ts.getFeatures();
        while (it.hasNext()) {
            FeatureImpl feat = (FeatureImpl)it.next();
            String featName = feat.getRange().isPrimitive() ? feat.getShortName() : REF_PREFIX + feat.getShortName();
            this.featureNames[feat.getCode()] = featName;
        }
    }

    public XCASSerializer(TypeSystem ts) {
        this(ts, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler) throws IOException, SAXException {
        this.serialize(cas, contentHandler, true);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, boolean encodeDoc) throws IOException, SAXException {
        this.serialize(cas, contentHandler, encodeDoc, null);
    }

    public void serialize(CAS cas, ContentHandler contentHandler, boolean encodeDoc, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
        contentHandler.startDocument();
        XCASDocSerializer ser = new XCASDocSerializer(contentHandler, ((CASImpl)cas).getBaseCAS());
        ser.serialize(encodeDoc, outOfTypeSystemData);
        contentHandler.endDocument();
    }

    public String getDocumentTypeName() {
        return this.docTypeName;
    }

    public void setDocumentTypeName(String aDocTypeName) {
        this.docTypeName = aDocTypeName;
    }

    public String getDocumentTextFeature() {
        return this.docTextFeature;
    }

    public void setDocumentTextFeature(String aDocTextFeature) {
        this.docTextFeature = aDocTextFeature;
    }

    public static void serialize(CAS aCAS, OutputStream aStream) throws SAXException, IOException {
        XCASSerializer.serialize(aCAS, aStream, false);
    }

    public static void serialize(CAS aCAS, OutputStream aStream, boolean isFormattedOutput) throws SAXException, IOException {
        XCASSerializer xcasSerializer = new XCASSerializer(aCAS.getTypeSystem());
        XMLSerializer sax2xml = new XMLSerializer(aStream, isFormattedOutput);
        xcasSerializer.serialize(aCAS, sax2xml.getContentHandler());
    }

    private class XCASDocSerializer {
        private ContentHandler ch;
        private CASImpl cas;
        private IntRedBlackTree queued;
        private static final int NOT_INDEXED = -1;
        private static final int MULTIPLY_INDEXED = -2;
        private static final int INVALID_INDEX = -3;
        private IntRedBlackTree duplicates;
        int numDuplicates;
        Vector<IntVector> dupVectors;
        private IntVector indexedFSs;
        private IntVector indexReps;
        private IntStack queue;
        private int sofaTypeCode;
        private final AttributesImpl emptyAttrs = new AttributesImpl();
        private AttributesImpl workAttrs = new AttributesImpl();
        private static final String cdataType = "CDATA";
        private int fsCount = 0;
        private OutOfTypeSystemData mOutOfTypeSystemData;
        private static final int KEY_AND_VALUE_MATCH = 1;
        private static final int KEY_ONLY_MATCH = -1;
        private static final int KEY_NOT_FOUND = 0;

        private XCASDocSerializer(ContentHandler ch, CASImpl cas) {
            this.ch = ch;
            this.cas = cas;
            this.queued = new IntRedBlackTree();
            this.duplicates = new IntRedBlackTree();
            this.numDuplicates = 0;
            this.dupVectors = new Vector();
            this.queue = new IntStack();
            this.indexedFSs = new IntVector();
            this.indexReps = new IntVector();
            this.sofaTypeCode = cas.ll_getTypeSystem().ll_getCodeForType(cas.getTypeSystem().getType("uima.cas.Sofa"));
        }

        private boolean enqueue(int addr) {
            if (-1 == this.isQueued(addr, -3)) {
                return false;
            }
            int heapVal = this.cas.getHeapValue(addr);
            this.queued.put(addr, -1);
            this.queue.push(addr);
            int typeClass = this.classifyType(heapVal);
            if (typeClass == 8) {
                if (this.mOutOfTypeSystemData != null) {
                    this.enqueueOutOfTypeSystemFeatures(addr);
                }
                this.enqueueFeatures(addr, heapVal);
            } else if (typeClass == 7) {
                this.enqueueFSArray(addr);
            }
            return true;
        }

        private void enqueueIndexed(int addr, int indexRep) {
            int status = this.isQueued(addr, indexRep);
            switch (status) {
                case 0: {
                    this.queued.put(addr, indexRep);
                    this.indexedFSs.add(addr);
                    this.indexReps.add(indexRep);
                    break;
                }
                case 1: {
                    break;
                }
                case -1: {
                    int prevIndex = this.queued.get(addr);
                    if (-1 == prevIndex) {
                        this.queued.put(addr, indexRep);
                        break;
                    }
                    if (-2 == prevIndex) {
                        int thisDup = this.duplicates.get(addr);
                        this.dupVectors.get(thisDup).add(indexRep);
                        break;
                    }
                    this.duplicates.put(addr, this.numDuplicates);
                    this.dupVectors.add(new IntVector());
                    this.dupVectors.get(this.numDuplicates).add(prevIndex);
                    this.dupVectors.get(this.numDuplicates).add(indexRep);
                    ++this.numDuplicates;
                    this.queued.put(addr, -2);
                }
            }
        }

        private int isQueued(int addr, int value) {
            return this.containsKeyValuePair(this.queued, addr, value);
        }

        private final int containsKeyValuePair(IntRedBlackTree rbt, int key, int value) {
            if (rbt.containsKey(key)) {
                if (rbt.get(key) == value) {
                    return 1;
                }
                return -1;
            }
            return 0;
        }

        private void serialize(boolean encodeDoc, OutOfTypeSystemData outOfTypeSystemData) throws IOException, SAXException {
            this.mOutOfTypeSystemData = outOfTypeSystemData;
            int iElementCount = 0;
            this.enqueueIndexed();
            this.enqueueFeaturesOfIndexed();
            if (outOfTypeSystemData != null) {
                int nextId = this.cas.getHeap().getCellsUsed();
                for (FSData fs : outOfTypeSystemData.fsList) {
                    String newId = Integer.toString(nextId++);
                    outOfTypeSystemData.idMap.put(fs.id, newId);
                    fs.id = newId;
                }
                iElementCount += outOfTypeSystemData.fsList.size();
                this.enqueueOutOfTypeSystemData(outOfTypeSystemData);
            }
            iElementCount += this.indexedFSs.size();
            AttributesImpl rootAttrs = new AttributesImpl();
            rootAttrs.addAttribute("", XCASSerializer.VERSION_ATTR, XCASSerializer.VERSION_ATTR, cdataType, XCASSerializer.CURRENT_VERSION);
            this.startElement(XCASSerializer.casTagName, rootAttrs, iElementCount += this.queue.size());
            this.encodeIndexed();
            this.encodeQueued();
            if (outOfTypeSystemData != null) {
                this.serializeOutOfTypeSystemData(outOfTypeSystemData);
            }
            this.endElement(XCASSerializer.casTagName);
        }

        private void addText(String text) throws SAXException {
            this.ch.characters(text.toCharArray(), 0, text.length());
        }

        private String replaceInvalidXmlChars(String aString) {
            boolean controlCharFound = false;
            for (int i = 0; i < aString.length(); ++i) {
                if (this.isValidXmlChar(aString.charAt(i))) continue;
                controlCharFound = true;
                break;
            }
            if (!controlCharFound) {
                return aString;
            }
            char[] chars = aString.toCharArray();
            for (int i = 0; i < chars.length; ++i) {
                if (this.isValidXmlChar(chars[i])) continue;
                chars[i] = 65533;
            }
            return new String(chars);
        }

        private boolean isValidXmlChar(char c) {
            return c >= ' ' && c < '\ufffe' || c == '\t' || c == '\n' || c == '\r';
        }

        private void addAttribute(AttributesImpl attrs, String attrName, String attrValue) {
            if ("sofaString".equals(attrName)) {
                attrValue = this.replaceInvalidXmlChars(attrValue);
            }
            attrs.addAttribute("", attrName, attrName, cdataType, attrValue);
        }

        private void startElement(String tag, Attributes attrs, int num) throws SAXException {
            XCASSerializer.this.numChildren = num;
            this.ch.startElement("", "", tag, attrs);
        }

        private void endElement(String tag) throws SAXException {
            this.ch.endElement("", "", tag);
        }

        private void encodeIndexed() throws IOException, SAXException {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                if (-2 != this.queued.get(this.indexedFSs.get(i))) {
                    IntVector iv = new IntVector(1);
                    iv.add(this.indexReps.get(i));
                    this.encodeFS(this.indexedFSs.get(i), iv);
                    continue;
                }
                int thisDup = this.duplicates.get(this.indexedFSs.get(i));
                this.encodeFS(this.indexedFSs.get(i), this.dupVectors.get(thisDup));
            }
        }

        private void enqueueIndexed() {
            FSIndexRepositoryImpl ir = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getBaseIndexRepository();
            int[] fsarray = ir.getIndexedFSs();
            for (int k = 0; k < fsarray.length; ++k) {
                this.enqueueIndexed(fsarray[k], 0);
            }
            int numViews = this.cas.getBaseSofaCount();
            for (int sofaNum = 1; sofaNum <= numViews; ++sofaNum) {
                FSIndexRepositoryImpl loopIR = (FSIndexRepositoryImpl)this.cas.getBaseCAS().getSofaIndexRepository(sofaNum);
                if (loopIR == null) continue;
                fsarray = loopIR.getIndexedFSs();
                for (int k = 0; k < fsarray.length; ++k) {
                    this.enqueueIndexed(fsarray[k], sofaNum);
                }
            }
        }

        private void enqueueFeaturesOfIndexed() {
            int max = this.indexedFSs.size();
            for (int i = 0; i < max; ++i) {
                int addr = this.indexedFSs.get(i);
                int heapVal = this.cas.getHeapValue(addr);
                int typeClass = this.classifyType(heapVal);
                if (typeClass == 8) {
                    if (this.mOutOfTypeSystemData != null) {
                        this.enqueueOutOfTypeSystemFeatures(addr);
                    }
                    this.enqueueFeatures(addr, heapVal);
                    continue;
                }
                if (typeClass != 7) continue;
                this.enqueueFSArray(addr);
            }
        }

        private void encodeQueued() throws IOException, SAXException {
            while (!this.queue.empty()) {
                int addr = this.queue.pop();
                this.encodeFS(addr, null);
            }
        }

        private void encodeFS(int addr, IntVector indexRep) throws IOException, SAXException {
            ++this.fsCount;
            this.workAttrs.clear();
            if (indexRep != null) {
                if (indexRep.size() == 1) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, Integer.toString(indexRep.get(0)));
                } else {
                    StringBuilder multIndex = new StringBuilder();
                    multIndex.append(Integer.toString(indexRep.get(0)));
                    for (int mi = 1; mi < indexRep.size(); ++mi) {
                        multIndex.append(' ').append(Integer.toString(indexRep.get(mi)));
                    }
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, multIndex.toString());
                }
            }
            this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, Integer.toString(addr));
            int typeClass = this.classifyType(this.cas.getHeapValue(addr));
            switch (typeClass) {
                case 8: {
                    String typeName = this.getTypeName(addr);
                    this.encodeFeatures(addr, this.workAttrs);
                    if (this.mOutOfTypeSystemData != null) {
                        this.encodeOutOfTypeSystemFeatures(addr, this.workAttrs);
                    }
                    String xcasElementName = XCASSerializer.this.getXCasElementName(typeName);
                    this.startElement(xcasElementName, this.workAttrs, 0);
                    this.endElement(xcasElementName);
                    break;
                }
                case 4: {
                    IntArrayFSImpl fs = new IntArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 5: {
                    FloatArrayFSImpl fs = new FloatArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 6: {
                    StringArrayFSImpl fs = new StringArrayFSImpl(addr, this.cas);
                    String[] data = fs.toArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 7: {
                    this.encodeFSArray(addr, this.workAttrs);
                    break;
                }
                case 14: {
                    BooleanArrayFSImpl fs = new BooleanArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 15: {
                    ByteArrayFSImpl fs = new ByteArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 16: {
                    ShortArrayFSImpl fs = new ShortArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 17: {
                    LongArrayFSImpl fs = new LongArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                case 18: {
                    DoubleArrayFSImpl fs = new DoubleArrayFSImpl(addr, this.cas);
                    String[] data = fs.toStringArray();
                    this.encodePrimitiveTypeArrayFS(data, this.getTypeName(addr), this.workAttrs);
                    break;
                }
                default: {
                    System.err.println("Error classifying FS type.");
                }
            }
        }

        private void encodePrimitiveTypeArrayFS(String[] data, String typeName, AttributesImpl attrs) throws SAXException {
            this.addAttribute(attrs, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(data.length));
            this.startElement(typeName, attrs, data.length);
            for (int i = 0; i < data.length; ++i) {
                this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                this.addText(data[i] == null ? "" : data[i]);
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
            }
            this.endElement(typeName);
        }

        private void encodeFSArray(int addr, AttributesImpl attrs) throws SAXException {
            String typeName = this.getTypeName(addr);
            int size = this.cas.ll_getArraySize(addr);
            int pos = this.cas.getArrayStartAddress(addr);
            this.addAttribute(attrs, XCASSerializer.ARRAY_SIZE_ATTR, Integer.toString(size));
            this.startElement(typeName, attrs, size);
            for (int i = 0; i < size; ++i) {
                String val = null;
                int heapVal = this.cas.getHeapValue(pos);
                if (heapVal == 0 && this.mOutOfTypeSystemData != null) {
                    List<ArrayElement> ootsElems = this.mOutOfTypeSystemData.arrayElements.get(addr);
                    if (ootsElems != null) {
                        for (ArrayElement ootsElem : ootsElems) {
                            if (ootsElem.index != i) continue;
                            val = this.mOutOfTypeSystemData.idMap.get(ootsElem.value);
                            break;
                        }
                    }
                } else if (heapVal != 0) {
                    val = Integer.toString(heapVal);
                }
                if (val != null) {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 1);
                    this.addText(val);
                } else {
                    this.startElement(XCASSerializer.ARRAY_ELEMENT_TAG, this.emptyAttrs, 0);
                }
                this.endElement(XCASSerializer.ARRAY_ELEMENT_TAG);
                ++pos;
            }
            this.endElement(typeName);
        }

        private void enqueueFSArray(int addr) {
            int size = this.cas.ll_getArraySize(addr);
            int pos = this.cas.getArrayStartAddress(addr);
            for (int i = 0; i < size; ++i) {
                int val = this.cas.getHeapValue(pos);
                if (val != 0) {
                    this.enqueue(val);
                }
                ++pos;
            }
        }

        private void encodeFeatures(int addr, AttributesImpl attrs) {
            int heapValue = this.cas.getHeapValue(addr);
            int[] feats = XCASSerializer.this.ts.ll_getAppropriateFeatures(heapValue);
            for (int i = 0; i < feats.length; ++i) {
                int featAddr = addr + this.cas.getFeatureOffset(feats[i]);
                int featVal = this.cas.getHeapValue(featAddr);
                String featName = XCASSerializer.this.featureNames[feats[i]];
                String attrValue = !this.cas.ll_isRefType(XCASSerializer.this.ts.range(feats[i])) ? this.cas.getFeatureValueAsString(addr, feats[i]) : (featVal == 0 ? null : Integer.toString(featVal));
                if (attrValue == null || featName == null) continue;
                this.addAttribute(attrs, featName, attrValue);
            }
        }

        private void enqueueFeatures(int addr, int heapValue) {
            int[] feats = XCASSerializer.this.ts.ll_getAppropriateFeatures(heapValue);
            for (int i = 0; i < feats.length; ++i) {
                int featAddr = addr + this.cas.getFeatureOffset(feats[i]);
                int featVal = this.cas.getHeapValue(featAddr);
                if (!this.cas.ll_isRefType(XCASSerializer.this.ts.range(feats[i])) || featVal == 0) continue;
                this.enqueue(featVal);
            }
        }

        private void encodeOutOfTypeSystemFeatures(int addr, AttributesImpl attrs) {
            List<String[]> attrList = this.mOutOfTypeSystemData.extraFeatureValues.get(addr);
            if (attrList != null) {
                for (String[] attr : attrList) {
                    if (attr[0].startsWith(XCASSerializer.REF_PREFIX) && attr[1].startsWith("a")) {
                        attr[1] = this.mOutOfTypeSystemData.idMap.get(attr[1]);
                    }
                    this.addAttribute(attrs, attr[0], attr[1]);
                }
            }
        }

        private void enqueueOutOfTypeSystemFeatures(int addr) {
            List<String[]> attrList = this.mOutOfTypeSystemData.extraFeatureValues.get(addr);
            if (attrList != null) {
                for (String[] attr : attrList) {
                    if (!attr[0].startsWith(XCASSerializer.REF_PREFIX) || attr[1].startsWith("a")) continue;
                    this.enqueue(Integer.parseInt(attr[1]));
                }
            }
        }

        private final String getTypeName(int addr) {
            return XCASSerializer.this.ts.ll_getTypeForCode(this.cas.getHeapValue(addr)).getName();
        }

        private final int classifyType(int type) {
            return this.cas.ll_getTypeClass(type);
        }

        private void enqueueOutOfTypeSystemData(OutOfTypeSystemData aData) {
            for (FSData fs : aData.fsList) {
                for (Map.Entry<String, String> entry : fs.featVals.entrySet()) {
                    String attrVal;
                    String attrName = entry.getKey();
                    if (!attrName.startsWith(XCASSerializer.REF_PREFIX) || (attrVal = entry.getValue()).startsWith("a")) continue;
                    this.enqueue(Integer.parseInt(attrVal));
                }
            }
        }

        private void serializeOutOfTypeSystemData(OutOfTypeSystemData aData) throws SAXException {
            for (FSData fs : aData.fsList) {
                this.workAttrs.clear();
                if (fs.indexRep != null) {
                    this.addAttribute(this.workAttrs, XCASSerializer.INDEXED_ATTR_NAME, fs.indexRep);
                }
                this.addAttribute(this.workAttrs, XCASSerializer.ID_ATTR_NAME, fs.id);
                for (Map.Entry<String, String> entry : fs.featVals.entrySet()) {
                    String attrName = entry.getKey();
                    String attrVal = entry.getValue();
                    if (attrName.startsWith(XCASSerializer.REF_PREFIX) && attrVal.startsWith("a")) {
                        attrVal = this.mOutOfTypeSystemData.idMap.get(attrVal);
                    }
                    this.addAttribute(this.workAttrs, attrName, attrVal);
                }
                String xcasElementName = XCASSerializer.this.getXCasElementName(fs.type);
                this.startElement(xcasElementName, this.workAttrs, 0);
                this.endElement(xcasElementName);
            }
        }
    }
}

