/*
 * Decompiled with CFR 0.152.
 */
package org.apache.manifoldcf.core.auth;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.lang.StringUtils;
import org.apache.manifoldcf.core.interfaces.IAuth;
import org.apache.manifoldcf.core.interfaces.IThreadContext;
import org.apache.manifoldcf.core.interfaces.LockManagerFactory;
import org.apache.manifoldcf.core.interfaces.ManifoldCFException;
import org.apache.manifoldcf.core.system.Logging;

public class LdapAuthenticator
implements IAuth {
    private static final String CONTEXT_FACTORY = "com.sun.jndi.ldap.LdapCtxFactory";
    private static final String PROVIDER_URL_PROPERTY = "org.apache.manifoldcf.login.ldap.providerurl";
    private static final String SECURITY_AUTHENTICATION_TYPE = "org.apache.manifoldcf.login.ldap.securityauthenticationtype";
    private static final String SECURITY_PRINCIPLE = "org.apache.manifoldcf.login.ldap.securityprincipal";
    private static final String CONTEXT_SEARCH_QUERY = "org.apache.manifoldcf.login.ldap.contextsearchquery";
    private static final String SEARCH_ATTRIBUTE = "org.apache.manifoldcf.login.ldap.searchattribute";
    protected final String securityPrincipal;
    protected final String securityAuthenticationType;
    protected final String providerURLProperty;
    protected final String contextSearchQuery;
    protected final String searchAttribute;

    public LdapAuthenticator(IThreadContext threadContext) throws ManifoldCFException {
        this.securityPrincipal = LockManagerFactory.getStringProperty(threadContext, SECURITY_PRINCIPLE, "");
        this.securityAuthenticationType = LockManagerFactory.getStringProperty(threadContext, SECURITY_AUTHENTICATION_TYPE, "simple");
        this.providerURLProperty = LockManagerFactory.getStringProperty(threadContext, PROVIDER_URL_PROPERTY, "");
        this.contextSearchQuery = LockManagerFactory.getStringProperty(threadContext, CONTEXT_SEARCH_QUERY, "");
        this.searchAttribute = LockManagerFactory.getStringProperty(threadContext, SEARCH_ATTRIBUTE, "uid");
    }

    private Hashtable<String, String> buildEnvironment(String userID, String password) {
        Hashtable<String, String> environment = new Hashtable<String, String>();
        environment.put("java.naming.factory.initial", CONTEXT_FACTORY);
        environment.put("java.naming.provider.url", this.providerURLProperty);
        environment.put("java.naming.security.authentication", this.securityAuthenticationType);
        environment.put("java.naming.security.principal", LdapAuthenticator.substituteUser(this.securityPrincipal, userID));
        environment.put("java.naming.security.credentials", password);
        return environment;
    }

    private static String substituteUser(String source, String substitution) {
        return source.replace("$(userID)", substitution);
    }

    @Override
    public boolean verifyUILogin(String userId, String password) throws ManifoldCFException {
        return this.verifyLogin(userId, password);
    }

    @Override
    public boolean verifyAPILogin(String userId, String password) throws ManifoldCFException {
        return this.verifyLogin(userId, password);
    }

    protected boolean verifyLogin(String userId, String password) throws ManifoldCFException {
        boolean authenticated = false;
        if (StringUtils.isNotEmpty((String)userId) && StringUtils.isNotEmpty((String)password)) {
            try {
                Logging.misc.info((Object)("Authentication attempt for user = " + userId));
                InitialDirContext ctx = new InitialDirContext(this.buildEnvironment(userId, password));
                NamingEnumeration<SearchResult> results = null;
                try {
                    SearchControls controls = new SearchControls();
                    controls.setSearchScope(2);
                    results = ctx.search("", LdapAuthenticator.substituteUser(this.contextSearchQuery, userId), controls);
                    while (results.hasMore()) {
                        SearchResult searchResult = results.next();
                        if (!userId.equals(searchResult.getAttributes().get(this.searchAttribute).get())) continue;
                        Logging.misc.info((Object)("Successfully authenticated : " + userId));
                        authenticated = true;
                        break;
                    }
                }
                catch (Exception e) {
                    Logging.misc.error((Object)("User not authenticated = " + userId + " exception = " + e.getMessage()), (Throwable)e);
                    throw new ManifoldCFException("User not authenticated: " + e.getMessage(), e);
                }
                finally {
                    if (results != null) {
                        try {
                            results.close();
                        }
                        catch (Exception exception) {}
                    }
                    if (ctx != null) {
                        try {
                            ctx.close();
                        }
                        catch (Exception exception) {}
                    }
                }
            }
            catch (NamingException e) {
                Logging.misc.error((Object)("Exception authenticating user = " + userId + " exception = " + e.getMessage()), (Throwable)e);
                throw new ManifoldCFException("Exception authenticating user: " + e.getMessage(), e);
            }
        }
        return authenticated;
    }

    @Override
    public boolean checkCapability(String userId, int capability) throws ManifoldCFException {
        return true;
    }
}

