/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.jdbc.jndi;

import java.sql.Connection;
import java.sql.SQLException;
import javax.naming.NamingException;
import javax.sql.DataSource;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.jdbc.appender.AbstractConnectionSource;
import org.apache.logging.log4j.jndi.JndiManager;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAttribute;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

@Configurable(elementType="connectionSource", printObject=true)
@Plugin(value="DataSource")
public final class DataSourceConnectionSource
extends AbstractConnectionSource {
    private static final String DOC_URL = "https://logging.staged.apache.org/log4j/3.x/manual/systemproperties.html#properties-jndi-support";
    static final String JNDI_MANAGER_NAME = "org.apache.logging.log4j.jdbc.jndi.DataSourceConnectionSource";
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final DataSource dataSource;
    private final String description;

    private DataSourceConnectionSource(String dataSourceName, DataSource dataSource) {
        this.dataSource = dataSource;
        this.description = "dataSource{ name=" + dataSourceName + ", value=" + dataSource + " }";
    }

    public Connection getConnection() throws SQLException {
        return this.dataSource.getConnection();
    }

    public String toString() {
        return this.description;
    }

    @PluginFactory
    public static DataSourceConnectionSource createConnectionSource(@PluginAttribute String jndiName) {
        if (!JndiManager.isJndiJdbcEnabled()) {
            LOGGER.error("JNDI must be enabled by setting `log4j.jndi.enableJdbc=\"true\"`\nSee {} for more details.", (Object)DOC_URL);
            return null;
        }
        if (Strings.isEmpty((CharSequence)jndiName)) {
            LOGGER.error("No JNDI name provided.");
            return null;
        }
        try {
            DataSource dataSource = (DataSource)JndiManager.getDefaultManager((String)JNDI_MANAGER_NAME).lookup(jndiName);
            if (dataSource != null) {
                return new DataSourceConnectionSource(jndiName, dataSource);
            }
            LOGGER.error("Failed to retrieve JNDI data source with name {}.", (Object)jndiName);
        }
        catch (NamingException e) {
            LOGGER.error("Failed to retrieve JNDI data source with name {}.", (Object)jndiName, (Object)e);
        }
        return null;
    }
}

