/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.appender;

import java.util.HashMap;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.core.Filter;
import org.apache.logging.log4j.core.Layout;
import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.core.appender.AbstractOutputStreamAppender;
import org.apache.logging.log4j.core.appender.rolling.DefaultRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectFileRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.DirectWriteRolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.RollingFileManager;
import org.apache.logging.log4j.core.appender.rolling.RolloverStrategy;
import org.apache.logging.log4j.core.appender.rolling.TriggeringPolicy;
import org.apache.logging.log4j.core.net.Advertiser;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginBuilderAttribute;
import org.apache.logging.log4j.plugins.PluginElement;
import org.apache.logging.log4j.plugins.PluginFactory;
import org.apache.logging.log4j.plugins.validation.constraints.Required;

@Configurable(elementType="appender", printObject=true)
@Plugin(value="RollingFile")
public final class RollingFileAppender
extends AbstractOutputStreamAppender<RollingFileManager> {
    public static final String PLUGIN_NAME = "RollingFile";
    private final String fileName;
    private final String filePattern;
    private Object advertisement;
    private final Advertiser advertiser;

    private RollingFileAppender(String name, Layout layout, Filter filter, RollingFileManager manager, String fileName, String filePattern, boolean ignoreExceptions, boolean immediateFlush, Advertiser advertiser) {
        super(name, layout, filter, ignoreExceptions, immediateFlush, null, manager);
        if (advertiser != null) {
            HashMap<String, String> configuration = new HashMap<String, String>(layout.getContentFormat());
            configuration.put("contentType", layout.getContentType());
            configuration.put("name", name);
            this.advertisement = advertiser.advertise(configuration);
        }
        this.fileName = fileName;
        this.filePattern = filePattern;
        this.advertiser = advertiser;
    }

    @Override
    public boolean stop(long timeout, TimeUnit timeUnit) {
        this.setStopping();
        boolean stopped = super.stop(timeout, timeUnit, false);
        if (this.advertiser != null) {
            this.advertiser.unadvertise(this.advertisement);
        }
        this.setStopped();
        return stopped;
    }

    @Override
    public void append(LogEvent event) {
        ((RollingFileManager)this.getManager()).checkRollover(event);
        super.append(event);
    }

    public String getFileName() {
        return this.fileName;
    }

    public String getFilePattern() {
        return this.filePattern;
    }

    public <T extends TriggeringPolicy> T getTriggeringPolicy() {
        return ((RollingFileManager)this.getManager()).getTriggeringPolicy();
    }

    @PluginFactory
    public static <B extends Builder<B>> B newBuilder() {
        return (B)((Builder)new Builder().asBuilder());
    }

    public static class Builder<B extends Builder<B>>
    extends AbstractOutputStreamAppender.Builder<B>
    implements org.apache.logging.log4j.plugins.util.Builder<RollingFileAppender> {
        @PluginBuilderAttribute
        private String fileName;
        @PluginBuilderAttribute
        @Required
        private String filePattern;
        @PluginBuilderAttribute
        private boolean append = true;
        @PluginBuilderAttribute
        private boolean locking;
        @PluginElement(value="Policy")
        @Required
        private @PluginElement(value="Policy") TriggeringPolicy policy;
        @PluginElement(value="Strategy")
        private @PluginElement(value="Strategy") RolloverStrategy strategy;
        @PluginBuilderAttribute
        private boolean advertise;
        @PluginBuilderAttribute
        private String advertiseUri;
        @PluginBuilderAttribute
        private boolean createOnDemand;
        @PluginBuilderAttribute
        private String filePermissions;
        @PluginBuilderAttribute
        private String fileOwner;
        @PluginBuilderAttribute
        private String fileGroup;

        public RollingFileAppender build() {
            boolean isBufferedIo = this.isBufferedIo();
            int bufferSize = this.getBufferSize();
            if (this.getName() == null) {
                LOGGER.error("RollingFileAppender '{}': No name provided.", (Object)this.getName());
                return null;
            }
            if (!isBufferedIo && bufferSize > 0) {
                LOGGER.warn("RollingFileAppender '{}': The bufferSize is set to {} but bufferedIO is not true", (Object)this.getName(), (Object)bufferSize);
            }
            if (this.filePattern == null) {
                LOGGER.error("RollingFileAppender '{}': No file name pattern provided.", (Object)this.getName());
                return null;
            }
            if (this.policy == null) {
                LOGGER.error("RollingFileAppender '{}': No TriggeringPolicy provided.", (Object)this.getName());
                return null;
            }
            if (this.strategy == null) {
                this.strategy = this.fileName != null ? DefaultRolloverStrategy.newBuilder().setConfig(this.getConfiguration()).build() : DirectWriteRolloverStrategy.newBuilder().setConfig(this.getConfiguration()).build();
            } else if (this.fileName == null && !(this.strategy instanceof DirectFileRolloverStrategy)) {
                LOGGER.error("RollingFileAppender '{}': When no file name is provided a {} must be configured", (Object)this.getName(), (Object)DirectFileRolloverStrategy.class.getSimpleName());
                return null;
            }
            Layout layout = this.getOrCreateLayout();
            RollingFileManager manager = RollingFileManager.getFileManager(this.fileName, this.filePattern, this.append, isBufferedIo, this.policy, this.strategy, this.advertiseUri, layout, bufferSize, this.isImmediateFlush(), this.createOnDemand, this.filePermissions, this.fileOwner, this.fileGroup, this.getConfiguration());
            if (manager == null) {
                return null;
            }
            manager.initialize();
            return new RollingFileAppender(this.getName(), layout, this.getFilter(), manager, this.fileName, this.filePattern, this.isIgnoreExceptions(), !isBufferedIo || this.isImmediateFlush(), this.advertise ? this.getConfiguration().getAdvertiser() : null);
        }

        public String getAdvertiseUri() {
            return this.advertiseUri;
        }

        public String getFileName() {
            return this.fileName;
        }

        public boolean isAdvertise() {
            return this.advertise;
        }

        public boolean isAppend() {
            return this.append;
        }

        public boolean isCreateOnDemand() {
            return this.createOnDemand;
        }

        public boolean isLocking() {
            return this.locking;
        }

        public String getFilePermissions() {
            return this.filePermissions;
        }

        public String getFileOwner() {
            return this.fileOwner;
        }

        public String getFileGroup() {
            return this.fileGroup;
        }

        public B setAdvertise(boolean advertise) {
            this.advertise = advertise;
            return (B)((Builder)this.asBuilder());
        }

        public B setAdvertiseUri(String advertiseUri) {
            this.advertiseUri = advertiseUri;
            return (B)((Builder)this.asBuilder());
        }

        public B setAppend(boolean append) {
            this.append = append;
            return (B)((Builder)this.asBuilder());
        }

        public B setFileName(String fileName) {
            this.fileName = fileName;
            return (B)((Builder)this.asBuilder());
        }

        public B setCreateOnDemand(boolean createOnDemand) {
            this.createOnDemand = createOnDemand;
            return (B)((Builder)this.asBuilder());
        }

        public B setLocking(boolean locking) {
            this.locking = locking;
            return (B)((Builder)this.asBuilder());
        }

        public String getFilePattern() {
            return this.filePattern;
        }

        public TriggeringPolicy getPolicy() {
            return this.policy;
        }

        public RolloverStrategy getStrategy() {
            return this.strategy;
        }

        public B setFilePattern(String filePattern) {
            this.filePattern = filePattern;
            return (B)((Builder)this.asBuilder());
        }

        public B setPolicy(TriggeringPolicy policy) {
            this.policy = policy;
            return (B)((Builder)this.asBuilder());
        }

        public B setStrategy(RolloverStrategy strategy) {
            this.strategy = strategy;
            return (B)((Builder)this.asBuilder());
        }

        public B setFilePermissions(String filePermissions) {
            this.filePermissions = filePermissions;
            return (B)((Builder)this.asBuilder());
        }

        public B setFileOwner(String fileOwner) {
            this.fileOwner = fileOwner;
            return (B)((Builder)this.asBuilder());
        }

        public B setFileGroup(String fileGroup) {
            this.fileGroup = fileGroup;
            return (B)((Builder)this.asBuilder());
        }
    }
}

