/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.core.test.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.core.LoggerContext;
import org.apache.logging.log4j.core.config.Configuration;
import org.apache.logging.log4j.core.config.ConfigurationSource;
import org.apache.logging.log4j.core.config.xml.XmlConfiguration;
import org.apache.logging.log4j.plugins.di.DI;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public abstract class AbstractNestedLoggerConfigTest {
    @Test
    public void testInheritParentDefaultLevel() throws IOException {
        Configuration configuration = this.loadConfiguration("/default-level.xml");
        try {
            Assertions.assertEquals((Object)Level.ERROR, (Object)configuration.getLoggerConfig("com.foo").getLevel());
        }
        finally {
            configuration.stop();
        }
    }

    @Test
    public void testInheritParentLevel() throws IOException {
        Configuration configuration = this.loadConfiguration("/inherit-level.xml");
        try {
            Assertions.assertEquals((Object)Level.TRACE, (Object)configuration.getLoggerConfig("com.foo").getLevel());
        }
        finally {
            configuration.stop();
        }
    }

    private Configuration loadConfiguration(String resourcePath) throws IOException {
        try (InputStream in = this.getClass().getResourceAsStream(this.getClass().getSimpleName() + resourcePath);){
            XmlConfiguration configuration = new XmlConfiguration(new LoggerContext("test", null, (URI)null, DI.createInitializedFactory()), new ConfigurationSource(in));
            configuration.initialize();
            configuration.start();
            XmlConfiguration xmlConfiguration = configuration;
            return xmlConfiguration;
        }
    }
}

