/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.plugin.processor;

import aQute.bnd.annotation.spi.ServiceProvider;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import javax.annotation.processing.AbstractProcessor;
import javax.annotation.processing.Messager;
import javax.annotation.processing.Processor;
import javax.annotation.processing.RoundEnvironment;
import javax.annotation.processing.SupportedAnnotationTypes;
import javax.lang.model.SourceVersion;
import javax.lang.model.element.AnnotationValue;
import javax.lang.model.element.Element;
import javax.lang.model.element.Name;
import javax.lang.model.element.TypeElement;
import javax.lang.model.util.SimpleElementVisitor8;
import javax.tools.Diagnostic;
import javax.tools.FileObject;
import javax.tools.JavaFileObject;
import javax.tools.StandardLocation;
import org.apache.logging.log4j.LoggingException;
import org.apache.logging.log4j.plugins.Configurable;
import org.apache.logging.log4j.plugins.Namespace;
import org.apache.logging.log4j.plugins.Plugin;
import org.apache.logging.log4j.plugins.PluginAliases;
import org.apache.logging.log4j.plugins.model.PluginEntry;
import org.apache.logging.log4j.util.Strings;

@SupportedAnnotationTypes(value={"org.apache.logging.log4j.plugins.*", "org.apache.logging.log4j.core.config.plugins.*"})
@ServiceProvider(value=Processor.class, resolution="optional")
public class PluginProcessor
extends AbstractProcessor {
    private static final String SERVICE_FILE_NAME = "META-INF/services/org.apache.logging.log4j.plugins.model.PluginService";

    @Override
    public SourceVersion getSupportedSourceVersion() {
        return SourceVersion.latest();
    }

    @Override
    public boolean process(Set<? extends TypeElement> annotations, RoundEnvironment roundEnv) {
        Map<String, String> options = this.processingEnv.getOptions();
        String packageName = options.get("pluginPackage");
        Messager messager = this.processingEnv.getMessager();
        messager.printMessage(Diagnostic.Kind.NOTE, "Processing Log4j annotations");
        try {
            Set<? extends Element> elements = roundEnv.getElementsAnnotatedWith(Plugin.class);
            if (elements.isEmpty()) {
                messager.printMessage(Diagnostic.Kind.NOTE, "No elements to process");
                return false;
            }
            messager.printMessage(Diagnostic.Kind.NOTE, "Retrieved " + elements.size() + " Plugin elements");
            ArrayList<PluginEntry> list = new ArrayList<PluginEntry>();
            packageName = this.collectPlugins(packageName, elements, list);
            messager.printMessage(Diagnostic.Kind.NOTE, "Writing plugin metadata using base package " + packageName);
            Collections.sort(list);
            this.writeClassFile(packageName, list);
            this.writeServiceFile(packageName);
            messager.printMessage(Diagnostic.Kind.NOTE, "Annotations processed");
        }
        catch (Exception ex) {
            StringWriter writer = new StringWriter();
            ex.printStackTrace(new PrintWriter(writer));
            this.error(writer.toString());
        }
        return false;
    }

    private void error(CharSequence message) {
        this.processingEnv.getMessager().printMessage(Diagnostic.Kind.ERROR, message);
    }

    private String collectPlugins(String packageName, Iterable<? extends Element> elements, List<PluginEntry> list) {
        boolean calculatePackage = packageName == null;
        PluginElementVisitor pluginVisitor = new PluginElementVisitor();
        PluginAliasesElementVisitor pluginAliasesVisitor = new PluginAliasesElementVisitor();
        for (Element element : elements) {
            Plugin plugin = element.getAnnotation(Plugin.class);
            if (plugin == null) continue;
            PluginEntry entry = element.accept(pluginVisitor, plugin);
            list.add(entry);
            if (calculatePackage) {
                packageName = this.calculatePackage(element, packageName);
            }
            list.addAll(element.accept(pluginAliasesVisitor, plugin));
        }
        return packageName;
    }

    private String calculatePackage(Element element, String packageName) {
        Name name = this.processingEnv.getElementUtils().getPackageOf(element).getQualifiedName();
        if (name == null) {
            return null;
        }
        String pkgName = name.toString();
        if (packageName == null) {
            return pkgName;
        }
        if (pkgName.length() == packageName.length()) {
            return packageName;
        }
        if (pkgName.length() < packageName.length() && packageName.startsWith(pkgName)) {
            return pkgName;
        }
        return this.commonPrefix(pkgName, packageName);
    }

    private void writeServiceFile(String pkgName) throws IOException {
        FileObject fileObject = this.processingEnv.getFiler().createResource(StandardLocation.CLASS_OUTPUT, "", SERVICE_FILE_NAME, new Element[0]);
        try (PrintWriter writer = new PrintWriter(new BufferedWriter(new OutputStreamWriter(fileObject.openOutputStream(), StandardCharsets.UTF_8)));){
            writer.println(this.createFqcn(pkgName));
        }
    }

    private void writeClassFile(String pkg, List<PluginEntry> list) {
        String fqcn = this.createFqcn(pkg);
        try (PrintWriter writer = this.createSourceFile(fqcn);){
            writer.println("package " + pkg + ".plugins;");
            writer.println("");
            writer.println("import aQute.bnd.annotation.Resolution;");
            writer.println("import aQute.bnd.annotation.spi.ServiceProvider;");
            writer.println("import org.apache.logging.log4j.plugins.model.PluginEntry;");
            writer.println("import org.apache.logging.log4j.plugins.model.PluginService;");
            writer.println("");
            writer.println("@ServiceProvider(value = PluginService.class, resolution = Resolution.OPTIONAL)");
            writer.println("public class Log4jPlugins extends PluginService {");
            writer.println("");
            writer.println("  private static final PluginEntry[] ENTRIES = new PluginEntry[] {");
            int max = list.size() - 1;
            for (int i = 0; i < list.size(); ++i) {
                PluginEntry entry = list.get(i);
                writer.println("    PluginEntry.builder()");
                writer.println(String.format("      .setKey(\"%s\")", entry.key()));
                writer.println(String.format("      .setClassName(\"%s\")", entry.className()));
                writer.println(String.format("      .setName(\"%s\")", entry.name()));
                writer.println(String.format("      .setNamespace(\"%s\")", entry.namespace()));
                String elementType = entry.elementType();
                if (Strings.isNotEmpty((CharSequence)elementType)) {
                    writer.println(String.format("      .setElementType(\"%s\")", elementType));
                }
                if (entry.printable()) {
                    writer.println("      .setPrintable(true)");
                }
                if (entry.deferChildren()) {
                    writer.println("      .setDeferChildren(true)");
                }
                writer.println("      .get()" + (i < max ? "," : ""));
            }
            writer.println("    };");
            writer.println("    @Override");
            writer.println("    public PluginEntry[] getEntries() { return ENTRIES; }");
            writer.println("}");
        }
    }

    private PrintWriter createSourceFile(String fqcn) {
        try {
            JavaFileObject sourceFile = this.processingEnv.getFiler().createSourceFile(fqcn, new Element[0]);
            return new PrintWriter(sourceFile.openWriter());
        }
        catch (IOException e) {
            throw new LoggingException("Unable to create Plugin Service Class " + fqcn, (Throwable)e);
        }
    }

    private String createFqcn(String packageName) {
        return packageName + ".plugins.Log4jPlugins";
    }

    private static String getNamespace(TypeElement e) {
        return Optional.ofNullable(e.getAnnotation(Namespace.class)).map(Namespace::value).orElseGet(() -> e.getAnnotationMirrors().stream().flatMap(annotationMirror -> annotationMirror.getAnnotationType().asElement().getAnnotationMirrors().stream()).filter(annotationMirror -> annotationMirror.getAnnotationType().asElement().getSimpleName().contentEquals(Namespace.class.getSimpleName())).flatMap(annotationMirror -> annotationMirror.getElementValues().values().stream().map(AnnotationValue::getValue).map(Objects::toString)).findFirst().orElse(""));
    }

    private static PluginEntry configureNamespace(TypeElement e, PluginEntry.Builder builder) {
        Configurable configurable = e.getAnnotation(Configurable.class);
        if (configurable != null) {
            builder.setNamespace("Core").setElementType(configurable.elementType().isEmpty() ? builder.getName() : configurable.elementType()).setDeferChildren(configurable.deferChildren()).setPrintable(configurable.printObject());
        } else {
            builder.setNamespace(PluginProcessor.getNamespace(e));
        }
        return builder.get();
    }

    private String commonPrefix(String str1, String str2) {
        int minLength = Math.min(str1.length(), str2.length());
        for (int i = 0; i < minLength; ++i) {
            if (str1.charAt(i) == str2.charAt(i)) continue;
            if (i > 1 && str1.charAt(i - 1) == '.') {
                return str1.substring(0, i - 1);
            }
            return str1.substring(0, i);
        }
        return str1.substring(0, minLength);
    }

    private final class PluginElementVisitor
    extends SimpleElementVisitor8<PluginEntry, Plugin> {
        private PluginElementVisitor() {
        }

        @Override
        public PluginEntry visitType(TypeElement e, Plugin plugin) {
            Objects.requireNonNull(plugin, "Plugin annotation is null.");
            String name = plugin.value();
            if (name.isEmpty()) {
                name = e.getSimpleName().toString();
            }
            PluginEntry.Builder builder = PluginEntry.builder().setKey(name.toLowerCase(Locale.ROOT)).setName(name).setClassName(PluginProcessor.this.processingEnv.getElementUtils().getBinaryName(e).toString());
            return PluginProcessor.configureNamespace(e, builder);
        }
    }

    private final class PluginAliasesElementVisitor
    extends SimpleElementVisitor8<Collection<PluginEntry>, Plugin> {
        private PluginAliasesElementVisitor() {
            super(List.of());
        }

        @Override
        public Collection<PluginEntry> visitType(TypeElement e, Plugin plugin) {
            PluginAliases aliases = e.getAnnotation(PluginAliases.class);
            if (aliases == null) {
                return (Collection)this.DEFAULT_VALUE;
            }
            String name = plugin.value();
            if (name.isEmpty()) {
                name = e.getSimpleName().toString();
            }
            PluginEntry.Builder builder = PluginEntry.builder().setName(name).setClassName(PluginProcessor.this.processingEnv.getElementUtils().getBinaryName(e).toString());
            PluginProcessor.configureNamespace(e, builder);
            ArrayList<PluginEntry> entries = new ArrayList<PluginEntry>(aliases.value().length);
            for (String alias : aliases.value()) {
                PluginEntry entry = builder.setKey(alias.toLowerCase(Locale.ROOT)).get();
                entries.add(entry);
            }
            return entries;
        }
    }
}

