/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.async.logger.internal;

import com.lmax.disruptor.BlockingWaitStrategy;
import com.lmax.disruptor.BusySpinWaitStrategy;
import com.lmax.disruptor.SleepingWaitStrategy;
import com.lmax.disruptor.WaitStrategy;
import com.lmax.disruptor.YieldingWaitStrategy;
import java.util.concurrent.TimeUnit;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.async.logger.AsyncLoggerProperties;
import org.apache.logging.log4j.async.logger.AsyncWaitStrategyFactory;
import org.apache.logging.log4j.async.logger.internal.TimeoutBlockingWaitStrategy;
import org.apache.logging.log4j.status.StatusLogger;
import org.apache.logging.log4j.util.Strings;

public class DefaultAsyncWaitStrategyFactory
implements AsyncWaitStrategyFactory {
    private static final Logger LOGGER = StatusLogger.getLogger();
    private final AsyncLoggerProperties.WaitStrategyProperties properties;

    public DefaultAsyncWaitStrategyFactory(AsyncLoggerProperties.WaitStrategyProperties properties) {
        this.properties = properties;
    }

    @Override
    public WaitStrategy createWaitStrategy() {
        LOGGER.trace("DefaultAsyncWaitStrategyFactory strategy name: {}", (Object)this.properties.type());
        return switch (Strings.toRootUpperCase((String)this.properties.type())) {
            case "SLEEP" -> {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating SleepingWaitStrategy(retries={}, sleepTimeNs={})", (Object)this.properties.retries(), (Object)this.properties.sleepTimeNs());
                yield new SleepingWaitStrategy(this.properties.retries(), this.properties.sleepTimeNs());
            }
            case "YIELD" -> {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating YieldingWaitStrategy");
                yield new YieldingWaitStrategy();
            }
            case "BLOCK" -> {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BlockingWaitStrategy");
                yield new BlockingWaitStrategy();
            }
            case "BUSYSPIN" -> {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating BusySpinWaitStrategy");
                yield new BusySpinWaitStrategy();
            }
            default -> {
                LOGGER.trace("DefaultAsyncWaitStrategyFactory creating TimeoutBlockingWaitStrategy(timeout={}, unit=MILLIS)", (Object)this.properties.timeout());
                yield new TimeoutBlockingWaitStrategy(this.properties.timeout(), TimeUnit.MILLISECONDS);
            }
        };
    }
}

