/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.layout.template.json.resolver;

import org.apache.logging.log4j.core.LogEvent;
import org.apache.logging.log4j.layout.template.json.resolver.EventResolver;
import org.apache.logging.log4j.layout.template.json.resolver.TemplateResolverConfig;
import org.apache.logging.log4j.layout.template.json.util.JsonWriter;

public final class ThreadResolver
implements EventResolver {
    private static final EventResolver NAME_RESOLVER = (logEvent, jsonWriter) -> {
        String threadName = logEvent.getThreadName();
        jsonWriter.writeString(threadName);
    };
    private static final EventResolver ID_RESOLVER = (logEvent, jsonWriter) -> {
        long threadId = logEvent.getThreadId();
        jsonWriter.writeNumber(threadId);
    };
    private static final EventResolver PRIORITY_RESOLVER = (logEvent, jsonWriter) -> {
        int threadPriority = logEvent.getThreadPriority();
        jsonWriter.writeNumber(threadPriority);
    };
    private final EventResolver internalResolver;

    ThreadResolver(TemplateResolverConfig config) {
        this.internalResolver = ThreadResolver.createInternalResolver(config);
    }

    private static EventResolver createInternalResolver(TemplateResolverConfig config) {
        String fieldName = config.getString("field");
        if ("name".equals(fieldName)) {
            return NAME_RESOLVER;
        }
        if ("id".equals(fieldName)) {
            return ID_RESOLVER;
        }
        if ("priority".equals(fieldName)) {
            return PRIORITY_RESOLVER;
        }
        throw new IllegalArgumentException("unknown field: " + config);
    }

    static String getName() {
        return "thread";
    }

    @Override
    public void resolve(LogEvent logEvent, JsonWriter jsonWriter) {
        this.internalResolver.resolve(logEvent, jsonWriter);
    }
}

