/*
 * Decompiled with CFR 0.152.
 */
package org.apache.logging.log4j.catalog.api.plugins;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.apache.logging.log4j.catalog.api.ConstraintType;
import org.apache.logging.log4j.catalog.api.exception.ConstraintCreationException;
import org.apache.logging.log4j.core.config.plugins.util.PluginManager;
import org.apache.logging.log4j.core.config.plugins.util.PluginType;
import org.apache.logging.log4j.core.util.ReflectionUtil;

public class ConstraintPlugins {
    private static Logger LOGGER = LogManager.getLogger(ConstraintPlugins.class);
    private static Map<String, ConstraintType> constraintMap = new HashMap<String, ConstraintType>();
    private static volatile ConstraintPlugins instance = null;
    private static final Object LOCK = new Object();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ConstraintPlugins getInstance() {
        if (instance == null) {
            Object object = LOCK;
            synchronized (object) {
                if (instance == null) {
                    instance = new ConstraintPlugins();
                }
            }
        }
        return instance;
    }

    private ConstraintPlugins() {
        PluginManager manager = new PluginManager("Constraint");
        if (LOGGER instanceof org.apache.logging.log4j.core.Logger) {
            List pluginPackages = ((org.apache.logging.log4j.core.Logger)LOGGER).getContext().getConfiguration().getPluginPackages();
            manager.collectPlugins(pluginPackages);
        } else {
            manager.collectPlugins();
        }
        Map plugins = manager.getPlugins();
        for (Map.Entry entry : plugins.entrySet()) {
            try {
                Class<ConstraintType> clazz = ((PluginType)entry.getValue()).getPluginClass().asSubclass(ConstraintType.class);
                ConstraintType constraintType = (ConstraintType)ReflectionUtil.instantiate(clazz);
                constraintMap.put((String)entry.getKey(), constraintType);
            }
            catch (Throwable t) {
                throw new ConstraintCreationException("Unable to create constraint for " + (String)entry.getKey(), t);
            }
        }
    }

    public void validateConstraint(boolean isRequestContext, String constraint, String name, String value, String constraintValue, StringBuilder errors) {
        ConstraintType constraintType = constraintMap.get(constraint.toLowerCase(Locale.US));
        if (constraintType == null) {
            if (errors.length() > 0) {
                errors.append("\n");
            }
            errors.append("Unable to locate constraint type ").append(constraint);
            if (isRequestContext) {
                errors.append(" for ThreadContext key ");
            } else {
                errors.append(" for key ");
            }
            errors.append(name);
            return;
        }
        constraintType.validate(isRequestContext, name, value, constraintValue, errors);
    }

    public ConstraintType findByName(String name) {
        return constraintMap.get(name.toLowerCase(Locale.US));
    }

    public Map<String, ConstraintType> getConstraintMap() {
        return Collections.unmodifiableMap(constraintMap);
    }
}

