/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.features.internal.service;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.apache.felix.utils.manifest.Clause;
import org.apache.felix.utils.manifest.Parser;
import org.apache.felix.utils.version.VersionRange;
import org.apache.felix.utils.version.VersionTable;
import org.apache.karaf.features.internal.model.Bundle;
import org.apache.karaf.features.internal.model.Conditional;
import org.apache.karaf.features.internal.model.Feature;
import org.apache.karaf.features.internal.model.Features;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Blacklist {
    protected static final String BLACKLIST_URL = "url";
    protected static final String BLACKLIST_RANGE = "range";
    private static final Logger LOGGER = LoggerFactory.getLogger(Blacklist.class);

    private Blacklist() {
    }

    public static void blacklist(Features features, String blacklisted) {
        Set<String> blacklist = Blacklist.loadBlacklist(blacklisted);
        Blacklist.blacklist(features, blacklist);
    }

    public static void blacklist(Features features, Collection<String> blacklist) {
        if (!blacklist.isEmpty()) {
            Clause[] clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]));
            Blacklist.blacklist(features, clauses);
        }
    }

    public static void blacklist(Features features, Clause[] clauses) {
        Iterator<Feature> iterator = features.getFeature().iterator();
        while (iterator.hasNext()) {
            Feature feature = iterator.next();
            if (!Blacklist.blacklist(feature, clauses)) continue;
            iterator.remove();
        }
    }

    public static boolean blacklist(Feature feature, Clause[] clauses) {
        for (Clause clause : clauses) {
            if (clause.getName().equals(feature.getName())) {
                VersionRange range = VersionRange.ANY_VERSION;
                String vr = clause.getAttribute(BLACKLIST_RANGE);
                if (vr != null) {
                    range = new VersionRange(vr, true);
                }
                if (range.contains(VersionTable.getVersion(feature.getVersion()))) {
                    return true;
                }
            }
            Blacklist.blacklist(feature.getBundle(), clauses);
            for (Conditional cond : feature.getConditional()) {
                Blacklist.blacklist(cond.getBundle(), clauses);
            }
        }
        return false;
    }

    private static void blacklist(List<Bundle> bundles, Clause[] clauses) {
        Iterator<Bundle> iterator = bundles.iterator();
        block0: while (iterator.hasNext()) {
            Bundle info = iterator.next();
            for (Clause clause : clauses) {
                String url = clause.getName();
                if (clause.getAttribute(BLACKLIST_URL) != null) {
                    url = clause.getAttribute(BLACKLIST_URL);
                }
                if (!info.getLocation().equals(url)) continue;
                iterator.remove();
                continue block0;
            }
        }
    }

    public static Set<String> loadBlacklist(String blacklistUrl) {
        HashSet<String> blacklist;
        block15: {
            blacklist = new HashSet<String>();
            try {
                if (blacklistUrl == null) break block15;
                try (InputStream is = new URL(blacklistUrl).openStream();){
                    String line;
                    BufferedReader reader = new BufferedReader(new InputStreamReader(is));
                    while ((line = reader.readLine()) != null) {
                        if ((line = line.trim()).isEmpty() || line.startsWith("#")) continue;
                        blacklist.add(line);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.debug("Unable to load overrides bundles list", (Throwable)e);
            }
        }
        return blacklist;
    }

    public static boolean isFeatureBlacklisted(List<String> blacklist, String name, String version) {
        Clause[] clauses;
        for (Clause clause : clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]))) {
            if (!clause.getName().equals(name)) continue;
            VersionRange range = VersionRange.ANY_VERSION;
            String vr = clause.getAttribute(BLACKLIST_RANGE);
            if (vr != null) {
                range = new VersionRange(vr, true);
            }
            if (!range.contains(VersionTable.getVersion(version))) continue;
            return true;
        }
        return false;
    }

    public static boolean isBundleBlacklisted(List<String> blacklist, String uri) {
        Clause[] clauses;
        for (Clause clause : clauses = Parser.parseClauses(blacklist.toArray(new String[blacklist.size()]))) {
            String url = clause.getName();
            if (clause.getAttribute(BLACKLIST_URL) != null) {
                url = clause.getAttribute(BLACKLIST_URL);
            }
            if (!uri.equals(url)) continue;
            return true;
        }
        return false;
    }
}

