/****************************************************************
 * Licensed to the Apache Software Foundation (ASF) under one   *
 * or more contributor license agreements.  See the NOTICE file *
 * distributed with this work for additional information        *
 * regarding copyright ownership.  The ASF licenses this file   *
 * to you under the Apache License, Version 2.0 (the            *
 * "License"); you may not use this file except in compliance   *
 * with the License.  You may obtain a copy of the License at   *
 *                                                              *
 *   http://www.apache.org/licenses/LICENSE-2.0                 *
 *                                                              *
 * Unless required by applicable law or agreed to in writing,   *
 * software distributed under the License is distributed on an  *
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY       *
 * KIND, either express or implied.  See the License for the    *
 * specific language governing permissions and limitations      *
 * under the License.                                           *
 ****************************************************************/

package org.apache.james.jmap.api.change;

import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Stream;

import org.apache.james.jmap.api.model.AccountId;

import com.google.common.collect.ImmutableList;

public interface JmapChange {
    AccountId getAccountId();

    JmapChange forSharee(AccountId accountId, Supplier<State> state);

    boolean isNoop();

    default ImmutableList<JmapChange> propagateToSharee(List<AccountId> sharees, State.Factory stateFactory) {
        if (isNoop()) {
            return ImmutableList.of();
        }
        return Stream.concat(Stream.of(this), sharees.stream()
                .map(shareeId -> forSharee(shareeId, stateFactory::generate)))
            .collect(ImmutableList.toImmutableList());
    }
}
