/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james;

import com.google.common.collect.Iterables;
import com.google.inject.Guice;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.util.Modules;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.annotation.PreDestroy;
import org.apache.james.IsStartedProbe;
import org.apache.james.StartUpChecksPerformer;
import org.apache.james.modules.CommonServicesModule;
import org.apache.james.modules.IsStartedProbeModule;
import org.apache.james.onami.lifecycle.Stager;
import org.apache.james.server.core.configuration.Configuration;
import org.apache.james.utils.GuiceProbe;
import org.apache.james.utils.GuiceProbeProvider;
import org.apache.james.utils.InitializationOperations;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GuiceJamesServer {
    private static final Logger LOGGER = LoggerFactory.getLogger(GuiceJamesServer.class);
    protected final Module module;
    private final IsStartedProbe isStartedProbe;
    private Stager<PreDestroy> preDestroy;
    private GuiceProbeProvider guiceProbeProvider;

    public static GuiceJamesServer forConfiguration(Configuration configuration) {
        IsStartedProbe isStartedProbe = new IsStartedProbe();
        return new GuiceJamesServer(isStartedProbe, Modules.combine((Module[])new Module[]{new IsStartedProbeModule(isStartedProbe), new CommonServicesModule(configuration)}));
    }

    protected GuiceJamesServer(IsStartedProbe isStartedProbe, Module module) {
        this.isStartedProbe = isStartedProbe;
        this.module = module;
    }

    public GuiceJamesServer combineWith(Module ... modules) {
        return this.combineWith(Arrays.asList(modules));
    }

    public GuiceJamesServer combineWith(Collection<Module> modules) {
        return new GuiceJamesServer(this.isStartedProbe, Modules.combine((Iterable)Iterables.concat(Arrays.asList(this.module), modules)));
    }

    public GuiceJamesServer overrideWith(Module ... overrides) {
        return new GuiceJamesServer(this.isStartedProbe, Modules.override((Module[])new Module[]{this.module}).with(overrides));
    }

    public GuiceJamesServer overrideWith(List<Module> overrides) {
        return new GuiceJamesServer(this.isStartedProbe, Modules.override((Module[])new Module[]{this.module}).with(overrides));
    }

    public void start() throws Exception {
        try {
            Injector injector = Guice.createInjector((Module[])new Module[]{this.module});
            this.preDestroy = (Stager)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Stager<PreDestroy>>(){}));
            ((StartUpChecksPerformer)injector.getInstance(StartUpChecksPerformer.class)).performCheck();
            ((InitializationOperations)injector.getInstance(InitializationOperations.class)).initModules();
            this.guiceProbeProvider = (GuiceProbeProvider)injector.getInstance(GuiceProbeProvider.class);
            this.isStartedProbe.notifyStarted();
            LOGGER.info("JAMES server started");
        }
        catch (Throwable e) {
            LOGGER.error("Fatal error while starting James", e);
            throw e;
        }
    }

    public void stop() {
        this.isStartedProbe.notifyStoped();
        if (this.preDestroy != null) {
            this.preDestroy.stage();
        }
        LOGGER.info("JAMES server stopped");
    }

    public boolean isStarted() {
        return this.isStartedProbe.isStarted();
    }

    public <T extends GuiceProbe> T getProbe(Class<T> probe) {
        return this.guiceProbeProvider.getProbe(probe);
    }
}

