/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.webadmin.service;

import com.fasterxml.jackson.annotation.JsonProperty;
import java.time.Instant;
import java.util.Optional;
import org.apache.james.json.DTOModule;
import org.apache.james.mailrepository.api.MailKey;
import org.apache.james.mailrepository.api.MailRepositoryPath;
import org.apache.james.queue.api.MailQueueName;
import org.apache.james.server.task.json.dto.AdditionalInformationDTO;
import org.apache.james.server.task.json.dto.AdditionalInformationDTOModule;
import org.apache.james.util.streams.Limit;
import org.apache.james.webadmin.service.ReprocessingOneMailTask;
import org.apache.james.webadmin.service.ReprocessingService;

public class ReprocessingOneMailTaskAdditionalInformationDTO
implements AdditionalInformationDTO {
    private final String type;
    private final String repositoryPath;
    private final String targetQueue;
    private final String mailKey;
    private final Optional<String> targetProcessor;
    private final boolean consume;
    private final Instant timestamp;

    public static AdditionalInformationDTOModule<ReprocessingOneMailTask.AdditionalInformation, ReprocessingOneMailTaskAdditionalInformationDTO> module() {
        return (AdditionalInformationDTOModule)DTOModule.forDomainObject(ReprocessingOneMailTask.AdditionalInformation.class).convertToDTO(ReprocessingOneMailTaskAdditionalInformationDTO.class).toDomainObjectConverter(dto -> new ReprocessingOneMailTask.AdditionalInformation(MailRepositoryPath.from((String)dto.repositoryPath), new ReprocessingService.Configuration(MailQueueName.of((String)dto.targetQueue), dto.targetProcessor, dto.isConsume(), Limit.unlimited()), new MailKey(dto.mailKey), dto.timestamp)).toDTOConverter((details, type) -> new ReprocessingOneMailTaskAdditionalInformationDTO(type, details.getRepositoryPath(), details.getConfiguration().getMailQueueName().asString(), details.getMailKey(), Optional.of(details.getConfiguration().isConsume()), details.getConfiguration().getTargetProcessor(), details.timestamp())).typeName(ReprocessingOneMailTask.TYPE.asString()).withFactory(AdditionalInformationDTOModule::new);
    }

    public ReprocessingOneMailTaskAdditionalInformationDTO(@JsonProperty(value="type") String type, @JsonProperty(value="repositoryPath") String repositoryPath, @JsonProperty(value="targetQueue") String targetQueue, @JsonProperty(value="mailKey") String mailKey, @JsonProperty(value="consume") Optional<Boolean> consume, @JsonProperty(value="targetProcessor") Optional<String> targetProcessor, @JsonProperty(value="timestamp") Instant timestamp) {
        this.type = type;
        this.consume = consume.orElse(true);
        this.repositoryPath = repositoryPath;
        this.targetQueue = targetQueue;
        this.mailKey = mailKey;
        this.targetProcessor = targetProcessor;
        this.timestamp = timestamp;
    }

    public boolean isConsume() {
        return this.consume;
    }

    public String getType() {
        return this.type;
    }

    public String getRepositoryPath() {
        return this.repositoryPath;
    }

    public String getTargetQueue() {
        return this.targetQueue;
    }

    public String getMailKey() {
        return this.mailKey;
    }

    public Instant getTimestamp() {
        return this.timestamp;
    }

    public Optional<String> getTargetProcessor() {
        return this.targetProcessor;
    }
}

