/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jdkim.tagvalue;

import java.util.Arrays;
import java.util.LinkedList;
import java.util.List;
import java.util.regex.Pattern;
import org.apache.james.jdkim.api.SignatureRecord;
import org.apache.james.jdkim.codec.binary.Base64;
import org.apache.james.jdkim.tagvalue.TagValue;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignatureRecordImpl
extends TagValue
implements SignatureRecord {
    private static Pattern hdrNamePattern = Pattern.compile("^[^: \r\n\t]+$");

    public SignatureRecordImpl(String data) {
        super(data);
    }

    @Override
    protected void init() {
        this.mandatoryTags.add("v");
        this.mandatoryTags.add("a");
        this.mandatoryTags.add("b");
        this.mandatoryTags.add("bh");
        this.mandatoryTags.add("d");
        this.mandatoryTags.add("h");
        this.mandatoryTags.add("s");
        this.defaults.put("c", "simple/simple");
        this.defaults.put("l", ";all;");
        this.defaults.put("q", "dns/txt");
    }

    @Override
    public void validate() throws IllegalStateException {
        long expiration;
        long lifetime;
        CharSequence identity;
        super.validate();
        if (!"1".equals(this.getValue("v"))) {
            throw new IllegalStateException("Invalid DKIM-Signature version (expected '1'): " + this.getValue("v"));
        }
        if (this.getValue("h").length() == 0) {
            throw new IllegalStateException("Tag h= cannot be empty.");
        }
        try {
            identity = this.getIdentity();
        }
        catch (IllegalArgumentException e) {
            throw new IllegalStateException("Identity (i=) declaration cannot be parsed. Probably due to missing quoted printable encoding", e);
        }
        if (!((Object)identity).toString().toLowerCase().endsWith(("@" + this.getValue("d")).toLowerCase()) && !((Object)this.getIdentity()).toString().toLowerCase().endsWith(("." + this.getValue("d")).toLowerCase())) {
            throw new IllegalStateException("Identity (i=) domain mismatch: expected [optional]@[optional.]domain-from-d-attribute");
        }
        if (this.getValue("x") != null && (lifetime = (expiration = Long.parseLong(((Object)this.getValue("x")).toString())) - System.currentTimeMillis() / 1000L) < 0L) {
            throw new IllegalStateException("Signature is expired since " + this.getTimeMeasure(lifetime) + ".");
        }
        if (!this.isInListCaseInsensitive("from", this.getHeaders())) {
            throw new IllegalStateException("From field not signed");
        }
    }

    private String getTimeMeasure(long lifetime) {
        String measure = "s";
        if ((lifetime = -lifetime) > 600L) {
            measure = "m";
            if ((lifetime /= 60L) > 600L) {
                measure = "h";
                if ((lifetime /= 60L) > 120L) {
                    measure = "d";
                    if ((lifetime /= 24L) > 90L) {
                        measure = " months";
                        if ((lifetime /= 30L) > 24L) {
                            lifetime /= 12L;
                            measure = " years";
                        }
                    }
                }
            }
        }
        String lifetimeMeasure = lifetime + measure;
        return lifetimeMeasure;
    }

    @Override
    public List<CharSequence> getHeaders() {
        return this.stringToColonSeparatedList(((Object)this.getValue("h")).toString(), hdrNamePattern);
    }

    @Override
    protected CharSequence getDefault(String tag) {
        if ("i".equals(tag)) {
            return "@" + this.getValue("d");
        }
        return super.getDefault(tag);
    }

    @Override
    public CharSequence getIdentityLocalPart() {
        String identity = ((Object)this.getIdentity()).toString();
        int pAt = identity.indexOf(64);
        return identity.subSequence(0, pAt);
    }

    @Override
    public CharSequence getIdentity() {
        return SignatureRecordImpl.dkimQuotedPrintableDecode(this.getValue("i"));
    }

    public static String dkimQuotedPrintableDecode(CharSequence input) throws IllegalArgumentException {
        StringBuilder sb = new StringBuilder(input.length());
        int state = 0;
        int start = 0;
        int d = 0;
        boolean lastWasNL = false;
        block8: for (int i = 0; i < input.length(); ++i) {
            if (lastWasNL && input.charAt(i) != ' ' && input.charAt(i) != '\t') {
                throw new IllegalArgumentException("Unexpected LF not part of an FWS");
            }
            lastWasNL = false;
            switch (state) {
                case 0: {
                    switch (input.charAt(i)) {
                        case '\t': 
                        case '\n': 
                        case '\r': 
                        case ' ': {
                            if ('\n' == input.charAt(i)) {
                                lastWasNL = true;
                            }
                            sb.append(input.subSequence(start, i));
                            start = i + 1;
                            break;
                        }
                        case '=': {
                            sb.append(input.subSequence(start, i));
                            state = 1;
                        }
                    }
                    continue block8;
                }
                case 1: 
                case 2: {
                    if (input.charAt(i) >= '0' && input.charAt(i) <= '9' || input.charAt(i) >= 'A' && input.charAt(i) <= 'F') {
                        int v = Arrays.binarySearch("0123456789ABCDEF".getBytes(), (byte)input.charAt(i));
                        if (state == 1) {
                            state = 2;
                            d = v;
                            continue block8;
                        }
                        d = d * 16 + v;
                        sb.append((char)d);
                        state = 0;
                        start = i + 1;
                        continue block8;
                    }
                    throw new IllegalArgumentException("Invalid input sequence at " + i);
                }
            }
        }
        if (state != 0) {
            throw new IllegalArgumentException("Invalid quoted printable termination");
        }
        sb.append(input.subSequence(start, input.length()));
        return sb.toString();
    }

    @Override
    public CharSequence getHashKeyType() {
        String a = ((Object)this.getValue("a")).toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash algorythm (key type): " + a);
        }
        return a.subSequence(0, pHyphen);
    }

    @Override
    public CharSequence getHashMethod() {
        String a = ((Object)this.getValue("a")).toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash method: " + a);
        }
        return a.subSequence(pHyphen + 1, a.length());
    }

    @Override
    public CharSequence getHashAlgo() {
        String a = ((Object)this.getValue("a")).toString();
        int pHyphen = a.indexOf(45);
        if (pHyphen == -1) {
            throw new IllegalStateException("Invalid hash method: " + a);
        }
        if (a.length() > pHyphen + 3 && a.charAt(pHyphen + 1) == 's' && a.charAt(pHyphen + 2) == 'h' && a.charAt(pHyphen + 3) == 'a') {
            return "sha-" + a.subSequence(pHyphen + 4, a.length());
        }
        return a.subSequence(pHyphen + 1, a.length());
    }

    @Override
    public CharSequence getSelector() {
        return this.getValue("s");
    }

    @Override
    public CharSequence getDToken() {
        return this.getValue("d");
    }

    @Override
    public byte[] getBodyHash() {
        return Base64.decodeBase64(((Object)this.getValue("bh")).toString().getBytes());
    }

    @Override
    public byte[] getSignature() {
        return Base64.decodeBase64(((Object)this.getValue("b")).toString().getBytes());
    }

    @Override
    public int getBodyHashLimit() {
        String limit = ((Object)this.getValue("l")).toString();
        if (";all;".equals(limit)) {
            return -1;
        }
        return Integer.parseInt(limit);
    }

    @Override
    public Long getSignatureTimestamp() {
        CharSequence cs = this.getValue("t");
        if (cs == null) {
            return null;
        }
        return Long.parseLong(((Object)cs).toString());
    }

    @Override
    public String getBodyCanonicalisationMethod() {
        String c = ((Object)this.getValue("c")).toString();
        int pSlash = c.toString().indexOf("/");
        if (pSlash != -1) {
            return c.substring(pSlash + 1);
        }
        return "simple";
    }

    @Override
    public String getHeaderCanonicalisationMethod() {
        String c = ((Object)this.getValue("c")).toString();
        int pSlash = c.toString().indexOf("/");
        if (pSlash != -1) {
            return c.substring(0, pSlash);
        }
        return c;
    }

    @Override
    public List<CharSequence> getRecordLookupMethods() {
        String flags = ((Object)this.getValue("q")).toString();
        String[] flagsStrings = flags.split(":");
        LinkedList<CharSequence> res = new LinkedList<CharSequence>();
        for (int i = 0; i < flagsStrings.length; ++i) {
            res.add(this.trimFWS(flagsStrings[i], 0, flagsStrings[i].length() - 1, true));
        }
        return res;
    }

    @Override
    public void setSignature(byte[] newSignature) {
        String signature = new String(Base64.encodeBase64(newSignature));
        this.setValue("b", signature);
    }

    @Override
    public void setBodyHash(byte[] newBodyHash) {
        String bodyHash = new String(Base64.encodeBase64(newBodyHash));
        this.setValue("bh", bodyHash);
        if (this.getValue("t") != null && ((Object)this.getValue("t")).toString().trim().length() == 0) {
            this.setValue("t", "" + System.currentTimeMillis() / 1000L);
        }
    }

    @Override
    public String toUnsignedString() {
        return this.toString().replaceFirst("b=[^;]*", "b=");
    }
}

