/*
 * Decompiled with CFR 0.152.
 */
package io.netty.incubator.codec.quic;

import io.netty.incubator.codec.quic.Quiche;
import io.netty.incubator.codec.quic.SockaddrIn;
import java.net.InetSocketAddress;
import java.nio.ByteBuffer;

final class QuicheRecvInfo {
    private QuicheRecvInfo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static void setRecvInfo(ByteBuffer memory, InetSocketAddress address) {
        int position = memory.position();
        try {
            int sockaddrPosition = position + Quiche.SIZEOF_QUICHE_RECV_INFO;
            memory.position(sockaddrPosition);
            long sockaddrMemoryAddress = Quiche.memoryAddressWithPosition(memory);
            int len = SockaddrIn.setAddress(memory, address);
            if (Quiche.SIZEOF_SIZE_T == 4) {
                memory.putInt(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM, (int)sockaddrMemoryAddress);
            } else {
                memory.putLong(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM, sockaddrMemoryAddress);
            }
            switch (Quiche.SIZEOF_SOCKLEN_T) {
                case 1: {
                    memory.put(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM_LEN, (byte)len);
                    return;
                }
                case 2: {
                    memory.putShort(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM_LEN, (short)len);
                    return;
                }
                case 4: {
                    memory.putInt(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM_LEN, len);
                    return;
                }
                case 8: {
                    memory.putLong(position + Quiche.QUICHE_RECV_INFO_OFFSETOF_FROM_LEN, len);
                    return;
                }
                default: {
                    throw new IllegalStateException();
                }
            }
        }
        finally {
            memory.position(position);
        }
    }

    static boolean isSameAddress(ByteBuffer memory, ByteBuffer memory2) {
        long address2;
        long address1 = Quiche.memoryAddressWithPosition(memory) + (long)Quiche.SIZEOF_QUICHE_RECV_INFO;
        return SockaddrIn.cmp(address1, address2 = Quiche.memoryAddressWithPosition(memory2) + (long)Quiche.SIZEOF_QUICHE_RECV_INFO) == 0;
    }
}

