/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.client.ml.job.config;

import java.io.IOException;
import java.util.Locale;
import java.util.Objects;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.xcontent.ConstructingObjectParser;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;

public class FilterRef
implements ToXContentObject {
    public static final ParseField FILTER_REF_FIELD = new ParseField("filter_ref", new String[0]);
    public static final ParseField FILTER_ID = new ParseField("filter_id", new String[0]);
    public static final ParseField FILTER_TYPE = new ParseField("filter_type", new String[0]);
    public static final ConstructingObjectParser<FilterRef, Void> PARSER = new ConstructingObjectParser(FILTER_REF_FIELD.getPreferredName(), true, a -> new FilterRef((String)a[0], (FilterType)((Object)((Object)a[1]))));
    private final String filterId;
    private final FilterType filterType;

    public FilterRef(String filterId, FilterType filterType) {
        this.filterId = Objects.requireNonNull(filterId);
        this.filterType = filterType == null ? FilterType.INCLUDE : filterType;
    }

    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder.startObject();
        builder.field(FILTER_ID.getPreferredName(), this.filterId);
        builder.field(FILTER_TYPE.getPreferredName(), (Object)this.filterType);
        builder.endObject();
        return builder;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof FilterRef)) {
            return false;
        }
        FilterRef other = (FilterRef)obj;
        return Objects.equals(this.filterId, other.filterId) && Objects.equals((Object)this.filterType, (Object)other.filterType);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.filterId, this.filterType});
    }

    public String getFilterId() {
        return this.filterId;
    }

    public FilterType getFilterType() {
        return this.filterType;
    }

    static {
        PARSER.declareString(ConstructingObjectParser.constructorArg(), FILTER_ID);
        PARSER.declareString(ConstructingObjectParser.optionalConstructorArg(), FilterType::fromString, FILTER_TYPE);
    }

    public static enum FilterType {
        INCLUDE,
        EXCLUDE;


        public static FilterType fromString(String value) {
            return FilterType.valueOf(value.toUpperCase(Locale.ROOT));
        }

        public String toString() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }
}

