/*
 * Decompiled with CFR 0.152.
 */
package org.apache.james.jmap.draft.utils;

import com.github.fge.lambdas.Throwing;
import com.google.common.annotations.VisibleForTesting;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.james.mailbox.MailboxManager;
import org.apache.james.mailbox.MailboxSession;
import org.apache.james.mailbox.MessageManager;
import org.apache.james.mailbox.exception.MailboxException;
import org.apache.james.mailbox.exception.MailboxNotFoundException;
import org.apache.james.mailbox.model.MailboxId;

public class MailboxUtils {
    private final MailboxManager mailboxManager;

    @Inject
    @VisibleForTesting
    public MailboxUtils(MailboxManager mailboxManager) {
        this.mailboxManager = mailboxManager;
    }

    public boolean hasChildren(MailboxId mailboxId, MailboxSession mailboxSession) throws MailboxException {
        return this.getMailboxFromId(mailboxId, mailboxSession).map(Throwing.function(MessageManager::getMailboxPath).sneakyThrow()).map(Throwing.function(path -> this.mailboxManager.hasChildren(path, mailboxSession))).orElse(false);
    }

    private Optional<MessageManager> getMailboxFromId(MailboxId mailboxId, MailboxSession mailboxSession) throws MailboxException {
        try {
            return Optional.of(this.mailboxManager.getMailbox(mailboxId, mailboxSession));
        }
        catch (MailboxNotFoundException e) {
            return Optional.empty();
        }
    }
}

