/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.confignode.procedure.impl.schema.table.view;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.Optional;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.schema.table.TableNodeStatus;
import org.apache.iotdb.commons.schema.table.TreeViewSchema;
import org.apache.iotdb.commons.schema.table.TsTable;
import org.apache.iotdb.confignode.consensus.request.write.table.view.PreCreateTableViewPlan;
import org.apache.iotdb.confignode.exception.DatabaseNotExistsException;
import org.apache.iotdb.confignode.persistence.schema.TreeDeviceViewFieldDetector;
import org.apache.iotdb.confignode.procedure.env.ConfigNodeProcedureEnv;
import org.apache.iotdb.confignode.procedure.exception.ProcedureException;
import org.apache.iotdb.confignode.procedure.impl.schema.SchemaUtils;
import org.apache.iotdb.confignode.procedure.impl.schema.table.CreateTableProcedure;
import org.apache.iotdb.confignode.procedure.state.schema.CreateTableState;
import org.apache.iotdb.confignode.procedure.store.ProcedureType;
import org.apache.iotdb.confignode.rpc.thrift.TDatabaseSchema;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.utils.Pair;
import org.apache.tsfile.utils.ReadWriteIOUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CreateTableViewProcedure
extends CreateTableProcedure {
    private static final Logger LOGGER = LoggerFactory.getLogger(CreateTableViewProcedure.class);
    private boolean replace;
    private TsTable oldView;
    private TableNodeStatus oldStatus;

    public CreateTableViewProcedure(boolean isGeneratedByPipe) {
        super(isGeneratedByPipe);
    }

    public CreateTableViewProcedure(String database, TsTable table, boolean replace, boolean isGeneratedByPipe) {
        super(database, table, isGeneratedByPipe);
        this.replace = replace;
    }

    @Override
    protected void checkTableExistence(ConfigNodeProcedureEnv env) {
        if (!this.replace) {
            super.checkTableExistence(env);
        } else {
            try {
                Optional<Pair<TsTable, TableNodeStatus>> oldTableAndStatus = env.getConfigManager().getClusterSchemaManager().getTableAndStatusIfExists(this.database, this.table.getTableName());
                if (oldTableAndStatus.isPresent()) {
                    if (!TreeViewSchema.isTreeViewTable((TsTable)((TsTable)oldTableAndStatus.get().getLeft()))) {
                        this.setFailure(new ProcedureException((Throwable)new IoTDBException(String.format("Table '%s.%s' already exists.", this.database, this.table.getTableName()), TSStatusCode.TABLE_ALREADY_EXISTS.getStatusCode())));
                        return;
                    }
                    this.oldView = (TsTable)oldTableAndStatus.get().getLeft();
                    this.oldStatus = (TableNodeStatus)oldTableAndStatus.get().getRight();
                    this.setNextState(CreateTableState.PRE_CREATE);
                } else {
                    TDatabaseSchema schema = env.getConfigManager().getClusterSchemaManager().getDatabaseSchemaByName(this.database);
                    if (!this.table.getPropValue("ttl").isPresent() && schema.isSetTTL() && schema.getTTL() != Long.MAX_VALUE) {
                        this.table.addProp("ttl", String.valueOf(schema.getTTL()));
                    }
                    this.setNextState(CreateTableState.PRE_CREATE);
                }
            }
            catch (MetadataException | DatabaseNotExistsException e) {
                this.setFailure(new ProcedureException(e));
            }
        }
        TSStatus status = new TreeDeviceViewFieldDetector(env.getConfigManager(), this.table, null).detectMissingFieldTypes();
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    @Override
    protected void preCreateTable(ConfigNodeProcedureEnv env) {
        TSStatus status = SchemaUtils.executeInConsensusLayer(new PreCreateTableViewPlan(this.database, this.table, TableNodeStatus.PRE_CREATE), env, LOGGER);
        if (status.getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            this.setNextState(CreateTableState.PRE_RELEASE);
        } else {
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    @Override
    protected void rollbackCreate(ConfigNodeProcedureEnv env) {
        if (Objects.isNull(this.oldView)) {
            super.rollbackCreate(env);
            return;
        }
        TSStatus status = SchemaUtils.executeInConsensusLayer(new PreCreateTableViewPlan(this.database, this.oldView, this.oldStatus), env, LOGGER);
        if (status.getCode() != TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
            LOGGER.warn("Failed to rollback table creation {}.{}", (Object)this.database, (Object)this.table.getTableName());
            this.setFailure(new ProcedureException((Throwable)new IoTDBException(status)));
        }
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeShort(this.isGeneratedByPipe ? ProcedureType.PIPE_ENRICHED_CREATE_TABLE_VIEW_PROCEDURE.getTypeCode() : ProcedureType.CREATE_TABLE_VIEW_PROCEDURE.getTypeCode());
        this.innerSerialize(stream);
        ReadWriteIOUtils.write((Boolean)this.replace, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)Objects.nonNull(this.oldView), (OutputStream)stream);
        if (Objects.nonNull(this.oldView)) {
            this.oldView.serialize((OutputStream)stream);
        }
        ReadWriteIOUtils.write((Boolean)Objects.nonNull(this.oldStatus), (OutputStream)stream);
        if (Objects.nonNull(this.oldStatus)) {
            this.oldStatus.serialize((OutputStream)stream);
        }
    }

    @Override
    public void deserialize(ByteBuffer byteBuffer) {
        super.deserialize(byteBuffer);
        this.replace = ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer);
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.oldView = TsTable.deserialize((ByteBuffer)byteBuffer);
        }
        if (ReadWriteIOUtils.readBool((ByteBuffer)byteBuffer)) {
            this.oldStatus = TableNodeStatus.deserialize((ByteBuffer)byteBuffer);
        }
    }

    @Override
    public boolean equals(Object o) {
        return super.equals(o) && this.replace == ((CreateTableViewProcedure)o).replace && Objects.equals(this.oldView, ((CreateTableViewProcedure)o).oldView) && Objects.equals(this.oldStatus, ((CreateTableViewProcedure)o).oldStatus);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.replace, this.oldView, this.oldStatus);
    }
}

