/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.library.anomaly;

import org.apache.iotdb.library.util.Util;
import org.apache.iotdb.udf.api.UDTF;
import org.apache.iotdb.udf.api.access.RowWindow;
import org.apache.iotdb.udf.api.collector.PointCollector;
import org.apache.iotdb.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.udf.api.customizer.strategy.SlidingSizeWindowAccessStrategy;
import org.apache.iotdb.udf.api.exception.UDFException;
import org.apache.iotdb.udf.api.type.Type;

public class UDTFLOF
implements UDTF {
    private int multipleK;
    private int dim;
    private static final String DEFAULT_METHOD = "default";
    private String method = "default";
    private int window;

    int partition(Double[][] a, int left, int right) {
        Double key = a[left][1];
        Double key2 = a[left][0];
        while (left < right) {
            while (left < right && a[right][1] >= key) {
                --right;
            }
            if (left < right) {
                a[left][0] = a[right][0];
                a[left][1] = a[right][1];
            }
            while (left < right && a[left][1] <= key) {
                ++left;
            }
            if (left >= right) continue;
            a[right][0] = a[left][0];
            a[right][1] = a[left][1];
        }
        a[left][0] = key2;
        a[left][1] = key;
        return left;
    }

    Double findKthNum(Double[][] a, int left, int right, int k) {
        int index = this.partition(a, left, right);
        if (index + 1 == k) {
            return a[index][0];
        }
        if (index + 1 < k) {
            return this.findKthNum(a, index + 1, right, k);
        }
        return this.findKthNum(a, left, index - 1, k);
    }

    public double getLOF(Double[][] knn, Double[] x, int length) {
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            Double[] o = knn[i];
            sum += this.getLocDens(knn, o, length) / this.getLocDens(knn, x, length);
        }
        return sum / (double)this.multipleK;
    }

    public double getLocDens(Double[][] knn, Double[] x, int length) {
        Double[] nnk = this.findKthPoint(knn, x, length);
        double sum = 0.0;
        for (int i = 0; i < length; ++i) {
            Double[] o = knn[i];
            sum += this.reachDist(o, x, nnk);
        }
        return sum / (double)this.multipleK;
    }

    public Double[] findKthPoint(Double[][] knn, Double[] x, int length) {
        Double[][] d = new Double[length][2];
        for (int i = 0; i < length; ++i) {
            d[i][0] = i;
            d[i][1] = this.dist(knn[i], x);
        }
        int index = (int)this.findKthNum(d, 0, length - 1, this.multipleK + 1).doubleValue();
        return knn[index];
    }

    public double reachDist(Double[] o, Double[] x, Double[] nnk) {
        return Math.max(this.dist(o, x), this.dist(nnk, x));
    }

    private double dist(Double[] nnk, Double[] x) {
        double sum = 0.0;
        for (int i = 0; i < nnk.length; ++i) {
            sum += (nnk[i] - x[i]) * (nnk[i] - x[i]);
        }
        return Math.sqrt(sum);
    }

    @Override
    public void validate(UDFParameterValidator validator) throws Exception {
        validator.validateInputSeriesDataType(0, Type.INT32, Type.INT64, Type.FLOAT, Type.DOUBLE);
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) throws Exception {
        configurations.setAccessStrategy(new SlidingSizeWindowAccessStrategy(parameters.getIntOrDefault("window", 10000))).setOutputDataType(Type.DOUBLE);
        this.multipleK = parameters.getIntOrDefault("k", 3);
        this.dim = parameters.getChildExpressionsSize();
        this.method = parameters.getStringOrDefault("method", DEFAULT_METHOD);
        this.window = parameters.getIntOrDefault("window", 5);
    }

    @Override
    public void transform(RowWindow rowWindow, PointCollector collector) throws Exception {
        block16: {
            int size;
            block15: {
                if (!this.method.equals(DEFAULT_METHOD)) break block15;
                int size2 = rowWindow.windowSize();
                Double[][] knn = new Double[size2][this.dim];
                long[] timestamp = new long[size2];
                int i = 0;
                for (int row = 0; row < rowWindow.windowSize(); ++row) {
                    timestamp[i] = rowWindow.getRow(row).getTime();
                    for (int j = 0; j < this.dim; ++j) {
                        if (rowWindow.getRow(row).isNull(j)) {
                            --i;
                            --size2;
                            break;
                        }
                        knn[i][j] = Util.getValueAsDouble(rowWindow.getRow(i), j);
                    }
                    ++i;
                }
                if (size2 <= this.multipleK) break block16;
                double[] lof = new double[size2];
                for (int m4 = 0; m4 < size2; ++m4) {
                    try {
                        lof[m4] = this.getLOF(knn, knn[m4], size2);
                        collector.putDouble(timestamp[m4], lof[m4]);
                        continue;
                    }
                    catch (Exception e) {
                        throw new UDFException("Fail to get LOF " + m4, e);
                    }
                }
                break block16;
            }
            if (this.method.equals("series") && (size = rowWindow.windowSize() - this.window + 1) > 0) {
                Double[][] knn = new Double[size][this.window];
                long[] timestamp = new long[rowWindow.windowSize()];
                int i = 0;
                for (int row = 0; row < rowWindow.windowSize(); ++row) {
                    timestamp[i] = rowWindow.getRow(row).getTime();
                    if (!rowWindow.getRow(row).isNull(0)) {
                        double temp = Util.getValueAsDouble(rowWindow.getRow(row), 0);
                        for (int p = 0; p < this.window && i - p >= 0; ++p) {
                            if (i - p >= size) continue;
                            knn[i - p][p] = temp;
                        }
                    } else {
                        --i;
                        --size;
                    }
                    ++i;
                }
                if (size > this.multipleK) {
                    double[] lof = new double[size];
                    for (int m5 = 0; m5 < size; ++m5) {
                        try {
                            lof[m5] = this.getLOF(knn, knn[m5], size);
                            collector.putDouble(timestamp[m5], lof[m5]);
                            continue;
                        }
                        catch (Exception e) {
                            throw new UDFException("Fail to get LOF " + m5, e);
                        }
                    }
                }
            }
        }
    }

    @Override
    public void terminate(PointCollector collector) throws Exception {
    }
}

