/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.milo.opcua.stack.core.types.structured;

import org.eclipse.milo.opcua.stack.core.serialization.SerializationContext;
import org.eclipse.milo.opcua.stack.core.serialization.UaDecoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaEncoder;
import org.eclipse.milo.opcua.stack.core.serialization.UaRequestMessage;
import org.eclipse.milo.opcua.stack.core.serialization.codecs.GenericDataTypeCodec;
import org.eclipse.milo.opcua.stack.core.types.builtin.ExpandedNodeId;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UByte;
import org.eclipse.milo.opcua.stack.core.types.builtin.unsigned.UInteger;
import org.eclipse.milo.opcua.stack.core.types.structured.RequestHeader;
import org.eclipse.milo.opcua.stack.core.types.structured.Structure;

public class CreateSubscriptionRequest
extends Structure
implements UaRequestMessage {
    public static final ExpandedNodeId TYPE_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=785");
    public static final ExpandedNodeId BINARY_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=787");
    public static final ExpandedNodeId XML_ENCODING_ID = ExpandedNodeId.parse("nsu=http://opcfoundation.org/UA/;i=786");
    private final RequestHeader requestHeader;
    private final Double requestedPublishingInterval;
    private final UInteger requestedLifetimeCount;
    private final UInteger requestedMaxKeepAliveCount;
    private final UInteger maxNotificationsPerPublish;
    private final Boolean publishingEnabled;
    private final UByte priority;

    public CreateSubscriptionRequest(RequestHeader requestHeader, Double requestedPublishingInterval, UInteger requestedLifetimeCount, UInteger requestedMaxKeepAliveCount, UInteger maxNotificationsPerPublish, Boolean publishingEnabled, UByte priority) {
        this.requestHeader = requestHeader;
        this.requestedPublishingInterval = requestedPublishingInterval;
        this.requestedLifetimeCount = requestedLifetimeCount;
        this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = maxNotificationsPerPublish;
        this.publishingEnabled = publishingEnabled;
        this.priority = priority;
    }

    @Override
    public ExpandedNodeId getTypeId() {
        return TYPE_ID;
    }

    @Override
    public ExpandedNodeId getBinaryEncodingId() {
        return BINARY_ENCODING_ID;
    }

    @Override
    public ExpandedNodeId getXmlEncodingId() {
        return XML_ENCODING_ID;
    }

    @Override
    public RequestHeader getRequestHeader() {
        return this.requestHeader;
    }

    public Double getRequestedPublishingInterval() {
        return this.requestedPublishingInterval;
    }

    public UInteger getRequestedLifetimeCount() {
        return this.requestedLifetimeCount;
    }

    public UInteger getRequestedMaxKeepAliveCount() {
        return this.requestedMaxKeepAliveCount;
    }

    public UInteger getMaxNotificationsPerPublish() {
        return this.maxNotificationsPerPublish;
    }

    public Boolean getPublishingEnabled() {
        return this.publishingEnabled;
    }

    public UByte getPriority() {
        return this.priority;
    }

    protected CreateSubscriptionRequest(CreateSubscriptionRequestBuilder<?, ?> b) {
        super(b);
        this.requestHeader = ((CreateSubscriptionRequestBuilder)b).requestHeader;
        this.requestedPublishingInterval = ((CreateSubscriptionRequestBuilder)b).requestedPublishingInterval;
        this.requestedLifetimeCount = ((CreateSubscriptionRequestBuilder)b).requestedLifetimeCount;
        this.requestedMaxKeepAliveCount = ((CreateSubscriptionRequestBuilder)b).requestedMaxKeepAliveCount;
        this.maxNotificationsPerPublish = ((CreateSubscriptionRequestBuilder)b).maxNotificationsPerPublish;
        this.publishingEnabled = ((CreateSubscriptionRequestBuilder)b).publishingEnabled;
        this.priority = ((CreateSubscriptionRequestBuilder)b).priority;
    }

    public static CreateSubscriptionRequestBuilder<?, ?> builder() {
        return new CreateSubscriptionRequestBuilderImpl();
    }

    public CreateSubscriptionRequestBuilder<?, ?> toBuilder() {
        return new CreateSubscriptionRequestBuilderImpl().$fillValuesFrom(this);
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CreateSubscriptionRequest)) {
            return false;
        }
        CreateSubscriptionRequest other = (CreateSubscriptionRequest)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Double this$requestedPublishingInterval = this.getRequestedPublishingInterval();
        Double other$requestedPublishingInterval = other.getRequestedPublishingInterval();
        if (this$requestedPublishingInterval == null ? other$requestedPublishingInterval != null : !((Object)this$requestedPublishingInterval).equals(other$requestedPublishingInterval)) {
            return false;
        }
        Boolean this$publishingEnabled = this.getPublishingEnabled();
        Boolean other$publishingEnabled = other.getPublishingEnabled();
        if (this$publishingEnabled == null ? other$publishingEnabled != null : !((Object)this$publishingEnabled).equals(other$publishingEnabled)) {
            return false;
        }
        RequestHeader this$requestHeader = this.getRequestHeader();
        RequestHeader other$requestHeader = other.getRequestHeader();
        if (this$requestHeader == null ? other$requestHeader != null : !((Object)this$requestHeader).equals(other$requestHeader)) {
            return false;
        }
        UInteger this$requestedLifetimeCount = this.getRequestedLifetimeCount();
        UInteger other$requestedLifetimeCount = other.getRequestedLifetimeCount();
        if (this$requestedLifetimeCount == null ? other$requestedLifetimeCount != null : !((Object)this$requestedLifetimeCount).equals(other$requestedLifetimeCount)) {
            return false;
        }
        UInteger this$requestedMaxKeepAliveCount = this.getRequestedMaxKeepAliveCount();
        UInteger other$requestedMaxKeepAliveCount = other.getRequestedMaxKeepAliveCount();
        if (this$requestedMaxKeepAliveCount == null ? other$requestedMaxKeepAliveCount != null : !((Object)this$requestedMaxKeepAliveCount).equals(other$requestedMaxKeepAliveCount)) {
            return false;
        }
        UInteger this$maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        UInteger other$maxNotificationsPerPublish = other.getMaxNotificationsPerPublish();
        if (this$maxNotificationsPerPublish == null ? other$maxNotificationsPerPublish != null : !((Object)this$maxNotificationsPerPublish).equals(other$maxNotificationsPerPublish)) {
            return false;
        }
        UByte this$priority = this.getPriority();
        UByte other$priority = other.getPriority();
        return !(this$priority == null ? other$priority != null : !((Object)this$priority).equals(other$priority));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CreateSubscriptionRequest;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Double $requestedPublishingInterval = this.getRequestedPublishingInterval();
        result = result * 59 + ($requestedPublishingInterval == null ? 43 : ((Object)$requestedPublishingInterval).hashCode());
        Boolean $publishingEnabled = this.getPublishingEnabled();
        result = result * 59 + ($publishingEnabled == null ? 43 : ((Object)$publishingEnabled).hashCode());
        RequestHeader $requestHeader = this.getRequestHeader();
        result = result * 59 + ($requestHeader == null ? 43 : ((Object)$requestHeader).hashCode());
        UInteger $requestedLifetimeCount = this.getRequestedLifetimeCount();
        result = result * 59 + ($requestedLifetimeCount == null ? 43 : ((Object)$requestedLifetimeCount).hashCode());
        UInteger $requestedMaxKeepAliveCount = this.getRequestedMaxKeepAliveCount();
        result = result * 59 + ($requestedMaxKeepAliveCount == null ? 43 : ((Object)$requestedMaxKeepAliveCount).hashCode());
        UInteger $maxNotificationsPerPublish = this.getMaxNotificationsPerPublish();
        result = result * 59 + ($maxNotificationsPerPublish == null ? 43 : ((Object)$maxNotificationsPerPublish).hashCode());
        UByte $priority = this.getPriority();
        result = result * 59 + ($priority == null ? 43 : ((Object)$priority).hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "CreateSubscriptionRequest(requestHeader=" + this.getRequestHeader() + ", requestedPublishingInterval=" + this.getRequestedPublishingInterval() + ", requestedLifetimeCount=" + this.getRequestedLifetimeCount() + ", requestedMaxKeepAliveCount=" + this.getRequestedMaxKeepAliveCount() + ", maxNotificationsPerPublish=" + this.getMaxNotificationsPerPublish() + ", publishingEnabled=" + this.getPublishingEnabled() + ", priority=" + this.getPriority() + ")";
    }

    private static final class CreateSubscriptionRequestBuilderImpl
    extends CreateSubscriptionRequestBuilder<CreateSubscriptionRequest, CreateSubscriptionRequestBuilderImpl> {
        private CreateSubscriptionRequestBuilderImpl() {
        }

        @Override
        protected CreateSubscriptionRequestBuilderImpl self() {
            return this;
        }

        @Override
        public CreateSubscriptionRequest build() {
            return new CreateSubscriptionRequest(this);
        }
    }

    public static abstract class CreateSubscriptionRequestBuilder<C extends CreateSubscriptionRequest, B extends CreateSubscriptionRequestBuilder<C, B>>
    extends Structure.StructureBuilder<C, B> {
        private RequestHeader requestHeader;
        private Double requestedPublishingInterval;
        private UInteger requestedLifetimeCount;
        private UInteger requestedMaxKeepAliveCount;
        private UInteger maxNotificationsPerPublish;
        private Boolean publishingEnabled;
        private UByte priority;

        @Override
        protected B $fillValuesFrom(C instance) {
            super.$fillValuesFrom(instance);
            CreateSubscriptionRequestBuilder.$fillValuesFromInstanceIntoBuilder(instance, this);
            return (B)this.self();
        }

        private static void $fillValuesFromInstanceIntoBuilder(CreateSubscriptionRequest instance, CreateSubscriptionRequestBuilder<?, ?> b) {
            b.requestHeader(instance.requestHeader);
            b.requestedPublishingInterval(instance.requestedPublishingInterval);
            b.requestedLifetimeCount(instance.requestedLifetimeCount);
            b.requestedMaxKeepAliveCount(instance.requestedMaxKeepAliveCount);
            b.maxNotificationsPerPublish(instance.maxNotificationsPerPublish);
            b.publishingEnabled(instance.publishingEnabled);
            b.priority(instance.priority);
        }

        @Override
        protected abstract B self();

        @Override
        public abstract C build();

        public B requestHeader(RequestHeader requestHeader) {
            this.requestHeader = requestHeader;
            return (B)this.self();
        }

        public B requestedPublishingInterval(Double requestedPublishingInterval) {
            this.requestedPublishingInterval = requestedPublishingInterval;
            return (B)this.self();
        }

        public B requestedLifetimeCount(UInteger requestedLifetimeCount) {
            this.requestedLifetimeCount = requestedLifetimeCount;
            return (B)this.self();
        }

        public B requestedMaxKeepAliveCount(UInteger requestedMaxKeepAliveCount) {
            this.requestedMaxKeepAliveCount = requestedMaxKeepAliveCount;
            return (B)this.self();
        }

        public B maxNotificationsPerPublish(UInteger maxNotificationsPerPublish) {
            this.maxNotificationsPerPublish = maxNotificationsPerPublish;
            return (B)this.self();
        }

        public B publishingEnabled(Boolean publishingEnabled) {
            this.publishingEnabled = publishingEnabled;
            return (B)this.self();
        }

        public B priority(UByte priority) {
            this.priority = priority;
            return (B)this.self();
        }

        @Override
        public String toString() {
            return "CreateSubscriptionRequest.CreateSubscriptionRequestBuilder(super=" + super.toString() + ", requestHeader=" + this.requestHeader + ", requestedPublishingInterval=" + this.requestedPublishingInterval + ", requestedLifetimeCount=" + this.requestedLifetimeCount + ", requestedMaxKeepAliveCount=" + this.requestedMaxKeepAliveCount + ", maxNotificationsPerPublish=" + this.maxNotificationsPerPublish + ", publishingEnabled=" + this.publishingEnabled + ", priority=" + this.priority + ")";
        }
    }

    public static final class Codec
    extends GenericDataTypeCodec<CreateSubscriptionRequest> {
        @Override
        public Class<CreateSubscriptionRequest> getType() {
            return CreateSubscriptionRequest.class;
        }

        @Override
        public CreateSubscriptionRequest decode(SerializationContext context, UaDecoder decoder) {
            RequestHeader requestHeader = (RequestHeader)decoder.readStruct("RequestHeader", RequestHeader.TYPE_ID);
            Double requestedPublishingInterval = decoder.readDouble("RequestedPublishingInterval");
            UInteger requestedLifetimeCount = decoder.readUInt32("RequestedLifetimeCount");
            UInteger requestedMaxKeepAliveCount = decoder.readUInt32("RequestedMaxKeepAliveCount");
            UInteger maxNotificationsPerPublish = decoder.readUInt32("MaxNotificationsPerPublish");
            Boolean publishingEnabled = decoder.readBoolean("PublishingEnabled");
            UByte priority = decoder.readByte("Priority");
            return new CreateSubscriptionRequest(requestHeader, requestedPublishingInterval, requestedLifetimeCount, requestedMaxKeepAliveCount, maxNotificationsPerPublish, publishingEnabled, priority);
        }

        @Override
        public void encode(SerializationContext context, UaEncoder encoder, CreateSubscriptionRequest value) {
            encoder.writeStruct("RequestHeader", (Object)value.getRequestHeader(), RequestHeader.TYPE_ID);
            encoder.writeDouble("RequestedPublishingInterval", value.getRequestedPublishingInterval());
            encoder.writeUInt32("RequestedLifetimeCount", value.getRequestedLifetimeCount());
            encoder.writeUInt32("RequestedMaxKeepAliveCount", value.getRequestedMaxKeepAliveCount());
            encoder.writeUInt32("MaxNotificationsPerPublish", value.getMaxNotificationsPerPublish());
            encoder.writeBoolean("PublishingEnabled", value.getPublishingEnabled());
            encoder.writeByte("Priority", value.getPriority());
        }
    }
}

