/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.rule;

import org.apache.iotdb.db.queryengine.plan.relational.planner.iterative.Rule;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.DeviceTableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.LimitNode;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.Patterns;
import org.apache.iotdb.db.queryengine.plan.relational.planner.node.TableScanNode;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Capture;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Captures;
import org.apache.iotdb.db.queryengine.plan.relational.utils.matching.Pattern;

public class EliminateLimitWithTableScan
implements Rule<LimitNode> {
    private static final Capture<TableScanNode> CHILD = Capture.newCapture();
    private static final Pattern<LimitNode> PATTERN = Patterns.limit().with(Patterns.source().matching(Patterns.tableScan().capturedAs(CHILD)));

    @Override
    public Pattern<LimitNode> getPattern() {
        return PATTERN;
    }

    @Override
    public Rule.Result apply(LimitNode parent, Captures captures, Rule.Context context) {
        TableScanNode tableScanNode = captures.get(CHILD);
        if (tableScanNode instanceof DeviceTableScanNode && ((DeviceTableScanNode)tableScanNode).isPushLimitToEachDevice()) {
            return Rule.Result.empty();
        }
        if (parent.getCount() == tableScanNode.getPushDownLimit()) {
            return Rule.Result.ofPlanNode(tableScanNode);
        }
        return Rule.Result.empty();
    }
}

