/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.commons.consensus.index;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.LongStream;
import javax.annotation.Nonnull;
import org.apache.iotdb.commons.consensus.index.ProgressIndexType;
import org.apache.iotdb.commons.consensus.index.impl.HybridProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.MinimumProgressIndex;
import org.apache.iotdb.commons.consensus.index.impl.StateProgressIndex;
import org.apache.tsfile.utils.Accountable;
import org.apache.tsfile.utils.RamUsageEstimator;

public abstract class ProgressIndex
implements Accountable {
    protected static final long LOCK_SIZE = RamUsageEstimator.shallowSizeOfInstance(ReentrantReadWriteLock.class) + RamUsageEstimator.shallowSizeOfInstance(ReentrantReadWriteLock.ReadLock.class) + RamUsageEstimator.shallowSizeOfInstance(ReentrantReadWriteLock.WriteLock.class) + ((long)RamUsageEstimator.NUM_BYTES_OBJECT_HEADER << 1) + 64L;

    public abstract void serialize(ByteBuffer var1);

    public abstract void serialize(OutputStream var1) throws IOException;

    public abstract boolean isAfter(@Nonnull ProgressIndex var1);

    public abstract boolean equals(ProgressIndex var1);

    public boolean equals(Object obj) {
        if (obj == null) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof ProgressIndex)) {
            return false;
        }
        return this.equals((ProgressIndex)obj);
    }

    public int hashCode() {
        return super.hashCode();
    }

    public abstract ProgressIndex updateToMinimumEqualOrIsAfterProgressIndex(ProgressIndex var1);

    public abstract ProgressIndexType getType();

    public abstract TotalOrderSumTuple getTotalOrderSumTuple();

    public final int topologicalCompareTo(@Nonnull ProgressIndex progressIndex) {
        return this.getTotalOrderSumTuple().compareTo(progressIndex.getTotalOrderSumTuple());
    }

    protected static ProgressIndex blendProgressIndex(ProgressIndex progressIndex1, ProgressIndex progressIndex2) {
        if (progressIndex1 == null && progressIndex2 == null) {
            return MinimumProgressIndex.INSTANCE;
        }
        if (progressIndex1 == null || progressIndex1 instanceof MinimumProgressIndex) {
            return progressIndex2 == null ? MinimumProgressIndex.INSTANCE : progressIndex2;
        }
        if (progressIndex2 == null || progressIndex2 instanceof MinimumProgressIndex) {
            return progressIndex1;
        }
        return progressIndex1 instanceof StateProgressIndex ? progressIndex1.updateToMinimumEqualOrIsAfterProgressIndex(progressIndex2) : new HybridProgressIndex(progressIndex1).updateToMinimumEqualOrIsAfterProgressIndex(progressIndex2);
    }

    public static class TotalOrderSumTuple
    implements Comparable<TotalOrderSumTuple> {
        private final ImmutableList<Long> tuple;

        public TotalOrderSumTuple(Long ... args) {
            this.tuple = ImmutableList.copyOf((Object[])args);
        }

        public TotalOrderSumTuple(List<Long> list) {
            this.tuple = ImmutableList.copyOf(list);
        }

        @Override
        public int compareTo(TotalOrderSumTuple that) {
            if (that.tuple.size() != this.tuple.size()) {
                return this.tuple.size() - that.tuple.size();
            }
            for (int i = this.tuple.size() - 1; i >= 0; --i) {
                if (((Long)this.tuple.get(i)).equals(that.tuple.get(i))) continue;
                return (Long)this.tuple.get(i) < (Long)that.tuple.get(i) ? -1 : 1;
            }
            return 0;
        }

        public String toString() {
            return "TotalOrderSumTuple{tuple=" + this.tuple + '}';
        }

        public static TotalOrderSumTuple sum(List<TotalOrderSumTuple> tupleList) {
            if (tupleList == null || tupleList.size() == 0) {
                return new TotalOrderSumTuple(new Long[0]);
            }
            if (tupleList.size() == 1) {
                return tupleList.get(0);
            }
            List<Long> result = LongStream.range(0L, tupleList.stream().mapToInt(t -> t.tuple.size()).max().getAsInt()).map(o -> 0L).boxed().collect(Collectors.toList());
            tupleList.forEach(t -> IntStream.range(0, t.tuple.size()).forEach(i -> result.set(i, (Long)result.get(i) + (Long)t.tuple.get(i))));
            return new TotalOrderSumTuple(result);
        }
    }
}

