/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.plan.relational.sql.ast;

import com.google.common.collect.ImmutableList;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.AstVisitor;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Expression;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.Node;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.NodeLocation;
import org.apache.iotdb.db.queryengine.plan.relational.sql.ast.TableExpressionType;

public final class Columns
extends Expression {
    private final String pattern;

    public Columns(@Nonnull NodeLocation location, String pattern) {
        super(Objects.requireNonNull(location, "location is null"));
        this.pattern = pattern;
    }

    public String getPattern() {
        return this.pattern;
    }

    public boolean isColumnsAsterisk() {
        return this.pattern == null;
    }

    @Override
    public <R, C> R accept(AstVisitor<R, C> visitor, C context) {
        return visitor.visitColumns(this, context);
    }

    public List<Node> getChildren() {
        return ImmutableList.of();
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Columns columns = (Columns)o;
        return Objects.equals(columns.pattern, this.pattern);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.pattern);
    }

    @Override
    public boolean shallowEquals(Node other) {
        if (!Columns.sameClass(this, other)) {
            return false;
        }
        Columns otherColumns = (Columns)other;
        return Objects.equals(otherColumns.pattern, this.pattern);
    }

    @Override
    public TableExpressionType getExpressionType() {
        throw new UnsupportedOperationException("Columns should be expanded in Analyze stage");
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        throw new UnsupportedOperationException("Columns should be expanded in Analyze stage");
    }
}

