/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.queryengine.execution.fragment;

import java.time.ZoneId;
import java.time.format.DateTimeParseException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.IoTDBRuntimeException;
import org.apache.iotdb.commons.path.AlignedFullPath;
import org.apache.iotdb.commons.path.IFullPath;
import org.apache.iotdb.commons.utils.TestOnly;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.queryengine.common.DeviceContext;
import org.apache.iotdb.db.queryengine.common.FragmentInstanceId;
import org.apache.iotdb.db.queryengine.common.QueryId;
import org.apache.iotdb.db.queryengine.common.SessionInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.DataNodeQueryContext;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceFailureInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceInfo;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceState;
import org.apache.iotdb.db.queryengine.execution.fragment.FragmentInstanceStateMachine;
import org.apache.iotdb.db.queryengine.execution.fragment.QueryContext;
import org.apache.iotdb.db.queryengine.metric.DriverSchedulerMetricSet;
import org.apache.iotdb.db.queryengine.metric.QueryRelatedResourceMetricSet;
import org.apache.iotdb.db.queryengine.metric.SeriesScanCostMetricSet;
import org.apache.iotdb.db.queryengine.plan.planner.memory.MemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.planner.memory.ThreadSafeMemoryReservationManager;
import org.apache.iotdb.db.queryengine.plan.planner.plan.TimePredicate;
import org.apache.iotdb.db.storageengine.StorageEngine;
import org.apache.iotdb.db.storageengine.dataregion.DataRegion;
import org.apache.iotdb.db.storageengine.dataregion.IDataRegionForQuery;
import org.apache.iotdb.db.storageengine.dataregion.VirtualDataRegion;
import org.apache.iotdb.db.storageengine.dataregion.read.IQueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSource;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceForRegionScan;
import org.apache.iotdb.db.storageengine.dataregion.read.QueryDataSourceType;
import org.apache.iotdb.db.storageengine.dataregion.read.control.FileReaderManager;
import org.apache.iotdb.db.storageengine.dataregion.tsfile.TsFileResource;
import org.apache.iotdb.db.utils.ErrorHandlingUtils;
import org.apache.iotdb.db.utils.TimestampPrecisionUtils;
import org.apache.iotdb.db.utils.datastructure.TVList;
import org.apache.iotdb.mpp.rpc.thrift.TFetchFragmentInstanceStatisticsResp;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.tsfile.file.metadata.IDeviceID;
import org.apache.tsfile.read.filter.basic.Filter;
import org.apache.tsfile.read.filter.factory.FilterFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FragmentInstanceContext
extends QueryContext {
    private static final Logger LOGGER = LoggerFactory.getLogger(FragmentInstanceContext.class);
    private static final long END_TIME_INITIAL_VALUE = -1L;
    private static final long LONG_WAIT_DURATION = 5000000000L;
    private final FragmentInstanceId id;
    private final FragmentInstanceStateMachine stateMachine;
    private final MemoryReservationManager memoryReservationManager;
    protected IDataRegionForQuery dataRegion;
    private Filter globalTimeFilter;
    private List<IFullPath> sourcePaths;
    private Map<IDeviceID, DeviceContext> devicePathsToContext;
    protected IQueryDataSource sharedQueryDataSource;
    private Set<TsFileResource> closedFilePaths;
    private Set<TsFileResource> unClosedFilePaths;
    private boolean mayHaveTmpFile = false;
    private List<Long> timePartitions;
    private boolean ignoreNotExistsDevice = false;
    private QueryDataSourceType queryDataSourceType = QueryDataSourceType.SERIES_SCAN;
    private final AtomicLong startNanos = new AtomicLong();
    private final AtomicLong endNanos = new AtomicLong();
    private final AtomicReference<Long> executionStartTime = new AtomicReference();
    private final AtomicReference<Long> lastExecutionStartTime = new AtomicReference();
    private final AtomicReference<Long> executionEndTime = new AtomicReference();
    private CountDownLatch allDriversClosed;
    private SessionInfo sessionInfo;
    private final Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap;
    private DataNodeQueryContext dataNodeQueryContext;
    private TFetchFragmentInstanceStatisticsResp fragmentInstanceStatistics = null;
    private long initQueryDataSourceCost = 0L;
    private final AtomicLong readyQueueTime = new AtomicLong(0L);
    private final AtomicLong blockQueueTime = new AtomicLong(0L);
    private long unclosedSeqFileNum = 0L;
    private long unclosedUnseqFileNum = 0L;
    private long closedSeqFileNum = 0L;
    private long closedUnseqFileNum = 0L;

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter timeFilter) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo, dataRegion, timeFilter);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, TimePredicate globalTimePredicate, Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, sessionInfo, dataRegion, globalTimePredicate, dataNodeQueryContextMap);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    public static FragmentInstanceContext createFragmentInstanceContextForCompaction(long queryId) {
        return new FragmentInstanceContext(queryId, null, null, null);
    }

    public void setQueryDataSourceType(QueryDataSourceType queryDataSourceType) {
        this.queryDataSourceType = queryDataSourceType;
    }

    @TestOnly
    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, new SessionInfo(1L, "test", ZoneId.systemDefault()));
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    @TestOnly
    public static FragmentInstanceContext createFragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, MemoryReservationManager memoryReservationManager) {
        FragmentInstanceContext instanceContext = new FragmentInstanceContext(id, stateMachine, new SessionInfo(1L, "test", ZoneId.systemDefault()), memoryReservationManager);
        instanceContext.initialize();
        instanceContext.start();
        return instanceContext;
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, TimePredicate globalTimePredicate, Map<QueryId, DataNodeQueryContext> dataNodeQueryContextMap) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataRegion = dataRegion;
        this.globalTimeFilter = globalTimePredicate == null ? null : globalTimePredicate.convertPredicateToTimeFilter(sessionInfo.getZoneId(), TimestampPrecisionUtils.currPrecision);
        this.dataNodeQueryContextMap = dataNodeQueryContextMap;
        this.dataNodeQueryContext = dataNodeQueryContextMap.get(id.getQueryId());
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataNodeQueryContextMap = null;
        this.dataNodeQueryContext = null;
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, MemoryReservationManager memoryReservationManager) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataNodeQueryContextMap = null;
        this.dataNodeQueryContext = null;
        this.memoryReservationManager = memoryReservationManager;
    }

    private FragmentInstanceContext(FragmentInstanceId id, FragmentInstanceStateMachine stateMachine, SessionInfo sessionInfo, IDataRegionForQuery dataRegion, Filter globalTimeFilter) {
        this.id = id;
        this.stateMachine = stateMachine;
        this.executionEndTime.set(-1L);
        this.sessionInfo = sessionInfo;
        this.dataRegion = dataRegion;
        this.globalTimeFilter = globalTimeFilter;
        this.dataNodeQueryContextMap = null;
        this.memoryReservationManager = new ThreadSafeMemoryReservationManager(id.getQueryId(), this.getClass().getName());
    }

    @TestOnly
    public void setDataRegion(IDataRegionForQuery dataRegion) {
        this.dataRegion = dataRegion;
    }

    protected FragmentInstanceContext(long queryId, MemoryReservationManager memoryReservationManager, Filter timeFilter, DataRegion dataRegion) {
        this.queryId = queryId;
        this.id = null;
        this.stateMachine = null;
        this.dataNodeQueryContextMap = null;
        this.dataNodeQueryContext = null;
        this.dataRegion = dataRegion;
        this.globalTimeFilter = timeFilter;
        this.memoryReservationManager = memoryReservationManager;
    }

    public void start() {
        long now = System.currentTimeMillis();
        this.ignoreNotExistsDevice = !StorageEngine.getInstance().isReadyForNonReadWriteFunctions();
        this.executionStartTime.compareAndSet(null, now);
        this.startNanos.compareAndSet(0L, System.nanoTime());
        this.lastExecutionStartTime.set(now);
    }

    private void initialize() {
        this.stateMachine.addStateChangeListener(this::updateStatsIfDone);
    }

    private void updateStatsIfDone(FragmentInstanceState newState) {
        if (newState.isDone()) {
            long now = System.currentTimeMillis();
            this.executionStartTime.compareAndSet(null, now);
            this.startNanos.compareAndSet(0L, System.nanoTime());
            this.lastExecutionStartTime.compareAndSet(null, now);
            this.executionEndTime.compareAndSet(-1L, now);
            this.endNanos.compareAndSet(0L, System.nanoTime());
            this.releaseDataNodeQueryContext();
            this.sourcePaths = null;
        }
    }

    public FragmentInstanceId getId() {
        return this.id;
    }

    public void failed(Throwable cause) {
        this.stateMachine.failed(cause);
    }

    public String getFailedCause() {
        return this.stateMachine.getFailureCauses().stream().findFirst().map(Throwable::getMessage).orElse("");
    }

    public List<FragmentInstanceFailureInfo> getFailureInfoList() {
        return this.stateMachine.getFailureCauses().stream().map(FragmentInstanceFailureInfo::toFragmentInstanceFailureInfo).collect(Collectors.toList());
    }

    public void finished() {
        this.stateMachine.finished();
    }

    public void transitionToFlushing() {
        this.stateMachine.transitionToFlushing();
    }

    public void cancel() {
        this.stateMachine.cancel();
    }

    public void abort() {
        this.stateMachine.abort();
    }

    public long getEndTime() {
        return this.executionEndTime.get();
    }

    public boolean isEndTimeUpdate() {
        return this.executionEndTime.get() != -1L;
    }

    @Override
    public long getStartTime() {
        return this.executionStartTime.get();
    }

    public DataNodeQueryContext getDataNodeQueryContext() {
        return this.dataNodeQueryContext;
    }

    public void setDataNodeQueryContext(DataNodeQueryContext dataNodeQueryContext) {
        this.dataNodeQueryContext = dataNodeQueryContext;
    }

    public FragmentInstanceInfo getInstanceInfo() {
        FragmentInstanceState state = this.stateMachine.getState();
        long endTime = this.getEndTime();
        LinkedBlockingQueue<Throwable> failures = this.stateMachine.getFailureCauses();
        String failureCause = "";
        ArrayList<FragmentInstanceFailureInfo> failureInfoList = new ArrayList<FragmentInstanceFailureInfo>();
        TSStatus status = null;
        for (Throwable t : failures) {
            Throwable failure = ErrorHandlingUtils.getRootCause(t);
            if (failureCause.isEmpty() && failure.getMessage() != null) {
                failureCause = failure.getMessage();
            }
            failureInfoList.add(FragmentInstanceFailureInfo.toFragmentInstanceFailureInfo(failure));
            if (failure instanceof IoTDBException) {
                status = new TSStatus(((IoTDBException)failure).getErrorCode());
                status.setMessage(failure.getMessage());
                continue;
            }
            if (failure instanceof IoTDBRuntimeException) {
                status = new TSStatus(((IoTDBRuntimeException)failure).getErrorCode());
                status.setMessage(failure.getMessage());
                continue;
            }
            if (failure instanceof DateTimeParseException) {
                status = new TSStatus(TSStatusCode.DATE_OUT_OF_RANGE.getStatusCode());
                status.setMessage(failure.getMessage());
                continue;
            }
            LOGGER.warn("[Unknown exception]: ", failure);
        }
        if (status == null) {
            return new FragmentInstanceInfo(state, endTime, failureCause, failureInfoList);
        }
        return new FragmentInstanceInfo(state, endTime, failureCause, failureInfoList, status);
    }

    public FragmentInstanceStateMachine getStateMachine() {
        return this.stateMachine;
    }

    public SessionInfo getSessionInfo() {
        return this.sessionInfo;
    }

    public Optional<Throwable> getFailureCause() {
        return Optional.ofNullable(this.stateMachine.getFailureCauses().stream().filter(e -> e instanceof IoTDBException || e instanceof IoTDBRuntimeException).findFirst().orElse(this.stateMachine.getFailureCauses().peek()));
    }

    public Filter getGlobalTimeFilter() {
        return this.globalTimeFilter;
    }

    public void setTimeFilterForTableModel(Filter timeFilter) {
        this.globalTimeFilter = this.globalTimeFilter == null ? timeFilter : FilterFactory.or((Filter)this.globalTimeFilter, (Filter)timeFilter);
    }

    public IDataRegionForQuery getDataRegion() {
        return this.dataRegion;
    }

    public void setSourcePaths(List<IFullPath> sourcePaths) {
        this.sourcePaths = sourcePaths;
    }

    public void setDevicePathsToContext(Map<IDeviceID, DeviceContext> devicePathsToContext) {
        this.devicePathsToContext = devicePathsToContext;
    }

    public MemoryReservationManager getMemoryReservationContext() {
        return this.memoryReservationManager;
    }

    public void releaseMemoryReservationManager() {
        this.memoryReservationManager.releaseAllReservedMemory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initQueryDataSource(List<IFullPath> sourcePaths) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (sourcePaths == null || sourcePaths.isEmpty()) {
            this.sharedQueryDataSource = VirtualDataRegion.EMPTY_QUERY_DATA_SOURCE;
            return;
        }
        IDeviceID singleDeviceId = null;
        if (sourcePaths.size() == 1) {
            singleDeviceId = sourcePaths.get(0).getDeviceId();
        } else {
            HashSet<IDeviceID> selectedDeviceIdSet = new HashSet<IDeviceID>();
            for (IFullPath sourcePath : sourcePaths) {
                if (sourcePath instanceof AlignedFullPath) {
                    singleDeviceId = null;
                    break;
                }
                singleDeviceId = sourcePath.getDeviceId();
                selectedDeviceIdSet.add(singleDeviceId);
                if (selectedDeviceIdSet.size() <= 1) continue;
                singleDeviceId = null;
                break;
            }
        }
        this.dataRegion.readLock();
        try {
            this.sharedQueryDataSource = this.dataRegion.query(sourcePaths, singleDeviceId, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForQuery((QueryDataSource)this.sharedQueryDataSource);
                ((QueryDataSource)this.sharedQueryDataSource).setSingleDevice(singleDeviceId != null);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRegionScanQueryDataSource(Map<IDeviceID, DeviceContext> devicePathsToContext) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (devicePathsToContext == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            this.sharedQueryDataSource = this.dataRegion.queryForDeviceRegionScan(devicePathsToContext, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForRegionQuery((QueryDataSourceForRegionScan)this.sharedQueryDataSource);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initRegionScanQueryDataSource(List<IFullPath> pathList) throws QueryProcessException {
        long startTime = System.nanoTime();
        if (pathList == null) {
            return;
        }
        this.dataRegion.readLock();
        try {
            this.sharedQueryDataSource = this.dataRegion.queryForSeriesRegionScan(pathList, this, this.globalTimeFilter != null ? this.globalTimeFilter.copy() : null, this.timePartitions);
            if (this.sharedQueryDataSource != null) {
                this.closedFilePaths = new HashSet<TsFileResource>();
                this.unClosedFilePaths = new HashSet<TsFileResource>();
                this.addUsedFilesForRegionQuery((QueryDataSourceForRegionScan)this.sharedQueryDataSource);
            }
        }
        finally {
            this.setInitQueryDataSourceCost(System.nanoTime() - startTime);
            this.dataRegion.readUnlock();
        }
    }

    public synchronized IQueryDataSource getSharedQueryDataSource() throws QueryProcessException {
        if (this.sharedQueryDataSource == null) {
            switch (this.queryDataSourceType) {
                case SERIES_SCAN: {
                    this.initQueryDataSource(this.sourcePaths);
                    this.sourcePaths = null;
                    break;
                }
                case DEVICE_REGION_SCAN: {
                    this.initRegionScanQueryDataSource(this.devicePathsToContext);
                    this.devicePathsToContext = null;
                    break;
                }
                case TIME_SERIES_REGION_SCAN: {
                    this.initRegionScanQueryDataSource(this.sourcePaths);
                    this.sourcePaths = null;
                    break;
                }
                default: {
                    throw new QueryProcessException("Unsupported query data source type: " + (Object)((Object)this.queryDataSourceType));
                }
            }
        }
        return this.sharedQueryDataSource;
    }

    private boolean processTsFileResource(TsFileResource tsFileResource, boolean isClosed) {
        this.addFilePathToMap(tsFileResource, isClosed);
        if (tsFileResource.isDeleted()) {
            Set<TsFileResource> pathSet;
            Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
            if (pathSet.remove(tsFileResource)) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFileResource, isClosed);
            }
            return true;
        }
        return false;
    }

    private void addUsedFilesForQuery(QueryDataSource dataSource) {
        dataSource.getSeqResources().removeIf(tsFileResource -> this.processTsFileResource((TsFileResource)tsFileResource, tsFileResource.isClosed()));
        this.unclosedSeqFileNum = this.unClosedFilePaths.size();
        this.closedSeqFileNum = this.closedFilePaths.size();
        dataSource.getUnseqResources().removeIf(tsFileResource -> this.processTsFileResource((TsFileResource)tsFileResource, tsFileResource.isClosed()));
        this.unclosedUnseqFileNum = (long)this.unClosedFilePaths.size() - this.unclosedSeqFileNum;
        this.closedUnseqFileNum = (long)this.closedFilePaths.size() - this.closedSeqFileNum;
    }

    private void addUsedFilesForRegionQuery(QueryDataSourceForRegionScan dataSource) {
        dataSource.getSeqFileScanHandles().removeIf(fileScanHandle -> this.processTsFileResource(fileScanHandle.getTsResource(), fileScanHandle.isClosed()));
        this.unclosedSeqFileNum = this.unClosedFilePaths.size();
        this.closedSeqFileNum = this.closedFilePaths.size();
        dataSource.getUnseqFileScanHandles().removeIf(fileScanHandle -> this.processTsFileResource(fileScanHandle.getTsResource(), fileScanHandle.isClosed()));
        this.unclosedUnseqFileNum = (long)this.unClosedFilePaths.size() - this.unclosedSeqFileNum;
        this.closedUnseqFileNum = (long)this.closedFilePaths.size() - this.closedSeqFileNum;
    }

    private void addFilePathToMap(TsFileResource tsFile, boolean isClosed) {
        Set<TsFileResource> pathSet;
        Set<TsFileResource> set = pathSet = isClosed ? this.closedFilePaths : this.unClosedFilePaths;
        if (!pathSet.contains(tsFile)) {
            pathSet.add(tsFile);
            FileReaderManager.getInstance().increaseFileReaderReference(tsFile, isClosed);
        }
    }

    public void initializeNumOfDrivers(int numOfDrivers) {
        this.allDriversClosed = new CountDownLatch(numOfDrivers);
    }

    public void decrementNumOfUnClosedDriver() {
        this.allDriversClosed.countDown();
    }

    public void releaseResourceWhenAllDriversAreClosed() {
        long startTime = System.nanoTime();
        while (true) {
            try {
                this.allDriversClosed.await();
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                LOGGER.warn("Interrupted when await on allDriversClosed, FragmentInstance Id is {}", (Object)this.getId());
                continue;
            }
            break;
        }
        long duration = System.nanoTime() - startTime;
        if (duration >= 5000000000L) {
            LOGGER.warn("Wait {}ms for all Drivers closed", (Object)(duration / 1000000L));
        }
        this.releaseResource();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void releaseTVListOwnedByQuery() {
        for (TVList tvList : this.tvListSet) {
            tvList.lockQueryList();
            Set<QueryContext> queryContextSet = tvList.getQueryContextSet();
            try {
                queryContextSet.remove(this);
                if (tvList.getOwnerQuery() != this) continue;
                if (queryContextSet.isEmpty()) {
                    LOGGER.debug("TVList {} is released by the query, FragmentInstance Id is {}", (Object)tvList, (Object)this.getId());
                    this.memoryReservationManager.releaseMemoryCumulatively(tvList.calculateRamSize());
                    tvList.clear();
                    continue;
                }
                FragmentInstanceContext queryContext = (FragmentInstanceContext)queryContextSet.iterator().next();
                LOGGER.debug("TVList {} is now owned by another query, FragmentInstance Id is {}", (Object)tvList, (Object)queryContext.getId());
                tvList.setOwnerQuery(queryContext);
            }
            finally {
                tvList.unlockQueryList();
            }
        }
    }

    public synchronized void releaseResource() {
        if (this.closedFilePaths != null) {
            for (TsFileResource tsFile : this.closedFilePaths) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, true);
            }
            this.closedFilePaths = null;
        }
        if (this.unClosedFilePaths != null) {
            for (TsFileResource tsFile : this.unClosedFilePaths) {
                FileReaderManager.getInstance().decreaseFileReaderReference(tsFile, false);
            }
            this.unClosedFilePaths = null;
        }
        this.releaseTVListOwnedByQuery();
        this.dataRegion = null;
        this.globalTimeFilter = null;
        this.sharedQueryDataSource = null;
        long durationTime = System.currentTimeMillis() - this.executionStartTime.get();
        DriverSchedulerMetricSet.getInstance().recordTaskQueueTime("block_queued_time", this.blockQueueTime.get());
        DriverSchedulerMetricSet.getInstance().recordTaskQueueTime("ready_queued_time", this.readyQueueTime.get());
        QueryRelatedResourceMetricSet.getInstance().updateFragmentInstanceTime(durationTime);
        SeriesScanCostMetricSet.getInstance().recordBloomFilterMetrics(this.getQueryStatistics().getLoadBloomFilterFromCacheCount().get(), this.getQueryStatistics().getLoadBloomFilterFromDiskCount().get(), this.getQueryStatistics().getLoadBloomFilterActualIOSize().get(), this.getQueryStatistics().getLoadBloomFilterTime().get());
        SeriesScanCostMetricSet.getInstance().recordNonAlignedTimeSeriesMetadataCount(this.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqCount().get());
        SeriesScanCostMetricSet.getInstance().recordNonAlignedTimeSeriesMetadataTime(this.getQueryStatistics().getLoadTimeSeriesMetadataDiskSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataDiskUnSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataMemUnSeqTime().get());
        SeriesScanCostMetricSet.getInstance().recordAlignedTimeSeriesMetadataCount(this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqCount().get());
        SeriesScanCostMetricSet.getInstance().recordAlignedTimeSeriesMetadataTime(this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedDiskUnSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemSeqTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataAlignedMemUnSeqTime().get());
        SeriesScanCostMetricSet.getInstance().recordTimeSeriesMetadataMetrics(this.getQueryStatistics().getLoadTimeSeriesMetadataFromCacheCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataFromDiskCount().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataActualIOSize().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataFromCacheTime().get(), this.getQueryStatistics().getLoadTimeSeriesMetadataFromDiskTime().get());
        SeriesScanCostMetricSet.getInstance().recordConstructChunkReadersCount(this.getQueryStatistics().getConstructAlignedChunkReadersMemCount().get(), this.getQueryStatistics().getConstructAlignedChunkReadersDiskCount().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersMemCount().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersDiskCount().get());
        SeriesScanCostMetricSet.getInstance().recordConstructChunkReadersTime(this.getQueryStatistics().getConstructAlignedChunkReadersMemTime().get(), this.getQueryStatistics().getConstructAlignedChunkReadersDiskTime().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersMemTime().get(), this.getQueryStatistics().getConstructNonAlignedChunkReadersDiskTime().get());
        SeriesScanCostMetricSet.getInstance().recordChunkMetrics(this.getQueryStatistics().getLoadChunkFromCacheCount().get(), this.getQueryStatistics().getLoadChunkFromDiskCount().get(), this.getQueryStatistics().getLoadChunkActualIOSize().get());
        SeriesScanCostMetricSet.getInstance().recordPageReadersDecompressCount(this.getQueryStatistics().getPageReadersDecodeAlignedMemCount().get(), this.getQueryStatistics().getPageReadersDecodeAlignedDiskCount().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedMemCount().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedDiskCount().get());
        SeriesScanCostMetricSet.getInstance().recordPageReadersDecompressTime(this.getQueryStatistics().getPageReadersDecodeAlignedMemTime().get(), this.getQueryStatistics().getPageReadersDecodeAlignedDiskTime().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedMemTime().get(), this.getQueryStatistics().getPageReadersDecodeNonAlignedDiskTime().get());
        SeriesScanCostMetricSet.getInstance().recordTimeSeriesMetadataModification(this.getQueryStatistics().getAlignedTimeSeriesMetadataModificationCount().get(), this.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationCount().get(), this.getQueryStatistics().getAlignedTimeSeriesMetadataModificationTime().get(), this.getQueryStatistics().getNonAlignedTimeSeriesMetadataModificationTime().get());
        SeriesScanCostMetricSet.getInstance().updatePageReaderMemoryUsage(this.getQueryStatistics().getPageReaderMaxUsedMemorySize().get());
    }

    private synchronized void releaseDataNodeQueryContext() {
        if (this.dataNodeQueryContextMap == null) {
            return;
        }
        if (this.dataNodeQueryContext.decreaseDataNodeFINum() == 0) {
            this.dataNodeQueryContext = null;
            this.dataNodeQueryContextMap.remove(this.id.getQueryId());
        }
    }

    public void setMayHaveTmpFile(boolean mayHaveTmpFile) {
        this.mayHaveTmpFile = mayHaveTmpFile;
    }

    public boolean mayHaveTmpFile() {
        return this.mayHaveTmpFile;
    }

    public Optional<List<Long>> getTimePartitions() {
        return Optional.ofNullable(this.timePartitions);
    }

    public void setTimePartitions(List<Long> timePartitions) {
        this.timePartitions = timePartitions;
    }

    public void setFragmentInstanceStatistics(TFetchFragmentInstanceStatisticsResp statistics) {
        this.fragmentInstanceStatistics = statistics;
    }

    public TFetchFragmentInstanceStatisticsResp getFragmentInstanceStatistics() {
        return this.fragmentInstanceStatistics;
    }

    public void setInitQueryDataSourceCost(long initQueryDataSourceCost) {
        this.initQueryDataSourceCost = initQueryDataSourceCost;
    }

    public long getInitQueryDataSourceCost() {
        return this.initQueryDataSourceCost;
    }

    public void addReadyQueuedTime(long time) {
        this.readyQueueTime.addAndGet(time);
    }

    public void addBlockQueuedTime(long time) {
        this.blockQueueTime.addAndGet(time);
    }

    public long getReadyQueueTime() {
        return this.readyQueueTime.get();
    }

    public long getBlockQueueTime() {
        return this.blockQueueTime.get();
    }

    public long getClosedSeqFileNum() {
        return this.closedSeqFileNum;
    }

    public long getUnclosedUnseqFileNum() {
        return this.unclosedUnseqFileNum;
    }

    public long getClosedUnseqFileNum() {
        return this.closedUnseqFileNum;
    }

    public long getUnclosedSeqFileNum() {
        return this.unclosedSeqFileNum;
    }

    public boolean ignoreNotExistsDevice() {
        return this.ignoreNotExistsDevice;
    }
}

