/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.utils;

import org.apache.iotdb.cluster.client.ClientCategory;
import org.apache.iotdb.cluster.client.sync.SyncDataClient;
import org.apache.iotdb.cluster.client.sync.SyncMetaClient;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.RaftService;

public class ClientUtils {
    private ClientUtils() {
    }

    public static int getPort(Node node, ClientCategory category) {
        int port = -1;
        switch (category) {
            case DATA: {
                port = node.getDataPort();
                break;
            }
            case DATA_HEARTBEAT: {
                port = node.getDataPort() + 1;
                break;
            }
            case META: {
                port = node.getMetaPort();
                break;
            }
            case META_HEARTBEAT: {
                port = node.getMetaPort() + 1;
                break;
            }
            case DATA_ASYNC_APPEND_CLIENT: {
                port = node.getDataPort();
                break;
            }
        }
        return port;
    }

    public static void putBackSyncClient(RaftService.Client client) {
        if (client instanceof SyncMetaClient) {
            ((SyncMetaClient)client).returnSelf();
        } else if (client instanceof SyncDataClient) {
            ((SyncDataClient)client).returnSelf();
        }
    }
}

