/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.cluster.server.handlers.caller;

import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.iotdb.cluster.log.Snapshot;
import org.apache.iotdb.cluster.log.snapshot.SnapshotFactory;
import org.apache.iotdb.cluster.rpc.thrift.Node;
import org.apache.iotdb.cluster.rpc.thrift.PullSnapshotResp;
import org.apache.thrift.async.AsyncMethodCallback;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PullSnapshotHandler<T extends Snapshot>
implements AsyncMethodCallback<PullSnapshotResp> {
    private static final Logger logger = LoggerFactory.getLogger(PullSnapshotHandler.class);
    private AtomicReference<Map<Integer, T>> resultRef;
    private Node node;
    private List<Integer> slot;
    private SnapshotFactory<T> factory;

    public PullSnapshotHandler(AtomicReference<Map<Integer, T>> resultRef, Node owner, List<Integer> slots, SnapshotFactory<T> factory) {
        this.resultRef = resultRef;
        this.node = owner;
        this.slot = slots;
        this.factory = factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onComplete(PullSnapshotResp response) {
        AtomicReference<Map<Integer, T>> atomicReference = this.resultRef;
        synchronized (atomicReference) {
            HashMap<Integer, T> ret = new HashMap<Integer, T>();
            Map snapshotBytes = response.snapshotBytes;
            for (Map.Entry entry : snapshotBytes.entrySet()) {
                T snapshot = this.factory.create();
                ((Snapshot)snapshot).deserialize((ByteBuffer)entry.getValue());
                ret.put((Integer)entry.getKey(), snapshot);
            }
            this.resultRef.set(ret);
            this.resultRef.notifyAll();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onError(Exception exception) {
        logger.error("Cannot pull snapshot of {} from {}", new Object[]{this.slot.size(), this.node, exception});
        AtomicReference<Map<Integer, T>> atomicReference = this.resultRef;
        synchronized (atomicReference) {
            this.resultRef.notifyAll();
        }
    }
}

