/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.tools;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.db.engine.fileSystem.SystemFileFactory;
import org.apache.iotdb.db.exception.SystemCheckException;
import org.apache.iotdb.db.writelog.io.SingleFileLogReader;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WalChecker {
    private static final Logger logger = LoggerFactory.getLogger(WalChecker.class);
    private String walFolder;

    public WalChecker(String walFolder) {
        this.walFolder = walFolder;
    }

    public List<File> doCheck() throws SystemCheckException {
        File walFolderFile = SystemFileFactory.INSTANCE.getFile(this.walFolder);
        logger.info("Checking folder: {}", (Object)walFolderFile.getAbsolutePath());
        if (!walFolderFile.exists() || !walFolderFile.isDirectory()) {
            throw new SystemCheckException(this.walFolder);
        }
        File[] storageWalFolders = walFolderFile.listFiles();
        if (storageWalFolders == null || storageWalFolders.length == 0) {
            logger.info("No sub-directories under the given directory, check ends");
            return Collections.emptyList();
        }
        ArrayList<File> failedFiles = new ArrayList<File>();
        for (int dirIndex = 0; dirIndex < storageWalFolders.length; ++dirIndex) {
            File storageWalFolder = storageWalFolders[dirIndex];
            logger.info("Checking the No.{} directory {}", (Object)dirIndex, (Object)storageWalFolder.getName());
            File walFile = SystemFileFactory.INSTANCE.getFile(storageWalFolder, "wal");
            if (this.checkFile(walFile)) continue;
            failedFiles.add(walFile);
        }
        return failedFiles;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean checkFile(File walFile) {
        if (!walFile.exists()) {
            logger.debug("No wal file in this dir, skipping");
            return true;
        }
        if (walFile.length() > 0L && walFile.length() < 12L) {
            logger.error("{} fails the check because it is non-empty but does not contain enough bytes even for one log.", (Object)walFile.getAbsoluteFile());
            return false;
        }
        try (SingleFileLogReader logReader = null;){
            logReader = new SingleFileLogReader(walFile);
            while (logReader.hasNext()) {
                logReader.next();
            }
            if (logReader.isFileCorrupted()) {
                boolean bl = false;
                return bl;
            }
        }
        return true;
    }

    public static void report(List<File> failedFiles) {
        if (failedFiles.isEmpty()) {
            logger.info("Check finished. There is no damaged file");
        } else {
            logger.error("There are {} failed files. They are {}", (Object)failedFiles.size(), failedFiles);
        }
    }

    public static void main(String[] args) throws SystemCheckException {
        if (args.length < 1) {
            logger.error("No enough args: require the walRootDirectory");
            return;
        }
        WalChecker checker = new WalChecker(args[0]);
        List<File> files = checker.doCheck();
        WalChecker.report(files);
    }
}

