/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.udf.builtin;

import java.util.HashSet;
import java.util.Set;
import org.apache.iotdb.db.query.udf.api.UDTF;
import org.apache.iotdb.db.query.udf.api.access.Row;
import org.apache.iotdb.db.query.udf.api.collector.PointCollector;
import org.apache.iotdb.db.query.udf.api.customizer.config.UDTFConfigurations;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameterValidator;
import org.apache.iotdb.db.query.udf.api.customizer.parameter.UDFParameters;
import org.apache.iotdb.db.query.udf.api.customizer.strategy.RowByRowAccessStrategy;
import org.apache.iotdb.db.query.udf.api.exception.UDFParameterNotValidException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.Binary;

public class UDTFConst
implements UDTF {
    private static final Set<String> VALID_TYPES = new HashSet<String>();
    private TSDataType dataType;
    private int intValue;
    private long longValue;
    private float floatValue;
    private double doubleValue;
    private boolean booleanValue;
    private Binary binaryValue;

    @Override
    public void validate(UDFParameterValidator validator) throws UDFParameterNotValidException {
        validator.validateRequiredAttribute("value").validateRequiredAttribute("type").validate(type -> VALID_TYPES.contains((String)type), "the given value type is not supported.", (Object)validator.getParameters().getString("type"));
    }

    @Override
    public void beforeStart(UDFParameters parameters, UDTFConfigurations configurations) {
        this.dataType = TSDataType.valueOf((String)parameters.getString("type"));
        switch (this.dataType) {
            case INT32: {
                this.intValue = Integer.parseInt(parameters.getString("value"));
                break;
            }
            case INT64: {
                this.longValue = Long.parseLong(parameters.getString("value"));
                break;
            }
            case FLOAT: {
                this.floatValue = Float.parseFloat(parameters.getString("value"));
                break;
            }
            case DOUBLE: {
                this.doubleValue = Double.parseDouble(parameters.getString("value"));
                break;
            }
            case BOOLEAN: {
                this.booleanValue = Boolean.parseBoolean(parameters.getString("value"));
                break;
            }
            case TEXT: {
                this.binaryValue = Binary.valueOf((String)parameters.getString("value"));
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
        configurations.setAccessStrategy(new RowByRowAccessStrategy()).setOutputDataType(this.dataType);
    }

    @Override
    public void transform(Row row, PointCollector collector) throws Exception {
        switch (this.dataType) {
            case INT32: {
                collector.putInt(row.getTime(), this.intValue);
                break;
            }
            case INT64: {
                collector.putLong(row.getTime(), this.longValue);
                break;
            }
            case FLOAT: {
                collector.putFloat(row.getTime(), this.floatValue);
                break;
            }
            case DOUBLE: {
                collector.putDouble(row.getTime(), this.doubleValue);
                break;
            }
            case BOOLEAN: {
                collector.putBoolean(row.getTime(), this.booleanValue);
                break;
            }
            case TEXT: {
                collector.putBinary(row.getTime(), this.binaryValue);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    static {
        VALID_TYPES.add(TSDataType.INT32.name());
        VALID_TYPES.add(TSDataType.INT64.name());
        VALID_TYPES.add(TSDataType.FLOAT.name());
        VALID_TYPES.add(TSDataType.DOUBLE.name());
        VALID_TYPES.add(TSDataType.BOOLEAN.name());
        VALID_TYPES.add(TSDataType.TEXT.name());
    }
}

