/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.control;

import java.time.ZoneId;
import java.util.Comparator;
import java.util.Map;
import java.util.Set;
import java.util.TimeZone;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import org.apache.iotdb.db.conf.IoTDBConstant;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.control.SessionManagerMBean;
import org.apache.iotdb.db.query.control.clientsession.IClientSession;
import org.apache.iotdb.db.query.dataset.UDTFDataSet;
import org.apache.iotdb.db.service.JMXService;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfo;
import org.apache.iotdb.service.rpc.thrift.TSConnectionInfoResp;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SessionManager
implements SessionManagerMBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(SessionManager.class);
    private final ThreadLocal<IClientSession> currSession = new ThreadLocal();
    private final Map<IClientSession, Object> sessions = new ConcurrentHashMap<IClientSession, Object>();
    private final Object placeHolder = new Object();
    @Deprecated
    private final AtomicLong sessionIdGenerator = new AtomicLong();
    private final AtomicLong statementIdGenerator = new AtomicLong();
    private final Map<Long, Set<Long>> statementIdToQueryId = new ConcurrentHashMap<Long, Set<Long>>();
    private final Map<Long, QueryDataSet> queryIdToDataSet = new ConcurrentHashMap<Long, QueryDataSet>();

    protected SessionManager() {
        String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.service", "type", "RpcSession");
        JMXService.registerMBean(this, mbeanName);
    }

    public IClientSession getCurrSession() {
        return this.currSession.get();
    }

    public TimeZone getSessionTimeZone() {
        IClientSession session = this.currSession.get();
        if (session != null) {
            return session.getTimeZone();
        }
        return TimeZone.getTimeZone("+08:00");
    }

    public void removeCurrSession() {
        IClientSession session = this.currSession.get();
        this.sessions.remove(session);
        this.currSession.remove();
    }

    public boolean registerSession(IClientSession session) {
        if (this.currSession.get() != null) {
            LOGGER.error("the client session is registered repeatedly, pls check whether this is a bug.");
            return false;
        }
        this.currSession.set(session);
        this.sessions.put(session, this.placeHolder);
        return true;
    }

    public void supplySession(IClientSession session, String username, String zoneId, IoTDBConstant.ClientVersion clientVersion) {
        session.setId(this.sessionIdGenerator.incrementAndGet());
        session.setUsername(username);
        ZoneId curZoneId = zoneId != null && !zoneId.trim().isEmpty() ? ZoneId.of(zoneId) : ZoneId.systemDefault();
        session.setZoneId(curZoneId);
        session.setClientVersion(clientVersion);
        session.setLogin(true);
        session.setLogInTime(System.currentTimeMillis());
    }

    public boolean releaseSessionResource(IClientSession session) {
        if (session == null) {
            LOGGER.error("Error occurred while releasing session resource: session is null");
            return false;
        }
        Set<Long> statementIdSet = session.getStatementIds();
        if (statementIdSet != null) {
            for (Long statementId : statementIdSet) {
                Set<Long> queryIdSet = this.statementIdToQueryId.remove(statementId);
                if (queryIdSet == null) continue;
                for (Long queryId : queryIdSet) {
                    this.releaseQueryResourceNoExceptions(queryId);
                }
            }
            return true;
        }
        return false;
    }

    public IClientSession getSessionIdByQueryId(long queryId) {
        for (Map.Entry<Long, Set<Long>> statementToQueries : this.statementIdToQueryId.entrySet()) {
            if (!statementToQueries.getValue().contains(queryId)) continue;
            Long statementId = statementToQueries.getKey();
            for (IClientSession session : this.sessions.keySet()) {
                if (!session.getStatementIds().contains(statementId)) continue;
                return session;
            }
        }
        return null;
    }

    public long requestStatementId(IClientSession session) {
        long statementId = this.statementIdGenerator.incrementAndGet();
        session.getStatementIds().add(statementId);
        return statementId;
    }

    public void closeStatement(IClientSession session, long statementId) {
        Set<Long> queryIdSet = this.statementIdToQueryId.remove(statementId);
        if (queryIdSet != null) {
            for (Long queryId : queryIdSet) {
                this.releaseQueryResourceNoExceptions(queryId);
            }
        }
        session.getStatementIds().remove(statementId);
    }

    public long requestQueryId(Long statementId, boolean isDataQuery) {
        long queryId = this.requestQueryId(isDataQuery);
        this.statementIdToQueryId.computeIfAbsent(statementId, k -> new CopyOnWriteArraySet()).add(queryId);
        return queryId;
    }

    public long requestQueryId(boolean isDataQuery) {
        return QueryResourceManager.getInstance().assignQueryId(isDataQuery);
    }

    public void releaseQueryResource(long queryId) throws StorageEngineException {
        QueryDataSet dataSet = this.queryIdToDataSet.remove(queryId);
        if (dataSet instanceof UDTFDataSet) {
            ((UDTFDataSet)dataSet).finalizeUDFs(queryId);
        }
        QueryResourceManager.getInstance().endQuery(queryId);
    }

    public void releaseQueryResourceNoExceptions(long queryId) {
        if (queryId != -1L) {
            try {
                this.releaseQueryResource(queryId);
            }
            catch (Exception e) {
                LOGGER.warn("Error occurred while releasing query resource: ", (Throwable)e);
            }
        }
    }

    public boolean hasDataset(Long queryId) {
        return this.queryIdToDataSet.containsKey(queryId);
    }

    public QueryDataSet getDataset(Long queryId) {
        return this.queryIdToDataSet.get(queryId);
    }

    public void setDataset(Long queryId, QueryDataSet dataSet) {
        this.queryIdToDataSet.put(queryId, dataSet);
    }

    public void removeDataset(Long queryId) {
        this.queryIdToDataSet.remove(queryId);
    }

    public void closeDataset(Long statementId, Long queryId) {
        this.releaseQueryResourceNoExceptions(queryId);
        if (this.statementIdToQueryId.containsKey(statementId)) {
            this.statementIdToQueryId.get(statementId).remove(queryId);
        }
    }

    public static SessionManager getInstance() {
        return SessionManagerHelper.INSTANCE;
    }

    @Override
    public Set<String> getAllRpcClients() {
        return this.sessions.keySet().stream().map(x -> x.toString()).collect(Collectors.toSet());
    }

    public TSConnectionInfoResp getAllConnectionInfo() {
        return new TSConnectionInfoResp(this.sessions.keySet().stream().map(IClientSession::convertToTSConnectionInfo).sorted(Comparator.comparingLong(TSConnectionInfo::getLogInTime)).collect(Collectors.toList()));
    }

    private static class SessionManagerHelper {
        private static final SessionManager INSTANCE = new SessionManager();

        private SessionManagerHelper() {
        }
    }
}

