/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.engine.storagegroup.ILastFlushTimeManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastFlushTimeManager
implements ILastFlushTimeManager {
    private static final Logger logger = LoggerFactory.getLogger(LastFlushTimeManager.class);
    private Map<Long, Map<String, Long>> latestTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> partitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<Long, Map<String, Long>> newlyFlushedPartitionLatestFlushedTimeForEachDevice = new HashMap<Long, Map<String, Long>>();
    private Map<String, Long> globalLatestFlushedTimeForEachDevice = new HashMap<String, Long>();

    @Override
    public void setMultiDeviceLastTime(long timePartitionId, Map<String, Long> lastTimeMap) {
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).putAll(lastTimeMap);
    }

    @Override
    public void setOneDeviceLastTime(long timePartitionId, String path, long time) {
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).put(path, time);
    }

    @Override
    public void setMultiDeviceFlushedTime(long timePartitionId, Map<String, Long> flushedTimeMap) {
        this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).putAll(flushedTimeMap);
    }

    @Override
    public void setOneDeviceFlushedTime(long timePartitionId, String path, long time) {
        this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, l -> new HashMap()).put(path, time);
    }

    @Override
    public void setMultiDeviceGlobalFlushedTime(Map<String, Long> globalFlushedTimeMap) {
        this.globalLatestFlushedTimeForEachDevice.putAll(globalFlushedTimeMap);
    }

    @Override
    public void setOneDeviceGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.put(path, time);
    }

    @Override
    public void updateLastTime(long timePartitionId, String path, long time) {
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateFlushedTime(long timePartitionId, String path, long time) {
        this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateGlobalFlushedTime(String path, long time) {
        this.globalLatestFlushedTimeForEachDevice.compute(path, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(long partitionId, String deviceId, long time) {
        this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).compute(deviceId, (k, v) -> v == null ? time : Math.max(v, time));
    }

    @Override
    public void ensureLastTimePartition(long timePartitionId) {
        this.latestTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
    }

    @Override
    public void ensureFlushedTimePartition(long timePartitionId) {
        this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap());
    }

    @Override
    public long ensureFlushedTimePartitionAndInit(long timePartitionId, String path, long initTime) {
        return this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).computeIfAbsent(path, id -> initTime);
    }

    @Override
    public void applyNewlyFlushedTimeToFlushedTime() {
        for (Map.Entry<Long, Map<String, Long>> entry : this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.entrySet()) {
            long timePartitionId = entry.getKey();
            Map latestFlushTimeForPartition = this.partitionLatestFlushedTimeForEachDevice.getOrDefault(timePartitionId, new HashMap());
            for (Map.Entry<String, Long> endTimeMap : entry.getValue().entrySet()) {
                String device = endTimeMap.getKey();
                long endTime = endTimeMap.getValue();
                if (latestFlushTimeForPartition.getOrDefault(device, Long.MIN_VALUE) >= endTime) continue;
                this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(timePartitionId, id -> new HashMap()).put(device, endTime);
            }
        }
    }

    @Override
    public boolean updateLatestFlushTimeToPartition(long partitionId, long latestFlushTime) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(partitionId);
        if (curPartitionDeviceLatestTime == null) {
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            entry.setValue(latestFlushTime);
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.newlyFlushedPartitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    @Override
    public boolean updateLatestFlushTime(long partitionId) {
        Map<String, Long> curPartitionDeviceLatestTime = this.latestTimeForEachDevice.get(partitionId);
        if (curPartitionDeviceLatestTime == null) {
            return false;
        }
        for (Map.Entry<String, Long> entry : curPartitionDeviceLatestTime.entrySet()) {
            this.partitionLatestFlushedTimeForEachDevice.computeIfAbsent(partitionId, id -> new HashMap()).put(entry.getKey(), entry.getValue());
            this.updateNewlyFlushedPartitionLatestFlushedTimeForEachDevice(partitionId, entry.getKey(), entry.getValue());
            if (this.globalLatestFlushedTimeForEachDevice.getOrDefault(entry.getKey(), Long.MIN_VALUE) >= entry.getValue()) continue;
            this.globalLatestFlushedTimeForEachDevice.put(entry.getKey(), entry.getValue());
        }
        return true;
    }

    @Override
    public long getFlushedTime(long timePartitionId, String path) {
        return this.partitionLatestFlushedTimeForEachDevice.get(timePartitionId).getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public long getLastTime(long timePartitionId, String path) {
        return this.latestTimeForEachDevice.get(timePartitionId).getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public long getGlobalFlushedTime(String path) {
        return this.globalLatestFlushedTimeForEachDevice.getOrDefault(path, Long.MIN_VALUE);
    }

    @Override
    public void clearLastTime() {
        this.latestTimeForEachDevice.clear();
    }

    @Override
    public void clearFlushedTime() {
        this.partitionLatestFlushedTimeForEachDevice.clear();
    }

    @Override
    public void clearGlobalFlushedTime() {
        this.globalLatestFlushedTimeForEachDevice.clear();
    }
}

