/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.tsfile.read.filter.operator;

import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.basic.UnaryFilter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterSerializeId;
import org.apache.iotdb.tsfile.read.filter.factory.FilterType;

public class Eq<T extends Comparable<T>>
extends UnaryFilter<T> {
    private static final long serialVersionUID = -6668083116644568248L;

    public Eq() {
    }

    public Eq(T value, FilterType filterType) {
        super(value, filterType);
    }

    @Override
    public boolean satisfy(Statistics statistics) {
        if (this.filterType == FilterType.TIME_FILTER) {
            return (Long)this.value >= statistics.getStartTime() && (Long)this.value <= statistics.getEndTime();
        }
        if (statistics.getType() == TSDataType.TEXT || statistics.getType() == TSDataType.BOOLEAN) {
            return true;
        }
        return this.value.compareTo((Comparable)statistics.getMinValue()) >= 0 && this.value.compareTo((Comparable)statistics.getMaxValue()) <= 0;
    }

    @Override
    public boolean satisfy(long time, Object value) {
        Object v = this.filterType == FilterType.TIME_FILTER ? Long.valueOf(time) : value;
        return this.value.equals(v);
    }

    @Override
    public boolean satisfyStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return time <= endTime && time >= startTime;
        }
        return true;
    }

    @Override
    public boolean containStartEndTime(long startTime, long endTime) {
        if (this.filterType == FilterType.TIME_FILTER) {
            long time = (Long)this.value;
            return time == startTime && time == endTime;
        }
        return true;
    }

    @Override
    public Filter copy() {
        return new Eq<Comparable>(this.value, this.filterType);
    }

    @Override
    public String toString() {
        return (Object)((Object)this.getFilterType()) + " == " + this.value;
    }

    @Override
    public FilterSerializeId getSerializeId() {
        return FilterSerializeId.EQ;
    }
}

