/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.raft.jraft.util;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.raft.jraft.util.Platform;
import org.apache.ignite3.raft.jraft.util.Requires;
import org.apache.ignite3.raft.jraft.util.Utils;
import org.rocksdb.BlockBasedTableConfig;
import org.rocksdb.BloomFilter;
import org.rocksdb.ColumnFamilyOptions;
import org.rocksdb.CompactionStyle;
import org.rocksdb.CompressionType;
import org.rocksdb.DBOptions;
import org.rocksdb.Filter;
import org.rocksdb.IndexType;
import org.rocksdb.RocksDB;
import org.rocksdb.RocksObject;

public final class StorageOptionsFactory {
    private static final Map<String, DBOptions> rocksDBOptionsTable;
    private static final Map<String, ColumnFamilyOptions> columnFamilyOptionsTable;
    private static final Map<String, BlockBasedTableConfig> tableFormatConfigTable;

    public static void releaseAllOptions() {
        for (DBOptions dBOptions : rocksDBOptionsTable.values()) {
            if (dBOptions == null) continue;
            dBOptions.close();
        }
        for (ColumnFamilyOptions columnFamilyOptions : columnFamilyOptionsTable.values()) {
            if (columnFamilyOptions == null) continue;
            columnFamilyOptions.close();
        }
    }

    public static void registerRocksDBOptions(Class<?> cls, DBOptions opts) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(opts, "opts");
        if (rocksDBOptionsTable.putIfAbsent(cls.getName(), opts) != null) {
            throw new IllegalStateException("DBOptions with class key [" + cls.getName() + "] has already been registered");
        }
    }

    public static DBOptions getRocksDBOptions(Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        DBOptions opts = rocksDBOptionsTable.get(cls.getName());
        if (opts == null) {
            DBOptions newOpts = StorageOptionsFactory.getDefaultRocksDBOptions();
            opts = rocksDBOptionsTable.putIfAbsent(cls.getName(), newOpts);
            if (opts == null) {
                opts = newOpts;
            } else {
                newOpts.close();
            }
        }
        return new DBOptions(StorageOptionsFactory.checkInvalid(opts));
    }

    public static DBOptions getDefaultRocksDBOptions() {
        DBOptions opts = new DBOptions();
        opts.setCreateIfMissing(true);
        opts.setCreateMissingColumnFamilies(true);
        opts.setMaxOpenFiles(-1);
        opts.setKeepLogFileNum(100L);
        opts.setMaxTotalWalSize(0x40000000L);
        opts.setMaxBackgroundCompactions(Math.min(Utils.cpus(), 4));
        opts.setMaxBackgroundFlushes(1);
        return opts;
    }

    public static void registerRocksDBColumnFamilyOptions(Class<?> cls, ColumnFamilyOptions opts) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(opts, "opts");
        if (columnFamilyOptionsTable.putIfAbsent(cls.getName(), opts) != null) {
            throw new IllegalStateException("ColumnFamilyOptions with class key [" + cls.getName() + "] has already been registered");
        }
    }

    public static ColumnFamilyOptions getRocksDBColumnFamilyOptions(Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        ColumnFamilyOptions opts = columnFamilyOptionsTable.get(cls.getName());
        if (opts == null) {
            ColumnFamilyOptions newOpts = StorageOptionsFactory.getDefaultRocksDBColumnFamilyOptions();
            opts = columnFamilyOptionsTable.putIfAbsent(cls.getName(), newOpts);
            if (opts == null) {
                opts = newOpts;
            } else {
                newOpts.close();
            }
        }
        return new ColumnFamilyOptions(StorageOptionsFactory.checkInvalid(opts));
    }

    public static ColumnFamilyOptions getDefaultRocksDBColumnFamilyOptions() {
        ColumnFamilyOptions opts = new ColumnFamilyOptions();
        opts.setWriteBufferSize(0x4000000L);
        opts.setMaxWriteBufferNumber(3);
        opts.setMinWriteBufferNumberToMerge(1);
        opts.setLevel0FileNumCompactionTrigger(10);
        opts.setLevel0SlowdownWritesTrigger(20);
        opts.setLevel0StopWritesTrigger(40);
        opts.setMaxBytesForLevelBase(0x20000000L);
        opts.setTargetFileSizeBase(0x4000000L);
        opts.setMemtablePrefixBloomSizeRatio(0.125);
        if (!Platform.isWindows()) {
            opts.setCompressionType(CompressionType.LZ4_COMPRESSION).setCompactionStyle(CompactionStyle.LEVEL).optimizeLevelStyleCompaction();
        }
        opts.setForceConsistencyChecks(true);
        return opts;
    }

    public static void registerRocksDBTableFormatConfig(Class<?> cls, BlockBasedTableConfig cfg) {
        Requires.requireNonNull(cls, "cls");
        Requires.requireNonNull(cfg, "cfg");
    }

    public static BlockBasedTableConfig getRocksDBTableFormatConfig(Class<?> cls) {
        Requires.requireNonNull(cls, "cls");
        BlockBasedTableConfig cfg = tableFormatConfigTable.get(cls.getName());
        if (cfg == null) {
            BlockBasedTableConfig newCfg = StorageOptionsFactory.getDefaultRocksDBTableConfig();
            cfg = tableFormatConfigTable.putIfAbsent(cls.getName(), newCfg);
            if (cfg == null) {
                cfg = newCfg;
            }
        }
        return StorageOptionsFactory.copyTableFormatConfig(cfg);
    }

    public static BlockBasedTableConfig getDefaultRocksDBTableConfig() {
        return new BlockBasedTableConfig().setIndexType(IndexType.kTwoLevelIndexSearch).setFilter((Filter)new BloomFilter(16.0, false)).setPartitionFilters(true).setMetadataBlockSize(8192L).setCacheIndexAndFilterBlocks(false).setCacheIndexAndFilterBlocksWithHighPriority(true).setPinL0FilterAndIndexBlocksInCache(true).setBlockSize(4096L).setBlockCacheSize(0x20000000L).setCacheNumShardBits(8);
    }

    private static BlockBasedTableConfig copyTableFormatConfig(BlockBasedTableConfig cfg) {
        return new BlockBasedTableConfig().setNoBlockCache(cfg.noBlockCache()).setBlockCacheSize(cfg.blockCacheSize()).setCacheNumShardBits(cfg.cacheNumShardBits()).setBlockSize(cfg.blockSize()).setBlockSizeDeviation(cfg.blockSizeDeviation()).setBlockRestartInterval(cfg.blockRestartInterval()).setWholeKeyFiltering(cfg.wholeKeyFiltering()).setCacheIndexAndFilterBlocks(cfg.cacheIndexAndFilterBlocks()).setCacheIndexAndFilterBlocksWithHighPriority(cfg.cacheIndexAndFilterBlocksWithHighPriority()).setPinL0FilterAndIndexBlocksInCache(cfg.pinL0FilterAndIndexBlocksInCache()).setPartitionFilters(cfg.partitionFilters()).setMetadataBlockSize(cfg.metadataBlockSize()).setPinTopLevelIndexAndFilter(cfg.pinTopLevelIndexAndFilter()).setHashIndexAllowCollision(cfg.hashIndexAllowCollision()).setChecksumType(cfg.checksumType()).setIndexType(cfg.indexType()).setFormatVersion(cfg.formatVersion());
    }

    private static <T extends RocksObject> T checkInvalid(T opts) {
        if (!opts.isOwningHandle()) {
            throw new IllegalStateException("the instance of options [" + opts + "] has been released, calling any of its functions will lead to undefined behavior.");
        }
        return opts;
    }

    private StorageOptionsFactory() {
    }

    static {
        RocksDB.loadLibrary();
        rocksDBOptionsTable = new ConcurrentHashMap<String, DBOptions>();
        columnFamilyOptionsTable = new ConcurrentHashMap<String, ColumnFamilyOptions>();
        tableFormatConfigTable = new ConcurrentHashMap<String, BlockBasedTableConfig>();
    }
}

