/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite3.internal.eventlog.event;

import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.ignite3.internal.eventlog.event.exception.NotUniqueEventTypeException;

public final class EventTypeRegistry {
    private static final Object DUMMY = new Object();
    private static final ConcurrentHashMap<String, Object> allTypes = new ConcurrentHashMap();

    private EventTypeRegistry() {
    }

    public static void register(Set<String> types) {
        new HashSet<String>(types).forEach(EventTypeRegistry::register);
    }

    public static void register(String type) {
        allTypes.compute(type, (k, v) -> {
            if (v != null) {
                throw new NotUniqueEventTypeException(type);
            }
            return DUMMY;
        });
    }

    public static boolean contains(String type) {
        return allTypes.containsKey(type);
    }
}

