/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.server;

import java.util.Arrays;
import org.apache.ignite.internal.metastorage.Entry;
import org.apache.ignite.internal.metastorage.server.Condition;
import org.apache.ignite.internal.util.ArrayUtils;

public abstract class AbstractCompoundCondition
implements Condition {
    private final Condition leftCondition;
    private final Condition rightCondition;
    private final byte[][] keys;

    public AbstractCompoundCondition(Condition leftCondition, Condition rightCondition) {
        this.leftCondition = leftCondition;
        this.rightCondition = rightCondition;
        this.keys = (byte[][])ArrayUtils.concat((Object[])leftCondition.keys(), (Object[])rightCondition.keys());
    }

    @Override
    public byte[][] keys() {
        return this.keys;
    }

    protected final boolean testLeftCondition(Entry[] entries) {
        return this.leftCondition.test(Arrays.copyOf(entries, this.leftCondition.keys().length));
    }

    protected final boolean testRightCondition(Entry[] entries) {
        return this.rightCondition.test(Arrays.copyOfRange(entries, this.leftCondition.keys().length, this.leftCondition.keys().length + this.rightCondition.keys().length));
    }

    public Condition leftCondition() {
        return this.leftCondition;
    }

    public Condition rightCondition() {
        return this.rightCondition;
    }
}

