/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.metastorage.impl;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.configuration.SystemDistributedConfiguration;
import org.apache.ignite.internal.configuration.SystemDistributedView;
import org.apache.ignite.internal.configuration.SystemPropertyView;
import org.apache.ignite.internal.util.CompletableFutures;
import org.jetbrains.annotations.Nullable;

public class MetaStorageCompactionTriggerConfiguration {
    public static final String INTERVAL_SYSTEM_PROPERTY_NAME = "metastorageCompactionInterval";
    public static final String DATA_AVAILABILITY_TIME_SYSTEM_PROPERTY_NAME = "metastorageCompactionDataAvailabilityTime";
    public static final long INTERVAL_DEFAULT_VALUE = TimeUnit.MINUTES.toMillis(1L);
    public static final long DATA_AVAILABILITY_TIME_DEFAULT_VALUE = TimeUnit.HOURS.toMillis(1L);
    private final SystemDistributedConfiguration systemDistributedConfig;
    private final ReadWriteLock rwLock = new ReentrantReadWriteLock();
    private long interval;
    private long dataAvailabilityTime;
    private boolean inited;

    MetaStorageCompactionTriggerConfiguration(SystemDistributedConfiguration systemDistributedConfig) {
        this.systemDistributedConfig = systemDistributedConfig;
        systemDistributedConfig.listen(ctx -> {
            this.updateSystemProperties((SystemDistributedView)ctx.newValue());
            return CompletableFutures.nullCompletedFuture();
        });
    }

    void init() {
        this.updateSystemProperties((SystemDistributedView)this.systemDistributedConfig.value());
    }

    long interval() {
        this.rwLock.readLock().lock();
        try {
            assert (this.inited) : "Configuration has not yet been initialized from the distributed system configuration";
            long l = this.interval;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    long dataAvailabilityTime() {
        this.rwLock.readLock().lock();
        try {
            assert (this.inited) : "Configuration has not yet been initialized from the distributed system configuration";
            long l = this.dataAvailabilityTime;
            return l;
        }
        finally {
            this.rwLock.readLock().unlock();
        }
    }

    private void updateSystemProperties(SystemDistributedView view) {
        this.rwLock.writeLock().lock();
        try {
            this.inited = true;
            this.interval = MetaStorageCompactionTriggerConfiguration.longValue(view, INTERVAL_SYSTEM_PROPERTY_NAME, INTERVAL_DEFAULT_VALUE);
            this.dataAvailabilityTime = MetaStorageCompactionTriggerConfiguration.longValue(view, DATA_AVAILABILITY_TIME_SYSTEM_PROPERTY_NAME, DATA_AVAILABILITY_TIME_DEFAULT_VALUE);
        }
        finally {
            this.rwLock.writeLock().unlock();
        }
    }

    private static long longValue(SystemDistributedView systemDistributedView, String systemPropertyName, long defaultValue) {
        return MetaStorageCompactionTriggerConfiguration.longValue((SystemPropertyView)systemDistributedView.properties().get(systemPropertyName), defaultValue);
    }

    private static long longValue(@Nullable SystemPropertyView systemPropertyView, long defaultValue) {
        if (systemPropertyView == null) {
            return defaultValue;
        }
        return Long.parseLong(systemPropertyView.propertyValue());
    }
}

