/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.storage.logit.storage.file;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.ignite.internal.logger.IgniteLogger;
import org.apache.ignite.internal.logger.Loggers;
import org.apache.ignite.raft.jraft.storage.logit.option.StoreOptions;
import org.apache.ignite.raft.jraft.storage.logit.storage.factory.LogStoreFactory;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.AbstractFile;
import org.apache.ignite.raft.jraft.storage.logit.storage.file.FileType;
import org.apache.ignite.raft.jraft.storage.logit.storage.service.AllocateFileService;
import org.apache.ignite.raft.jraft.util.Requires;

public class FileManager {
    private static final IgniteLogger LOG = Loggers.forClass(FileManager.class);
    private final String storePath;
    private final FileType fileType;
    private final StoreOptions storeOptions;
    private final int fileSize;
    private final AllocateFileService allocateService;
    private final LogStoreFactory logStoreFactory;
    private final List<AbstractFile> files = new ArrayList<AbstractFile>();
    private volatile long flushedPosition;
    private final ReadWriteLock lock = new ReentrantReadWriteLock();
    private final Lock readLock = this.lock.readLock();
    private final Lock writeLock = this.lock.writeLock();

    public FileManager(FileType fileType, int fileSize, String storePath, LogStoreFactory logStoreFactory, AllocateFileService allocateService) {
        this.storePath = storePath;
        this.fileType = fileType;
        this.allocateService = allocateService;
        this.storeOptions = logStoreFactory.getStoreOptions();
        this.logStoreFactory = logStoreFactory;
        this.fileSize = fileSize;
    }

    public static FileManagerBuilder newBuilder() {
        return new FileManagerBuilder();
    }

    public List<AbstractFile> loadExistedFiles() {
        File[] files;
        File dir = new File(this.storePath);
        if (!dir.exists()) {
            dir.mkdirs();
        }
        if ((files = dir.listFiles()) == null || files.length == 0) {
            return Collections.emptyList();
        }
        Arrays.sort(files, Comparator.comparing(this::getFileSequenceFromFileName));
        ArrayList<AbstractFile> blankFiles = new ArrayList<AbstractFile>(files.length);
        long nextFileSequence = 0L;
        for (File file : files) {
            AbstractFile abstractFile = this.checkFileCorrectnessAndMmap(file);
            if (abstractFile == null) continue;
            if (abstractFile.loadHeader() && !abstractFile.isBlank()) {
                this.files.add(abstractFile);
            } else {
                abstractFile.reset();
                blankFiles.add(abstractFile);
            }
            nextFileSequence = Math.max(nextFileSequence, this.getFileSequenceFromFileName(file) + 1L);
        }
        this.allocateService.setNextFileSequence(nextFileSequence);
        this.allocateService.addBlankAbstractFiles(blankFiles);
        return this.files;
    }

    private AbstractFile checkFileCorrectnessAndMmap(File file) {
        if (!file.exists() || !file.getName().endsWith(this.fileType.getFileSuffix())) {
            return null;
        }
        AbstractFile abstractFile = null;
        long fileLength = file.length();
        if (fileLength == (long)this.fileSize) {
            abstractFile = this.logStoreFactory.newFile(this.fileType, file.getPath());
        }
        return abstractFile;
    }

    public AbstractFile[] copyFiles() {
        this.readLock.lock();
        try {
            AbstractFile[] abstractFileArray = this.files.toArray(new AbstractFile[0]);
            return abstractFileArray;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile getLastFile(long logIndex, int waitToWroteSize, boolean createIfNecessary) {
        AbstractFile lastFile = null;
        while (true) {
            int fileCount = 0;
            this.readLock.lock();
            try {
                if (!this.files.isEmpty()) {
                    fileCount = this.files.size();
                    AbstractFile file = this.files.get(fileCount - 1);
                    if (waitToWroteSize <= 0 || !file.reachesFileEndBy(waitToWroteSize)) {
                        lastFile = file;
                    } else if (file.reachesFileEndBy(waitToWroteSize)) {
                        file.fillEmptyBytesInFileEnd();
                    }
                }
            }
            finally {
                this.readLock.unlock();
            }
            if (lastFile != null || !createIfNecessary) break;
            this.writeLock.lock();
            try {
                if (this.files.size() != fileCount || (lastFile = this.allocateService.takeEmptyFile()) == null) continue;
                long newFileOffset = (long)this.files.size() * (long)this.fileSize;
                lastFile.setFileFromOffset(newFileOffset);
                this.files.add(lastFile);
                this.swapOutFilesIfNecessary();
                AbstractFile abstractFile = lastFile;
                return abstractFile;
            }
            catch (Exception e) {
                LOG.error("Error on create new abstract file , current logIndex:{}", new Object[]{logIndex});
            }
            finally {
                this.writeLock.unlock();
                continue;
            }
            break;
        }
        return lastFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void swapOutFilesIfNecessary() {
        this.readLock.lock();
        try {
            if (this.files.size() <= this.storeOptions.getKeepInMemoryFileCount()) {
                return;
            }
            int filesInMemoryCount = this.allocateService.getAllocatedFileCount();
            int swappedOutCount = 0;
            int lastIndex = this.files.size() - 1;
            long lastSwappedOutPosition = 0L;
            for (int i = lastIndex; i >= 0; --i) {
                AbstractFile abstractFile = this.files.get(i);
                if (!abstractFile.isMapped() || ++filesInMemoryCount < this.storeOptions.getKeepInMemoryFileCount() || i == lastIndex) continue;
                abstractFile.unmmap();
                ++swappedOutCount;
                if (lastSwappedOutPosition != 0L) continue;
                lastSwappedOutPosition = abstractFile.getFileFromOffset() + (long)abstractFile.getFileSize();
            }
            if (this.getFlushedPosition() < lastSwappedOutPosition) {
                this.setFlushedPosition(lastSwappedOutPosition);
            }
            LOG.info("Swapped out {} abstract files", new Object[]{swappedOutCount});
        }
        catch (Exception e) {
            LOG.error("Error on swap out files", (Throwable)e);
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile findFileByLogIndex(long logIndex, boolean returnFirstIfNotFound) {
        this.readLock.lock();
        try {
            if (this.files.isEmpty()) {
                AbstractFile abstractFile = null;
                return abstractFile;
            }
            if (this.files.size() == 1) {
                AbstractFile abstractFile = this.getFirstFile();
                return abstractFile;
            }
            int lo = 0;
            int hi = this.files.size() - 1;
            while (lo <= hi) {
                int mid = lo + hi >>> 1;
                AbstractFile file = this.files.get(mid);
                if (file.getLastLogIndex() < logIndex) {
                    lo = mid + 1;
                    continue;
                }
                if (file.getFirstLogIndex() > logIndex) {
                    hi = mid - 1;
                    continue;
                }
                AbstractFile abstractFile = this.files.get(mid);
                return abstractFile;
            }
            if (returnFirstIfNotFound) {
                AbstractFile abstractFile = this.getFirstFile();
                return abstractFile;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile[] findFileFromLogIndex(long logIndex) {
        this.readLock.lock();
        try {
            for (int i = 0; i < this.files.size(); ++i) {
                AbstractFile file = this.files.get(i);
                if (file.getFirstLogIndex() > logIndex || logIndex > file.getLastLogIndex()) continue;
                AbstractFile[] result = new AbstractFile[this.files.size() - i + 1];
                for (int j = i; j < this.files.size(); ++j) {
                    result[j - i] = this.files.get(j);
                }
                AbstractFile[] abstractFileArray = result;
                return abstractFileArray;
            }
        }
        finally {
            this.readLock.unlock();
        }
        return new AbstractFile[0];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractFile findFileByOffset(long offset, boolean returnFirstIfNotFound) {
        block14: {
            this.readLock.lock();
            try {
                if (this.files.size() == 0) {
                    AbstractFile abstractFile = null;
                    return abstractFile;
                }
                AbstractFile firstAbstractFile = this.getFirstFile();
                AbstractFile lastAbstractFile = this.getLastFile();
                if (firstAbstractFile == null || lastAbstractFile == null) break block14;
                if (offset < firstAbstractFile.getFileFromOffset() || offset >= lastAbstractFile.getFileFromOffset() + (long)this.fileSize) {
                    LOG.warn("Offset not matched. Request offset: {}, firstOffset: {}, lastOffset: {}, fileSize: {}, fileNums: {}", new Object[]{offset, firstAbstractFile.getFileFromOffset(), lastAbstractFile.getFileFromOffset() + (long)this.fileSize, this.fileSize, this.files.size()});
                } else {
                    int index = (int)(offset / (long)this.fileSize - firstAbstractFile.getFileFromOffset() / (long)this.fileSize);
                    AbstractFile targetFile = this.files.get(index);
                    if (targetFile != null && offset >= targetFile.getFileFromOffset() && offset < targetFile.getFileFromOffset() + (long)this.fileSize) {
                        AbstractFile abstractFile = targetFile;
                        return abstractFile;
                    }
                    for (AbstractFile abstractFile : this.files) {
                        if (offset < abstractFile.getFileFromOffset() || offset >= abstractFile.getFileFromOffset() + (long)this.fileSize) continue;
                        AbstractFile abstractFile2 = abstractFile;
                        return abstractFile2;
                    }
                }
                if (returnFirstIfNotFound) {
                    AbstractFile abstractFile = firstAbstractFile;
                    return abstractFile;
                }
            }
            catch (Exception e) {
                LOG.error("Error on find abstractFile by offset :{}, file type:{}", new Object[]{offset, this.fileType.getFileName(), e});
            }
            finally {
                this.readLock.unlock();
            }
        }
        return null;
    }

    public boolean flush() {
        long flushWhere;
        AbstractFile abstractFile = this.findFileByOffset(flushWhere, (flushWhere = this.getFlushedPosition()) == 0L);
        if (abstractFile != null) {
            int flushOffset = abstractFile.flush();
            this.setFlushedPosition(abstractFile.getFileFromOffset() + (long)flushOffset);
            return this.getFlushedPosition() != flushWhere;
        }
        return false;
    }

    public AbstractFile getLastFile() {
        return this.files.get(this.files.size() - 1);
    }

    public AbstractFile getFirstFile() {
        if (!this.files.isEmpty()) {
            return this.files.get(0);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void truncateSuffixByOffset(long offset) {
        this.readLock.lock();
        ArrayList<AbstractFile> willRemoveFiles = new ArrayList<AbstractFile>();
        try {
            for (AbstractFile file : this.files) {
                long tailOffset = file.getFileFromOffset() + (long)this.fileSize;
                if (tailOffset <= offset) continue;
                if (offset >= file.getFileFromOffset()) {
                    int truncatePosition = (int)(offset % (long)this.fileSize);
                    file.setWrotePosition(truncatePosition);
                    file.setFlushPosition(truncatePosition);
                    continue;
                }
                willRemoveFiles.add(file);
            }
            this.readLock.unlock();
        }
        catch (Throwable throwable) {
            this.readLock.unlock();
            for (AbstractFile file : willRemoveFiles) {
                if (file == null) continue;
                file.shutdown(1000L, true);
            }
            this.deleteFiles(willRemoveFiles);
            throw throwable;
        }
        for (AbstractFile file : willRemoveFiles) {
            if (file == null) continue;
            file.shutdown(1000L, true);
        }
        this.deleteFiles(willRemoveFiles);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean truncatePrefix(long firstIndexKept) {
        this.readLock.lock();
        ArrayList<AbstractFile> willRemoveFiles = new ArrayList<AbstractFile>();
        try {
            for (AbstractFile abstractFile : this.files) {
                long lastLogIndex = abstractFile.getLastLogIndex();
                if (lastLogIndex >= firstIndexKept) continue;
                willRemoveFiles.add(abstractFile);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
            for (AbstractFile file : willRemoveFiles) {
                if (file == null) continue;
                file.shutdown(1000L, true);
            }
            this.deleteFiles(willRemoveFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean truncateSuffix(long lastIndexKept, int pos) {
        if (this.getLastLogIndex() <= lastIndexKept) {
            return true;
        }
        this.readLock.lock();
        ArrayList<AbstractFile> willRemoveFiles = new ArrayList<AbstractFile>();
        try {
            long retainPosition = 0L;
            for (AbstractFile abstractFile : this.files) {
                long firstLogIndex = abstractFile.getFirstLogIndex();
                long lastLogIndex = abstractFile.getLastLogIndex();
                if (lastLogIndex > lastIndexKept) {
                    if (lastIndexKept >= firstLogIndex) {
                        int lastPosition = abstractFile.truncate(lastIndexKept + 1L, pos);
                        retainPosition += (long)lastPosition;
                        continue;
                    }
                    willRemoveFiles.add(abstractFile);
                    continue;
                }
                retainPosition += (long)this.fileSize;
            }
            if (retainPosition < this.getFlushedPosition()) {
                this.setFlushedPosition(retainPosition);
            }
            boolean bl = true;
            return bl;
        }
        finally {
            this.readLock.unlock();
            for (AbstractFile file : willRemoveFiles) {
                if (file == null) continue;
                file.shutdown(1000L, true);
            }
            this.deleteFiles(willRemoveFiles);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean reset(long nextLogIndex) {
        ArrayList<AbstractFile> destroyedFiles = new ArrayList<AbstractFile>();
        this.writeLock.lock();
        try {
            destroyedFiles.addAll(this.files);
            this.files.clear();
            this.setFlushedPosition(0L);
            LOG.info("Destroyed all abstractFiles in path {} by resetting.", new Object[]{this.storePath});
        }
        finally {
            this.writeLock.unlock();
            for (AbstractFile file : destroyedFiles) {
                file.shutdown(1000L, true);
            }
        }
        return true;
    }

    private void deleteFiles(List<AbstractFile> files) {
        this.writeLock.lock();
        try {
            if (!files.isEmpty()) {
                files.removeIf(file -> !this.files.contains(file));
                this.files.removeAll(files);
            }
        }
        finally {
            this.writeLock.unlock();
        }
    }

    public long getFirstLogIndex() {
        this.readLock.lock();
        try {
            if (!this.files.isEmpty()) {
                long l = this.files.get(0).getFirstLogIndex();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getLastLogIndex() {
        this.readLock.lock();
        try {
            if (!this.files.isEmpty()) {
                AbstractFile lastFile = this.getLastFile();
                long l = lastFile.getLastLogIndex();
                return l;
            }
            long l = -1L;
            return l;
        }
        finally {
            this.readLock.unlock();
        }
    }

    public void shutdown() {
        for (AbstractFile file : this.files) {
            if (file == null) continue;
            file.shutdown(5000L, false);
        }
    }

    public long getFlushedPosition() {
        return this.flushedPosition;
    }

    public synchronized void setFlushedPosition(long flushedPosition) {
        this.flushedPosition = flushedPosition;
    }

    public long getFileSequenceFromFileName(File file) {
        String name = file.getName();
        if (name.endsWith(this.fileType.getFileSuffix())) {
            int idx = name.indexOf(this.fileType.getFileSuffix());
            return Long.parseLong(name.substring(0, idx));
        }
        return 0L;
    }

    public static class FileManagerBuilder {
        private FileType fileType;
        private String storePath;
        private Integer fileSize;
        private LogStoreFactory logStoreFactory;
        private AllocateFileService allocateService;

        public FileManagerBuilder storePath(String storePath) {
            this.storePath = storePath;
            return this;
        }

        public FileManagerBuilder fileType(FileType fileType) {
            this.fileType = fileType;
            return this;
        }

        public FileManagerBuilder logStoreFactory(LogStoreFactory logStoreFactory) {
            this.logStoreFactory = logStoreFactory;
            return this;
        }

        public FileManagerBuilder fileSize(Integer abstractFileSize) {
            this.fileSize = abstractFileSize;
            return this;
        }

        public FileManagerBuilder allocateService(AllocateFileService allocateService) {
            this.allocateService = allocateService;
            return this;
        }

        public FileManager build() {
            Requires.requireNonNull(this.storePath, "storePath");
            Requires.requireNonNull(this.fileType, "fileType");
            Requires.requireNonNull(this.logStoreFactory, "logStoreFactory");
            Requires.requireNonNull(this.fileSize, "fileSize");
            Requires.requireNonNull(this.allocateService, "allocateService");
            return new FileManager(this.fileType, this.fileSize, this.storePath, this.logStoreFactory, this.allocateService);
        }
    }
}

