/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.raft.jraft.rpc.impl.cli;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.Executor;
import org.apache.ignite.raft.jraft.RaftMessagesFactory;
import org.apache.ignite.raft.jraft.entity.PeerId;
import org.apache.ignite.raft.jraft.error.RaftError;
import org.apache.ignite.raft.jraft.rpc.CliRequests;
import org.apache.ignite.raft.jraft.rpc.Message;
import org.apache.ignite.raft.jraft.rpc.RaftRpcFactory;
import org.apache.ignite.raft.jraft.rpc.impl.cli.BaseCliRequestProcessor;
import org.apache.ignite.raft.jraft.rpc.impl.cli.IgniteCliRpcRequestClosure;

public class RemoveLearnersRequestProcessor
extends BaseCliRequestProcessor<CliRequests.RemoveLearnersRequest> {
    public RemoveLearnersRequestProcessor(Executor executor, RaftMessagesFactory msgFactory) {
        super(executor, msgFactory);
    }

    @Override
    protected String getPeerId(CliRequests.RemoveLearnersRequest request) {
        return request.leaderId();
    }

    @Override
    protected String getGroupId(CliRequests.RemoveLearnersRequest request) {
        return request.groupId();
    }

    @Override
    protected Message processRequest0(BaseCliRequestProcessor.CliRequestContext ctx, CliRequests.RemoveLearnersRequest request, IgniteCliRpcRequestClosure done) {
        List<PeerId> oldLearners = ctx.node.listLearners();
        ArrayList<PeerId> removeingLearners = new ArrayList<PeerId>(request.learnersList().size());
        Iterator<String> iterator = request.learnersList().iterator();
        while (iterator.hasNext()) {
            PeerId peer = new PeerId();
            String peerStr = iterator.next();
            if (!peer.parse(peerStr)) {
                return RaftRpcFactory.DEFAULT.newResponse(this.msgFactory(), RaftError.EINVAL, "Fail to parse peer id %s", peerStr);
            }
            removeingLearners.add(peer);
        }
        LOG.info("Receive RemoveLearnersRequest to {} from {}, removing {}.", new Object[]{ctx.node.getNodeId(), done.getRpcCtx().getRemoteAddress(), removeingLearners});
        ctx.node.removeLearners(removeingLearners, status -> {
            if (!status.isOk()) {
                done.run(status);
            } else {
                ArrayList<String> oldLearnersList = new ArrayList<String>();
                ArrayList<String> newLearnersList = new ArrayList<String>();
                for (PeerId peer : oldLearners) {
                    oldLearnersList.add(peer.toString());
                    if (removeingLearners.contains(peer)) continue;
                    newLearnersList.add(peer.toString());
                }
                CliRequests.LearnersOpResponse response = this.msgFactory().learnersOpResponse().oldLearnersList(oldLearnersList).newLearnersList(newLearnersList).build();
                done.sendResponse(response);
            }
        });
        return null;
    }

    @Override
    public String interest() {
        return CliRequests.RemoveLearnersRequest.class.getName();
    }
}

