/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.raft.util;

import java.lang.invoke.MethodHandles;
import java.lang.invoke.VarHandle;
import java.nio.ByteBuffer;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.ignite.internal.raft.util.OptimizedMarshaller;
import org.jetbrains.annotations.Nullable;

public class DefaultByteBuffersPool
implements OptimizedMarshaller.ByteBuffersPool {
    private final int capacity;
    private static final VarHandle STACK;
    private volatile Node stack;
    private final AtomicInteger size = new AtomicInteger();

    public DefaultByteBuffersPool(int capacity) {
        this.capacity = capacity;
    }

    @Override
    @Nullable
    public ByteBuffer borrow() {
        ByteBuffer buffer = this.poll();
        if (buffer != null) {
            return buffer;
        }
        if (this.size.get() < this.capacity && this.size.getAndIncrement() < this.capacity) {
            return ByteBuffer.allocate(1024).order(OptimizedMarshaller.ORDER);
        }
        return null;
    }

    @Override
    public void release(ByteBuffer buffer) {
        Node node;
        Node prev;
        assert (buffer.position() == 0);
        assert (buffer.capacity() <= 262144);
        while (!STACK.compareAndSet(this, prev = this.stack, node = new Node(buffer, prev))) {
        }
    }

    @Nullable
    private ByteBuffer poll() {
        Node node;
        do {
            if ((node = this.stack) != null) continue;
            return null;
        } while (!STACK.compareAndSet(this, node, node.next));
        return node.buffer;
    }

    static {
        try {
            STACK = MethodHandles.lookup().findVarHandle(DefaultByteBuffersPool.class, "stack", Node.class);
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }

    private static final class Node {
        final ByteBuffer buffer;
        final Node next;

        Node(ByteBuffer buffer, Node next) {
            this.buffer = buffer;
            this.next = next;
        }
    }
}

