/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.configuration.exception.handler;

import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.HttpResponse;
import io.micronaut.http.server.exceptions.ExceptionHandler;
import jakarta.inject.Singleton;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.ignite.internal.configuration.exception.ConfigurationValidationIgniteException;
import org.apache.ignite.internal.rest.api.InvalidParam;
import org.apache.ignite.internal.rest.api.Problem;
import org.apache.ignite.internal.rest.constants.HttpCode;
import org.apache.ignite.internal.rest.problem.HttpProblemResponse;
import org.apache.ignite.lang.IgniteException;

@Singleton
@Requires(classes={ConfigurationValidationExceptionHandler.class, ExceptionHandler.class})
public class ConfigurationValidationExceptionHandler
implements ExceptionHandler<ConfigurationValidationIgniteException, HttpResponse<? extends Problem>> {
    public HttpResponse<? extends Problem> handle(HttpRequest request, ConfigurationValidationIgniteException exception) {
        return HttpProblemResponse.from((Problem)Problem.fromIgniteException((IgniteException)exception, (HttpCode)HttpCode.BAD_REQUEST).invalidParams(ConfigurationValidationExceptionHandler.mapValidationIssuesToRestFormat(exception)).build());
    }

    private static List<InvalidParam> mapValidationIssuesToRestFormat(ConfigurationValidationIgniteException exception) {
        return exception.issues().stream().map(validationIssue -> new InvalidParam(validationIssue.key(), validationIssue.message())).collect(Collectors.toList());
    }
}

