/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ignite.internal.rest.authentication;

import io.micronaut.context.annotation.Replaces;
import io.micronaut.context.annotation.Requires;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.MutableHttpResponse;
import io.micronaut.http.annotation.Filter;
import io.micronaut.http.filter.HttpServerFilter;
import io.micronaut.http.filter.ServerFilterChain;
import io.micronaut.security.config.SecurityConfiguration;
import io.micronaut.security.filters.AuthenticationFetcher;
import io.micronaut.security.filters.SecurityFilter;
import io.micronaut.security.rules.SecurityRule;
import java.util.Collection;
import org.apache.ignite.internal.rest.ResourceHolder;
import org.apache.ignite.internal.rest.authentication.IgniteAuthenticationProvider;
import org.reactivestreams.Publisher;

@Replaces(value=SecurityFilter.class)
@Filter(value={"/**"})
@Requires(property="micronaut.security.enabled", value="true", defaultValue="true")
public class IgniteSecurityFilter
implements HttpServerFilter,
ResourceHolder {
    private final SecurityFilter securityFilter;
    private IgniteAuthenticationProvider igniteAuthenticationProvider;

    public IgniteSecurityFilter(Collection<SecurityRule> securityRules, Collection<AuthenticationFetcher> authenticationFetchers, SecurityConfiguration securityConfiguration, IgniteAuthenticationProvider igniteAuthenticationProvider) {
        this.securityFilter = new SecurityFilter(securityRules, authenticationFetchers, securityConfiguration);
        this.igniteAuthenticationProvider = igniteAuthenticationProvider;
    }

    public Publisher<MutableHttpResponse<?>> doFilter(HttpRequest<?> request, ServerFilterChain chain) {
        if (this.igniteAuthenticationProvider.authenticationEnabled()) {
            return this.securityFilter.doFilter(request, chain);
        }
        return chain.proceed(request);
    }

    public int getOrder() {
        return this.securityFilter.getOrder();
    }

    public void cleanResources() {
        this.igniteAuthenticationProvider = null;
    }
}

