/*
 * Decompiled with CFR 0.152.
 */
package io.micronaut.http.server.netty;

import io.micronaut.context.BeanLocator;
import io.micronaut.context.BeanProvider;
import io.micronaut.context.Qualifier;
import io.micronaut.core.annotation.AnnotationMetadata;
import io.micronaut.core.annotation.Internal;
import io.micronaut.core.annotation.NonNull;
import io.micronaut.core.io.buffer.ByteBuffer;
import io.micronaut.core.type.Argument;
import io.micronaut.core.util.CollectionUtils;
import io.micronaut.http.HttpRequest;
import io.micronaut.http.annotation.Body;
import io.micronaut.http.server.netty.DefaultHttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessor;
import io.micronaut.http.server.netty.HttpContentProcessorResolver;
import io.micronaut.http.server.netty.HttpContentSubscriberFactory;
import io.micronaut.http.server.netty.NettyHttpRequest;
import io.micronaut.http.server.netty.configuration.NettyHttpServerConfiguration;
import io.micronaut.inject.ExecutionHandle;
import io.micronaut.web.router.RouteMatch;
import io.micronaut.web.router.qualifier.ConsumesMediaTypeQualifier;
import jakarta.inject.Singleton;
import java.io.InputStream;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;

@Singleton
@Internal
class DefaultHttpContentProcessorResolver
implements HttpContentProcessorResolver {
    private static final Set<Class> RAW_BODY_TYPES = CollectionUtils.setOf((Object[])new Class[]{String.class, byte[].class, ByteBuffer.class, InputStream.class});
    private final BeanLocator beanLocator;
    private final BeanProvider<NettyHttpServerConfiguration> serverConfiguration;
    private NettyHttpServerConfiguration nettyServerConfiguration;

    DefaultHttpContentProcessorResolver(BeanLocator beanLocator, BeanProvider<NettyHttpServerConfiguration> serverConfiguration) {
        this.beanLocator = beanLocator;
        this.serverConfiguration = serverConfiguration;
    }

    @Override
    @NonNull
    public HttpContentProcessor<?> resolve(@NonNull NettyHttpRequest<?> request, @NonNull RouteMatch<?> route) {
        Argument bodyType = route.getBodyArgument().filter(argument -> {
            AnnotationMetadata annotationMetadata = argument.getAnnotationMetadata();
            if (annotationMetadata.hasAnnotation(Body.class)) {
                return !annotationMetadata.stringValue(Body.class).isPresent();
            }
            return false;
        }).orElseGet(() -> {
            if (route instanceof ExecutionHandle) {
                for (Argument argument : ((ExecutionHandle)route).getArguments()) {
                    if (argument.getType() != HttpRequest.class) continue;
                    return argument;
                }
            }
            return Argument.OBJECT_ARGUMENT;
        });
        return this.resolve(request, bodyType);
    }

    @Override
    @NonNull
    public HttpContentProcessor<?> resolve(@NonNull NettyHttpRequest<?> request, @NonNull Argument<?> bodyType) {
        if (bodyType.getType() == HttpRequest.class) {
            bodyType = bodyType.getFirstTypeVariable().orElse(Argument.OBJECT_ARGUMENT);
        }
        boolean isRaw = RAW_BODY_TYPES.contains(bodyType.getType());
        return this.resolve(request, isRaw);
    }

    @Override
    @NonNull
    public HttpContentProcessor<?> resolve(@NonNull NettyHttpRequest<?> request) {
        return this.resolve(request, false);
    }

    private HttpContentProcessor<?> resolve(NettyHttpRequest<?> request, boolean rawBodyType) {
        Supplier<DefaultHttpContentProcessor> defaultHttpContentProcessor = () -> new DefaultHttpContentProcessor(request, this.getServerConfiguration());
        if (rawBodyType) {
            return defaultHttpContentProcessor.get();
        }
        Optional contentType = request.getContentType();
        return contentType.flatMap(type -> this.beanLocator.findBean(HttpContentSubscriberFactory.class, (Qualifier)new ConsumesMediaTypeQualifier(type))).map(factory -> factory.build(request)).orElseGet(defaultHttpContentProcessor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private NettyHttpServerConfiguration getServerConfiguration() {
        NettyHttpServerConfiguration nettyHttpServerConfiguration = this.nettyServerConfiguration;
        if (nettyHttpServerConfiguration == null) {
            DefaultHttpContentProcessorResolver defaultHttpContentProcessorResolver = this;
            synchronized (defaultHttpContentProcessorResolver) {
                nettyHttpServerConfiguration = this.nettyServerConfiguration;
                if (nettyHttpServerConfiguration == null) {
                    this.nettyServerConfiguration = nettyHttpServerConfiguration = (NettyHttpServerConfiguration)((Object)this.serverConfiguration.get());
                }
            }
        }
        return nettyHttpServerConfiguration;
    }
}

